clear
load_15
load_24_fixed
load_24_vari

figure
hold on
box on
plot(c15_hg_exp(:,3), c15_hg_exp(:,1), 'ko', 'MarkerSize', 5, 'MarkerFaceColor', 'black', 'LineWidth', 1)
plot(c24_hg_exp(:,3), c24_hg_exp(:,1), 'ko', 'MarkerSize', 5, 'LineWidth', 1)
plot(hg_15(:,1), hg_15(:,2), 'k-', hg_24(:,1), hg_24(:,2), 'k-', 'LineWidth', 1);
xlim([0.0 1.0]);
ylim([0.0 1.0E07]);
set(gca,'YTick',0:1.0E06:1.0E07)
set(gca,'XTick',0:0.2:1.0)
set(gca,'FontName', 'helvetica')
set(gca,'FontSize', 16)
set(gca, 'LineWidth', 1)
xlabel('Air Saturation')
ylabel('Capillary Pressure (Pa)')
m_l = legend('Exp. Sample 1', 'Exp. Sample 2', 'Predicted', 1);
set(m_l, 'LineWidth', 1)

set(gcf, 'PaperPositionMode', 'auto');
print -r1200 -deps2 -tiff hg_phd

figure
hold on
box on
plot(c15_drainage_exp(:,1), c15_drainage_exp(:,3), 'ko', 'MarkerSize', 5, 'LineWidth', 1)
plot(drain_15(:,1), drain_15(:,3), 'k-', 'LineWidth', 1);
plot(c15_drainage_exp(:,1), c15_drainage_exp(:,4), 'ko', 'MarkerSize', 5, 'MarkerFaceColor', 'black', 'LineWidth', 1)
plot(drain_15(:,1), drain_15(:,4), 'k-', 'LineWidth', 1);
xlim([0.0 1.0]);
ylim([0.0 1.0]);
set(gca,'YTick',0:0.2:1.0)
set(gca,'XTick',0:0.2:1.0)
set(gca,'FontName', 'helvetica')
set(gca,'FontSize', 16)
set(gca, 'LineWidth', 1)
xlabel('Water Saturation')
ylabel('Relative Permeability')
m_l = legend('Exp. k_{rw}', 'Exp. k_{ro}', 'Predicted', 1);
set(m_l, 'LineWidth', 1)
set(m_l, 'FontSize', 16)

set(gcf, 'PaperPositionMode', 'auto');
print -r1200 -deps2 -tiff drain_phd

figPos = [10 10 500 1000];
figure('Position', figPos)

subplot(3, 1 ,1)
hold on
box on
plot(c15_watflood_exp(:,1), c15_watflood_exp(:,3), 'ko', 'MarkerSize', 5, 'LineWidth', 1);
plot(c15_watflood_exp(:,1), c15_watflood_exp(:,4), 'ko', 'MarkerSize', 5, 'MarkerFaceColor', 'black', 'LineWidth', 1);
plot(krw_imb_15(:,1), krw_imb_15(:,2), 'k-', kro_imb_15(:,1), kro_imb_15(:,2), 'k-', 'LineWidth', 1)
d = errorbar(krw_imb_15(1:10:size(krw_imb_15),1), krw_imb_15(1:10:size(krw_imb_15),2), krw_imb_15(1:10:size(krw_imb_15),3), 'k.');
h = errorbar(kro_imb_15(1:10:size(kro_imb_15),1), kro_imb_15(1:10:size(kro_imb_15),2), kro_imb_15(1:10:size(kro_imb_15),3), 'k.');
set(d, 'MarkerSize', 0.001)
set(h, 'MarkerSize', 0.001)
set(d,  'LineWidth', 1)
set(h,  'LineWidth', 1)
xlim([0.0 1.0]);
ylim([0.0 1.0]);
set(gca,'YTick',0:0.2:1.0)
set(gca,'XTick',0:0.2:1.0)
set(gca,'FontName', 'helvetica')
set(gca,'FontSize', 14)
set(gca, 'LineWidth', 1)
xlabel('Water Saturation')
ylabel('Relative Permeability')
text(0.05, 0.07, '(a)', 'FontName', 'helvetica', 'FontSize', 14)

subplot(3, 1 ,2)
hold on
box on
plot(c24_watflood_exp(:,1), c24_watflood_exp(:,3), 'ko', 'MarkerSize', 5, 'LineWidth', 1);
plot(c24_watflood_exp(:,1), c24_watflood_exp(:,4), 'ko', 'MarkerSize', 5, 'MarkerFaceColor', 'black', 'LineWidth', 1);
plot(krw_imb_24_fixed(:,1), krw_imb_24_fixed(:,2), 'k-', kro_imb_24_fixed(:,1), kro_imb_24_fixed(:,2), 'k-', 'LineWidth', 1)
d = errorbar(krw_imb_24_fixed(1:10:size(krw_imb_24_fixed),1), krw_imb_24_fixed(1:10:size(krw_imb_24_fixed),2), krw_imb_24_fixed(1:10:size(krw_imb_24_fixed),3), 'k.');
h = errorbar(kro_imb_24_fixed(1:10:size(kro_imb_24_fixed),1), kro_imb_24_fixed(1:10:size(kro_imb_24_fixed),2), kro_imb_24_fixed(1:10:size(kro_imb_24_fixed),3), 'k.');
set(d, 'MarkerSize', 0.001)
set(h, 'MarkerSize', 0.001)
set(d,  'LineWidth', 1)
set(h,  'LineWidth', 1)
xlim([0.0 1.0]);
ylim([0.0 1.0]);
set(gca,'YTick',0:0.2:1.0)
set(gca,'XTick',0:0.2:1.0)
set(gca,'FontName', 'helvetica')
set(gca,'FontSize', 14)
set(gca, 'LineWidth', 1)
xlabel('Water Saturation')
ylabel('Relative Permeability')
text(0.05, 0.07, '(b)', 'FontName', 'helvetica', 'FontSize', 14)

subplot(3, 1 ,3)
hold on
box on
plot(c24_watflood_exp(:,1), c24_watflood_exp(:,3), 'ko', 'MarkerSize', 5, 'LineWidth', 1);
plot(c24_watflood_exp(:,1), c24_watflood_exp(:,4), 'ko', 'MarkerSize', 5, 'MarkerFaceColor', 'black', 'LineWidth', 1);
plot(krw_imb_24_vari(:,1), krw_imb_24_vari(:,2), 'k-', kro_imb_24_vari(:,1), kro_imb_24_vari(:,2), 'k-', 'LineWidth', 1)
d = errorbar(krw_imb_24_vari(1:10:size(krw_imb_24_vari),1), krw_imb_24_vari(1:10:size(krw_imb_24_vari),2), krw_imb_24_vari(1:10:size(krw_imb_24_vari),3), 'k.');
h = errorbar(kro_imb_24_vari(1:10:size(kro_imb_24_vari),1), kro_imb_24_vari(1:10:size(kro_imb_24_vari),2), kro_imb_24_vari(1:10:size(kro_imb_24_vari),3), 'k.');
set(d, 'MarkerSize', 0.001)
set(h, 'MarkerSize', 0.001)
set(d,  'LineWidth', 1)
set(h,  'LineWidth', 1)
xlim([0.0 1.0]);
ylim([0.0 1.0]);
set(gca,'YTick',0:0.2:1.0)
set(gca,'XTick',0:0.2:1.0)
set(gca,'FontName', 'helvetica')
set(gca,'FontSize', 14)
set(gca, 'LineWidth', 1)
xlabel('Water Saturation')
ylabel('Relative Permeability')
m_l = legend('Exp. k_{rw}', 'Exp. k_{ro}', 'Predicted', 1);
set(m_l, 'LineWidth', 1)
set(m_l, 'FontSize', 14)
text(0.05, 0.07, '(c)', 'FontName', 'helvetica', 'FontSize', 14)

set(gcf, 'PaperPositionMode', 'auto');
print -r1200 -deps2 -tiff kr_phd

figPos = [10 10 500 1000];
figure('Position', figPos)

subplot(3, 1 ,1)
hold on
box on
plot(c15_si_exp(:,1), c15_si_exp(:,2), 'ko', 'MarkerSize', 5, 'LineWidth', 1);
plot(c15_sd_exp(:,1), c15_sd_exp(:,2), 'ko', 'MarkerSize', 5, 'MarkerFaceColor', 'black', 'LineWidth', 1);
plot(pc_imb_15(:,1), pc_imb_15(:,2), 'k-', pc_drain_15(:,1), pc_drain_15(:,2), 'k:', [0 1], [0 0], 'k-','LineWidth', 1)
d = errorbar(pc_imb_15(1:10:size(pc_imb_15),1), pc_imb_15(1:10:size(pc_imb_15),2), pc_imb_15(1:10:size(pc_imb_15),3), 'k.');
h = errorbar(pc_drain_15(1:10:size(pc_drain_15),1), pc_drain_15(1:10:size(pc_drain_15),2), pc_drain_15(1:10:size(pc_drain_15),3), 'k.');
set(d, 'MarkerSize', 0.001)
set(h, 'MarkerSize', 0.001)
set(d,  'LineWidth', 1)
set(h,  'LineWidth', 1)
xlim([0.0 1.0]);
ylim([-4.0E5 8.0E5]);
set(gca,'YTick',-4.0E5:2.0E5:8.0E5)
set(gca,'XTick',0:0.2:1.0)
set(gca,'FontName', 'helvetica')
set(gca,'FontSize', 14)
set(gca, 'LineWidth', 1)
xlabel('Water Saturation')
ylabel('Capillary Pressure (Pa)')

subplot(3, 1 ,2)
hold on
box on
plot(c24_si_exp(:,1), c24_si_exp(:,2), 'ko', 'MarkerSize', 5, 'LineWidth', 1);
plot(c24_sd_exp(:,1), c24_sd_exp(:,2), 'ko', 'MarkerSize', 5, 'MarkerFaceColor', 'black', 'LineWidth', 1);
plot(pc_imb_24_fixed(:,1), pc_imb_24_fixed(:,2), 'k-', pc_drain_24_fixed(:,1), pc_drain_24_fixed(:,2), 'k:', [0 1], [0 0], 'k-','LineWidth', 1)
d = errorbar(pc_imb_24_fixed(1:10:size(pc_imb_24_fixed),1), pc_imb_24_fixed(1:10:size(pc_imb_24_fixed),2), pc_imb_24_fixed(1:10:size(pc_imb_24_fixed),3), 'k.');
h = errorbar(pc_drain_24_fixed(1:10:size(pc_drain_24_fixed),1), pc_drain_24_fixed(1:10:size(pc_drain_24_fixed),2), pc_drain_24_fixed(1:10:size(pc_drain_24_fixed),3), 'k.');
set(d, 'MarkerSize', 0.001)
set(h, 'MarkerSize', 0.001)
set(d,  'LineWidth', 1)
set(h,  'LineWidth', 1)
xlim([0.0 1.0]);
ylim([-4.0E5 8.0E5]);
set(gca,'YTick',-4.0E5:2.0E5:8.0E5)
set(gca,'XTick',0:0.2:1.0)
set(gca,'FontName', 'helvetica')
set(gca,'FontSize', 14)
set(gca, 'LineWidth', 1)
xlabel('Water Saturation')
ylabel('Capillary Pressure (Pa)')

subplot(3, 1 ,3)
hold on
box on
plot(c24_si_exp(:,1), c24_si_exp(:,2), 'ko', 'MarkerSize', 5, 'LineWidth', 1);
plot(c24_sd_exp(:,1), c24_sd_exp(:,2), 'ko', 'MarkerSize', 5, 'MarkerFaceColor', 'black', 'LineWidth', 1);
plot(pc_imb_24_vari(:,1), pc_imb_24_vari(:,2), 'k-', pc_drain_24_vari(:,1), pc_drain_24_vari(:,2), 'k:', [0 1], [0 0], 'k-', 'LineWidth', 1)
d = errorbar(pc_imb_24_vari(1:10:size(pc_imb_24_vari),1), pc_imb_24_vari(1:10:size(pc_imb_24_vari),2), pc_imb_24_vari(1:10:size(pc_imb_24_vari),3), 'k.');
h = errorbar(pc_drain_24_vari(1:10:size(pc_drain_24_vari),1), pc_drain_24_vari(1:10:size(pc_drain_24_vari),2), pc_drain_24_vari(1:10:size(pc_drain_24_vari),3), 'k.');
set(d, 'MarkerSize', 0.001)
set(h, 'MarkerSize', 0.001)
set(d,  'LineWidth', 1)
set(h,  'LineWidth', 1)
xlim([0.0 1.0]);
ylim([-4.0E5 8.0E5]);
set(gca,'YTick',-4.0E5:2.0E5:8.0E5)
set(gca,'XTick',0:0.2:1.0)
set(gca,'FontName', 'helvetica')
set(gca,'FontSize', 14)
set(gca, 'LineWidth', 1)
xlabel('Water Saturation')
ylabel('Capillary Pressure (Pa)')
m_l = legend('Exp. Water Flood', 'Exp. Oil Flood', 'Pred. Water Flood', 'Pred. Oil Flood', 1);
set(m_l, 'LineWidth', 1)
set(m_l, 'FontSize', 14)

set(gcf, 'PaperPositionMode', 'auto');
print -r1200 -deps2 -tiff pc_phd

