clear
sst_data
load_corr
load_rmin
load_rmax

figPos = [10 10 500 1000];
figure('Position', figPos)

subplot(3, 1 ,1)
hold on
box on
plot(sst_wat(:,1), sst_wat(:,2), 'ko', 'MarkerSize', 5, 'LineWidth', 1);
plot(sst_oil(:,1), sst_oil(:,2), 'ko', 'MarkerFaceColor', 'black', 'MarkerSize', 5);
plot(kro_imb_rmax(:,1), kro_imb_rmax(:,2), 'k-', krw_imb_rmax(:,1), krw_imb_rmax(:,2), 'k-', 'LineWidth', 1);
d = errorbar(kro_imb_rmax(1:8:size(kro_imb_rmax),1), kro_imb_rmax(1:8:size(kro_imb_rmax),2), ...
    kro_imb_rmax(1:8:size(kro_imb_rmax),3), 'k.');
h = errorbar(krw_imb_rmax(1:8:size(krw_imb_rmax),1), krw_imb_rmax(1:8:size(krw_imb_rmax),2), ...
    krw_imb_rmax(1:8:size(krw_imb_rmax),3), 'k.');
set(d, 'MarkerSize', 0.001)
set(h, 'MarkerSize', 0.001)
set(d,  'LineWidth', 1)
set(h,  'LineWidth', 1)
xlim([0 1.0]);
ylim([0.0 1.0]);
set(gca,'YTick',0:0.2:1.0)
set(gca,'XTick',0:0.2:1.0)
set(gca,'FontName', 'helvetica')
set(gca,'FontSize', 14)
set(gca, 'LineWidth', 1)
xlabel('Water Saturation')
ylabel('Relative Permeability')
m_l = legend('Exp. k_{rw}', 'Exp. k_{ro}', 'r_{max}', 1);
set(m_l, 'LineWidth', 1)
set(m_l, 'FontSize', 14)
text(0.05, 0.07, '(a)', 'FontName', 'helvetica', 'FontSize', 14)

subplot(3, 1 ,2)
hold on
box on
plot(sst_wat(:,1), sst_wat(:,2), 'ko', 'MarkerSize', 5, 'LineWidth', 1);
plot(sst_oil(:,1), sst_oil(:,2), 'ko', 'MarkerFaceColor', 'black', 'MarkerSize', 5);
plot(kro_imb_rmin(:,1), kro_imb_rmin(:,2), 'k-', krw_imb_rmin(:,1), krw_imb_rmin(:,2), 'k-', 'LineWidth', 1);
d = errorbar(kro_imb_rmin(1:8:size(kro_imb_rmin),1), kro_imb_rmin(1:8:size(kro_imb_rmin),2), ...
    kro_imb_rmin(1:8:size(kro_imb_rmin),3), 'k.');
h = errorbar(krw_imb_rmin(1:8:size(krw_imb_rmin),1), krw_imb_rmin(1:8:size(krw_imb_rmin),2), ...
    krw_imb_rmin(1:8:size(krw_imb_rmin),3), 'k.');
set(d, 'MarkerSize', 0.001)
set(h, 'MarkerSize', 0.001)
set(d,  'LineWidth', 1)
set(h,  'LineWidth', 1)
xlim([0 1.0]);
ylim([0.0 1.0]);
set(gca,'YTick',0:0.2:1.0)
set(gca,'XTick',0:0.2:1.0)
set(gca,'FontName', 'helvetica')
set(gca,'FontSize', 14)
set(gca, 'LineWidth', 1)
xlabel('Water Saturation')
ylabel('Relative Permeability')
m_l = legend('Exp. k_{rw}', 'Exp. k_{ro}', 'r_{min}', 1);
set(m_l, 'LineWidth', 1)
set(m_l, 'FontSize', 14)
text(0.05, 0.07, '(b)', 'FontName', 'helvetica', 'FontSize', 14)


subplot(3, 1 ,3)
hold on
box on
plot(sst_wat(:,1), sst_wat(:,2), 'ko', 'MarkerSize', 5, 'LineWidth', 1);
plot(sst_oil(:,1), sst_oil(:,2), 'ko', 'MarkerFaceColor', 'black', 'MarkerSize', 5);
plot(kro_imb_corr(:,1), kro_imb_corr(:,2), 'k-', krw_imb_corr(:,1), krw_imb_corr(:,2), 'k-', 'LineWidth', 1);
d = errorbar(kro_imb_corr(1:8:size(kro_imb_corr),1), kro_imb_corr(1:8:size(kro_imb_corr),2), ...
    kro_imb_corr(1:8:size(kro_imb_corr),3), 'k.');
h = errorbar(krw_imb_corr(1:8:size(krw_imb_corr),1), krw_imb_corr(1:8:size(krw_imb_corr),2), ...
    krw_imb_corr(1:8:size(krw_imb_corr),3), 'k.');
set(d, 'MarkerSize', 0.001)
set(h, 'MarkerSize', 0.001)
set(d,  'LineWidth', 1)
set(h,  'LineWidth', 1)
xlim([0 1.0]);
ylim([0.0 1.0]);
set(gca,'YTick',0:0.2:1.0)
set(gca,'XTick',0:0.2:1.0)
set(gca,'FontName', 'helvetica')
set(gca,'FontSize', 14)
set(gca, 'LineWidth', 1)
xlabel('Water Saturation')
ylabel('Relative Permeability')
m_l = legend('Exp. k_{rw}', 'Exp. k_{ro}', 'Spatial', 1);
set(m_l, 'LineWidth', 1)
set(m_l, 'FontSize', 14)
text(0.05, 0.07, '(c)', 'FontName', 'helvetica', 'FontSize', 14)

set(gcf, 'PaperPositionMode', 'auto');
print -r1200 -deps2 -tiff kr_phd

