clear
swi_034_draincycle_2
swi_034_imbcycle_2

visc_wat = 0.991;
visc_oil = 5.23;
dat = Res_draincycle_2;
watdat = Res_imb_2;
ds_win = 3;

numDat = size(dat);
dat(:,1) = 1.0 - dat(:,1);
dat = sortrows(dat, 1);

fo = 1 ./ (1 + (dat(:,3).*visc_oil)./(dat(:,4).*visc_wat));
soi = dat(1,1);
k_sh = 1;

for k=1:numDat(1)
    low_b = max(1, k - (ds_win-1)/2);
    high_b = min(numDat(1), k + (ds_win-1)/2);
    p = polyfit(dat(low_b:high_b,1), fo(low_b:high_b), 1);
    fo_ds(k) = p(1);
end

td = 1./fo_ds;

for k=1:numDat(1)
    NpD(k) = dat(k, 1) - soi + (1-fo(k))*(1/fo_ds(k));
    wat_rf(k) = NpD(k)/(1-soi);
end

for k=numDat(1):-1:2
    if td(k) < NpD(k)
        k_sh = k;
        break;
    end
end

for k=numDat(1):-1:2
    if fo(k) < 0.99
        sprintf('Sw at fo = 0.99 is %f', 1-dat(k, 1))
        break;
    end
end


for k=numDat(1)-1:-1:2
    if td(k) < 20 & td(k+1) > 20
        so20 = interp1(td(k:k+1), dat(k:k+1, 1), 20);
        sprintf('Sw at 20 PVI %f', 1-so20)
        break;
    end
end

sprintf('Shock front saturation %f', dat(k_sh, 1))
sprintf('Pore Volumes Injected %f', td(numDat(1)))


figure('Position', [50 50 700 800])
subplot(2,2,1)
plot(dat(:,1), dat(:, 3), 'b-o', dat(:,1), dat(:, 4), 'b-o', dat(:,1), fo, 'k-*');
xlabel('Oil Saturation')
ylabel('Relative Permeability / Fractional Flow')
xlim([0  1])
ylim([0  1])

subplot(2,2,2)
plot(td(k_sh:numDat(1)), wat_rf(k_sh:numDat(1)), 'b--*')
xlabel('Pore Volumes Injected')
ylabel('Oil Recovery')
xlim([0  5])
ylim([0  1])

subplot(2,2,3)
plot(td(k_sh:numDat(1)), dat(k_sh:numDat(1),1), 'b--*');
xlabel('Pore Volumes Injected')
ylabel('Oil Saturation')
xlim([0  30])
ylim([0  1])

subplot(2,2,4)
plot(1-dat(:,1), dat(:,2), 'b-o', watdat(:,1), watdat(:,2), 'k-s');
xlabel('Water Saturation')
ylabel('Capillary Pressure (Pa)')
xlim([0  1])
legend('Secondary Drainage','Secondary Waterflooding', 0)
grid on

