clear
swi_027_imbcycle_2
visc_wat = 0.991;
visc_oil = 5.23;
dat = Res_imb_2;
ds_win = 5;

numDat = size(dat);
fw = 1 ./ (1 + (dat(:,4).*visc_wat)./(dat(:,3).*visc_oil));
swi = dat(1,1);
k_sh = 1;

for k=1:numDat(1)
    low_b = max(1, k - (ds_win-1)/2);
    high_b = min(numDat(1), k + (ds_win-1)/2);
    p = polyfit(dat(low_b:high_b,1), fw(low_b:high_b), 1);
    fw_ds(k) = p(1);
end

td = 1./fw_ds;

for k=1:numDat(1)
    NpD(k) = dat(k, 1) - swi + (1-fw(k))*(1/fw_ds(k));
    oil_rf(k) = NpD(k)/(1-swi);
end

for k=numDat(1):-1:2
    if td(k) < NpD(k)
        k_sh = k;
        break;
    end
end

for k=numDat(1)-1:-1:1
    if td(k) < 20 & td(k+1) > 20
        sw20 = interp1(td(k:k+1), dat(k:k+1, 1), 20);
        rf20 = interp1(td(k:k+1), oil_rf(k:k+1), 20);
        sprintf('Sw at 20 PVI %f', sw20)
        sprintf('Recovery factor at 20 PVI %f', rf20)
        break;
    end
end

for k=numDat(1)-1:-1:1
    if td(k) < 3 & td(k+1) > 3
        sw3 = interp1(td(k:k+1), dat(k:k+1, 1), 3);
        rf3 = interp1(td(k:k+1), oil_rf(k:k+1), 3);
        sprintf('Sw at 3 PVI %f', sw3)
        sprintf('Recovery factor at 3 PVI %f', rf3)
        break;
    end
end

sprintf('Shock front saturation %f', dat(k_sh, 1))
sprintf('Pore Volumes Injected %f', td(numDat(1)))

rec_data(1,:) = dat(k_sh:numDat(1),1)';
rec_data(2,:) = td(k_sh:numDat(1));
rec_data(3,:) = oil_rf(k_sh:numDat(1));

figure('Position', [50 50 700 800])

subplot(2,2,1)
plot(dat(:,1), dat(:, 3), 'b-o', dat(:,1), dat(:, 4), 'b-o', dat(:,1), fw, 'k-*');
xlabel('Water Saturation')
ylabel('Relative Permeability / Fractional Flow')
xlim([0  1])
ylim([0  1])

subplot(2,2,2)
plot(dat(:,1), dat(:, 2), 'b-o');
xlabel('Water Saturation')
ylabel('Capillary Pressure')
xlim([0  1])

subplot(2,2,3)
plot(td(k_sh:numDat(1)), oil_rf(k_sh:numDat(1)), 'b--*')
xlabel('Pore Volumes Injected')
ylabel('Oil Recovery')
xlim([0  5])
ylim([0  1])

subplot(2,2,4)
plot(td(k_sh:numDat(1)), dat(k_sh:numDat(1),1), 'b--*');
xlabel('Pore Volumes Injected')
ylabel('Water Saturation')
xlim([0  30])
ylim([0  1])



