clear

cd fixed_wet
swi_008_hr_imbcycle_2
swi_008_hr_draincycle_2
swi_008_hr_imbcycle_3
secImb_08 = Res_imb_2;
secDrain_08 = Res_draincycle_2;
terImb_08 = Res_imb_3;

swi_018_hr_imbcycle_2
swi_018_hr_draincycle_2
swi_018_hr_imbcycle_3
secImb_18 = Res_imb_2;
secDrain_18 = Res_draincycle_2;
terImb_18 = Res_imb_3;

swi_031_hr_imbcycle_2
swi_031_hr_draincycle_2
swi_031_hr_imbcycle_3
secImb_31 = Res_imb_2;
secDrain_31 = Res_draincycle_2;
terImb_31 = Res_imb_3;

fracFlow
cd ..

figPos = [10 10 1200 900];
figure('Position', figPos)

subplot(2, 2 ,1)
hold on
box on
plot(secImb_08(:,1), secImb_08(:,3), 'k-', secImb_18(:,1), secImb_18(:,3), 'k-.', secImb_31(:,1), secImb_31(:,3), 'k--', 'LineWidth', 1)
xlim([0 1.0]);
ylim([0.0 1.0]);
set(gca,'YTick',0:0.2:1.0)
set(gca,'XTick',0:0.2:1.0)
set(gca,'FontName', 'helvetica')
set(gca,'FontSize', 14)
set(gca, 'LineWidth', 1)
xlabel('Water Saturation')
ylabel('Water Relative Permeability')
m_l = legend('S_{wi}= S_{wc}= 0.08', 'S_{wi} = 0.18', 'S_{wi} = 0.31', 2);
set(m_l, 'LineWidth', 1)
text(0.9, 0.9, '(a)', 'FontName', 'helvetica', 'FontSize', 14)

subplot(2, 2 ,2)
hold on
box on
plot(secImb_08(:,1), secImb_08(:,4), 'k-', secImb_18(:,1), secImb_18(:,4), 'k-.', secImb_31(:,1), secImb_31(:,4), 'k--', 'LineWidth', 1)
xlim([0 1.0]);
ylim([0.0 1.0]);
set(gca,'YTick',0:0.2:1.0)
set(gca,'XTick',0:0.2:1.0)
set(gca,'FontName', 'helvetica')
set(gca,'FontSize', 14)
set(gca, 'LineWidth', 1)
xlabel('Water Saturation')
ylabel('Oil Relative Permeability')
text(0.9, 0.9, '(b)', 'FontName', 'helvetica', 'FontSize', 14)

subplot(2, 2 ,3)
hold on
box on
plot(fw_008(:,1), fw_008(:,2), 'k-', fw_018(:,1), fw_018(:,2), 'k-.', fw_031(:,1), fw_031(:,2), 'k--', 'LineWidth', 1)
xlim([0 1.0]);
ylim([0.0 1.0]);
set(gca,'YTick',0:0.2:1.0)
set(gca,'XTick',0:0.2:1.0)
set(gca,'FontName', 'helvetica')
set(gca,'FontSize', 14)
set(gca, 'LineWidth', 1)
xlabel('Water Saturation')
ylabel('Fractional Water Flow')
text(0.9, 0.9, '(c)', 'FontName', 'helvetica', 'FontSize', 14)

subplot(2, 2 ,4)
hold on
box on
plot(secDrain_08(:,1), secDrain_08(:,2), 'k-', terImb_08(:,1), terImb_08(:,2), 'k-', 'LineWidth', 1)
plot(secDrain_18(:,1), secDrain_18(:,2), 'k-.', terImb_18(:,1), terImb_18(:,2), 'k-.', 'LineWidth', 1)
plot(secDrain_31(:,1), secDrain_31(:,2), 'k--', terImb_31(:,1), terImb_31(:,2), 'k--', 'LineWidth', 1)
plot([0 1], [0 0], 'k-', 'LineWidth', 1)
xlim([0 1.0]);
ylim([-2000.0 10000.0]);
set(gca,'YTick',-2000:2000:10000)
set(gca,'XTick',0:0.2:1.0)
set(gca,'FontName', 'helvetica')
set(gca,'FontSize', 14)
set(gca, 'LineWidth', 1)
xlabel('Water Saturation')
ylabel('Capillary Pressure (Pa)')
text(0.9, 8800, '(d)', 'FontName', 'helvetica', 'FontSize', 14)

set(gcf, 'PaperPositionMode', 'auto');
print -r1200 -deps2 -tiff kr_pc_phd



