clear
cd 'inf_pvi_swc=7.6'
oren_3_wett
cd '../inf_pvi_swc=swi'
oren_4_wett
cd '../inf_pvi_rmin'
oren_rmin_wett
cd ..

oren_3_wwfrac = ((oren_3_data(:,1)-0.079) + (1-oren_3_data(:,9)).*(1-oren_3_data(:,1)))./(1-0.079);
oren_rmin_wwfrac = ((oren_rmin_data(:,1)-0.079) + (1-oren_rmin_data(:,9)).*(1-oren_rmin_data(:,1)))./(1-0.079);

figure
hold on
box on
plot(oren_3_wwfrac, oren_3_data(:,5), 'ko', 'LineWidth', 1, 'MarkerSize', 5)
plot(oren_rmin_wwfrac, oren_rmin_data(:,5), 'ks', 'LineWidth', 1, 'MarkerSize', 5)
plot(1.0-oren_4_data(:,9), oren_4_data(:,5), 'ko', 'MarkerFaceColor', 'black', 'LineWidth', 1, 'MarkerSize', 5)
xlim([0.0 0.5]);
ylim([0.5 0.9]);
set(gca,'YTick',0:0.1:1.0)
set(gca,'XTick',-1.0:0.1:1.0)
set(gca,'FontName', 'helvetica')
set(gca,'FontSize', 16)
set(gca, 'LineWidth', 1)
xlabel('Water-Wet Pore Space at Swi')
ylabel('Oil Recovery (Fraction of OIP)')
m_l = legend('Infinite PVI', 'rmin corr.', 'Swi = Swc', 1)
set(m_l, 'LineWidth', 1)

set(gcf, 'PaperPositionMode', 'auto');
print -r1200 -deps2 -tiff rf_i_oren

