#ifndef __AMG_prototypes_h__
#define __AMG_prototypes_h__

// ANSI C++ compatible version of f2c port of NETLIB AMG solver
// function prototypes
// The license only allows for academic use
/* ----------------------------------------------------------------------- */

/*     INPUT VIA ARRAYS (SEE ABOVE): */

/*     A        -   MATRIX L */
/*     IA       -   POINTER VECTOR */
/*     JA       -   POINTER VECTOR */
/*     U        -   FIRST APPROXIMATION TO SOLUTION */
/*     F        -   RIGHT HAND SIDE */


/* ----------------------------------------------------------------------- */


/*     SCALAR INPUT PARAMETERS OF AUX1R5: */

/*     THE INPUT PARAMETERS OF AUX1R5 IN THE LIST BELOW ARE ARRANGED */
/*     ACCORDING TO THEIR IMPORTANCE TO THE GENERAL USER. THE PARAMETERS 
*/
/*     PRECEEDED BY A * MUST BE SPECIFIED EXPLICITELY (DEFINITION OF THE 
*/
/*     USER-DEFINED PROBLEM AND DIMENSIONING OF VECTORS IN THE CALLING */
/*     PROGRAM). THE OTHER PARAMETERS ARE SET TO STANDARD VALUES IF ZERO 
*/
/*     ON INPUT. */


/*  *  NDA      -   DIMENSIONING OF VECTOR A IN CALLING PROGRAM */
/*  *  NDIA     -   DIMENSIONING OF VECTOR IA IN CALLING PROGRAM */
/*  *  NDJA     -   DIMENSIONING OF VECTOR JA IN CALLING PROGRAM */
/*  *  NDU      -   DIMENSIONING OF VECTOR U IN CALLING PROGRAM */
/*  *  NDF      -   DIMENSIONING OF VECTOR F IN CALLING PROGRAM */
/*  *  NDIG     -   DIMENSIONING OF VECTOR IG IN CALLING PROGRAM */
/*  *  NNU      -   NUMBER OF UNKNOWNS */
/*  *  MATRIX   -   INTEGER VALUE CONTAINING INFO ABOUT THE MATRIX L. */

/*                  1ST DIGIT OF MATRIX  --  ISYM: */
/*                    =1: L IS SYMMETRIC; */
/*                    =2: L IS NOT SYMMETRIC. */

/*                  2ND DIGIT OF MATRIX  --  IROW0: */
/*                    =1: L HAS ROWSUM ZERO; */
/*                    =2: L DOES NOT HAVE ROWSUM ZERO. */


/*  *  EPS      -   CONVERGENCE CRITERION FOR SOLUTION PROCESS. STOP, IF */
/*                  L2-NORM OF THE RESIDUAL OF THE USER-DEFINED PROBLEM */
/*                  IS LESS THAN EPS. */

/*     IFIRST   -   PARAMETER FOR FIRST APPROXIMATION. */

/*                  1ST DIGIT OF IFIRST: NOT USED; HAS TO BE NON-ZERO. */

/*                  2ND DIGIT OF IFIRST  --  ITYPU: */
/*                    =0: NO SETTING OF FIRST APPROXIMATION, */
/*                    =1: FIRST APPROXIMATION CONSTANT TO ZERO, */
/*                    =2: FIRST APPROXIMATION CONSTANT TO ONE, */
/*                    =3: FIRST APPROXIMATION IS RANDOM FUNCTION WITH */
/*                        THE CONCRETE RANDOM SEQUENCE BEING DETERMINED */
/*                        BY THE FOLLWING DIGITS. */

/*                  REST OF IFIRST  --  RNDU: */
/*                    DETERMINES THE CONCRETE RANDOM SEQUENCE USED IN */
/*                    THE CASE ITYPU=3. (IFIRST=13 IS EQUIVALENT TO */
/*                    IFIRST=1372815) */

/*     ISWTCH   -   PARAMETER CONTROLLING WHICH MODULES OF AMG1R5 ARE TO */
/*                  BE USED. */
/*                    =1:   CALL FOR -----, -----, -----, WRKCNT. */
/*                    =2:   CALL FOR -----, -----, SOLVE, WRKCNT. */
/*                    =3:   CALL FOR -----, FIRST, SOLVE, WRKCNT. */
/*                    =4:   CALL FOR SETUP, FIRST, SOLVE, WRKCNT. */
/*                  SETUP DEFINES THE OPERATORS NEEDED IN THE SOLUTION */
/*                         PHASE. */
/*                  FIRST INITIALIZES THE SOLUTION VECTOR (SEE PARAMETER */
/*                         IFIRST). */
/*                  SOLVE COMPUTES THE SOLUTION BY AMG CYCLING (SEE */
/*                         AMG1R5-PARAMETER NCYC) */
/*                  WRKCNT PROVIDES THE USER WITH INFORMATION ABOUT */
/*                         RESIDUALS, STORAGE REQUIREMENTS AND CP-TIMES */
/*                         (SEE PARAMETER IOUT). */
/*                  IF AUX1R5 IS CALLED THE FIRST TIME, ISWTCH HAS TO */
/*                  BE =4. INDEPENDENT OF ISWTCH, SINGLE MODULES CAN BE */
/*                  BYPASSED BY A PROPER CHOICE OF THE CORRESPONDING */
/*                  PARAMETER. */

/*     IOUT     -   PARAMETER CONTROLLING THE AMOUNT OF OUTPUT DURING */
/*                  SOLUTION PHASE: */

/*                  1ST DIGIT: NOT USED; HAS TO BE NON-ZERO. */

/*                  2ND DIGIT: */
/*                    =0: NO OUTPUT (EXCEPT FOR MESSAGES) */
/*                    =1: RESIDUAL BEFORE AND AFTER SOLUTION PROCESS */
/*                    =2: ADD.: STATISTICS ON CP-TIMES AND STORAGE REQUI- */
/*                        REMENTS */
/*                    =3: ADD.: RESIDUAL AFTER EACH AMG-CYCLE */

/*     IPRINT   -   PARAMETER SPECIFYING THE FORTRAN UNIT NUMBERS FOR */
/*                  OUTPUT: */

/*                  1ST DIGIT: NOT USED; HAS TO BE NON-ZERO */

/*                  2ND AND 3RD DIGIT  --  IUP: UNIT NUMBER FOR RESULTS */

/*                  4TH AND 5TH DIGIT  --  IUM: UNIT NUMBER FOR MESSAGES */


/* -----------------------------------------------------------------------*/

/*     OUTPUT: */

/*     U        -   CONTAINS THE COMPUTED SOLUTION */


/*     IERR     -   ERROR PARAMETER: */

/*                    >0: FATAL ERROR (ABNORMAL TERMINATION) */
/*                    <0: NON-FATAL ERROR (EXECUTION CONTINUES) */

/*                  ERROR CODES IN DETAIL: */

/*                  1. DIMENSIONING TOO SMALL FOR VECTOR */
/*                        A      (IERR = 1) */
/*                        IA     (IERR = 2) */
/*                        JA     (IERR = 3) */
/*                        U      (IERR = 4) */
/*                        F      (IERR = 5) */
/*                        IG     (IERR = 6) */

/*                     NO YALE-SMP BECAUSE OF STORAGE (NDA TOO SMALL): */
/*                               (IERR = -1) */
/*                     NO YALE-SMP BECAUSE OF STORAGE (NDJA TOO SMALL): */
/*                               (IERR = -3) */
/*                     NO CG BECAUSE OF STORAGE (NDU TOO SMALL): */
/*                               (IERR = -4) */
/*                     NO SPACE FOR TRANSPOSE OF INTERPOLATION (NDA OR */
/*                                                     NDJA TOO SMALL): */
/*                               (IERR = -1) */

/*                  2. INPUT DATA ERRONEOUS: */

/*                     A-ENTRY MISSING, ISYM = 1:           (IERR = -11) 
*/
/*                     PARAMETER MATRIX MAY BE ERRONEOUS:   (IERR = -12) 
*/
/*                     DIAGONAL ELEMENT NOT STORED FIRST:   (IERR =  13) 
*/
/*                     DIAGONAL ELEMENT NOT POSITIV:        (IERR =  14) 
*/
/*                     POINTER IA ERRONEOUS:                (IERR =  15) 
*/
/*                     POINTER JA ERRONEOUS:                (IERR =  16) 
*/
/*                     PARAMETER ISWTCH ERRONEOUS:          (IERR =  17) 
*/

/*                  3. ERRORS OF THE AMG1R5-SYSTEM (SHOULD NOT OCCUR): */

/*                     TRANSPOSE A-ENTRY MISSING:           (IERR =  21) 
*/
/*                     INTERPOLATION ENTRY MISSING:         (IERR =  22) 
*/

/*                  4. ALGORITHMIC ERRORS: */

/*                     CG-CORRECTION NOT DEFINED:           (IERR =  31) 
*/
/*                     NO YALE-SMP BECAUSE OF ERROR IN */
/*                     FACTORIZATION:                       (IERR = -32) 
*/

/* -----------------------------------------------------------------------
 */
 
extern "C" 
{
     extern int abort_(void);
     extern double c_abs(complex *);
     extern void c_cos(complex *, complex *);
     extern void c_div(complex *, complex *, complex *);
     extern void c_exp(complex *, complex *);
     extern void c_log(complex *, complex *);
     extern void c_sin(complex *, complex *);
     extern void c_sqrt(complex *, complex *);
     extern double d_abs(double *);
     extern double d_acos(double *);
     extern double d_asin(double *);
     extern double d_atan(double *);
     extern double d_atn2(double *, double *);
     extern void d_cnjg(doublecomplex *, doublecomplex *);
     extern double d_cos(double *);
     extern double d_cosh(double *);
     extern double d_dim(double *, double *);
     extern double d_exp(double *);
     extern double d_imag(doublecomplex *);
     extern double d_int(double *);
     extern double d_lg10(double *);
     extern double d_log(double *);
     extern double d_mod(double *, double *);
     extern double d_nint(double *);
     extern double d_prod(float *, float *);
     extern double d_sign(double *, double *);
     extern double d_sin(double *);
     extern double d_sinh(double *);
     extern double d_sqrt(double *);
     extern double d_tan(double *);
     extern double d_tanh(double *);
     extern double derf_(double *);
     extern double derfc_(double *);
     extern integer do_fio(ftnint *, char *, ftnlen);
     extern integer do_lio(ftnint *, ftnint *, char *, ftnlen);
     extern integer do_uio(ftnint *, char *, ftnlen);
     extern integer e_rdfe(void);
     extern integer e_rdue(void);
     extern integer e_rsfe(void);
     extern integer e_rsfi(void);
     extern integer e_rsle(void);
     extern integer e_rsli(void);
     extern integer e_rsue(void);
     extern integer e_wdfe(void);
     extern integer e_wdue(void);
     extern integer e_wsfe(void);
     extern integer e_wsfi(void);
     extern integer e_wsle(void);
     extern integer e_wsli(void);
     extern integer e_wsue(void);
     extern int ef1asc_(ftnint *, ftnlen *, ftnint *, ftnlen *);
     extern integer ef1cmc_(ftnint *, ftnlen *, ftnint *, ftnlen *);
     extern double erf(double);
     extern double erf_(float *);
     extern double erfc(double);
     extern double erfc_(float *);
     extern integer f_back(alist *);
     extern integer f_clos(cllist *);
     extern integer f_end(alist *);
     extern void f_exit(void);
     extern integer f_inqu(inlist *);
     extern integer f_open(olist *);
     extern integer f_rew(alist *);
     extern int flush_(void);
     extern void getarg_(integer *, char *, ftnlen);
     extern void getenv_(char *, char *, ftnlen, ftnlen);
     extern short h_abs(short *);
     extern short h_dim(short *, short *);
     extern short h_dnnt(double *);
     extern short h_indx(char *, char *, ftnlen, ftnlen);
     extern short h_len(char *, ftnlen);
     extern short h_mod(short *, short *);
     extern short h_nint(float *);
     extern short h_sign(short *, short *);
     extern short hl_ge(char *, char *, ftnlen, ftnlen);
     extern short hl_gt(char *, char *, ftnlen, ftnlen);
     extern short hl_le(char *, char *, ftnlen, ftnlen);
     extern short hl_lt(char *, char *, ftnlen, ftnlen);
     extern integer i_abs(integer *);
     extern integer i_dim(integer *, integer *);
     extern integer i_dnnt(double *);
     extern integer i_indx(char *, char *, ftnlen, ftnlen);
     extern integer i_len(char *, ftnlen);
     extern integer i_mod(integer *, integer *);
     extern integer i_nint(float *);
     extern integer i_sign(integer *, integer *);
     extern integer iargc_(void);
     extern ftnlen l_ge(char *, char *, ftnlen, ftnlen);
     extern ftnlen l_gt(char *, char *, ftnlen, ftnlen);
     extern ftnlen l_le(char *, char *, ftnlen, ftnlen);
     extern ftnlen l_lt(char *, char *, ftnlen, ftnlen);
     extern void pow_ci(complex *, complex *, integer *);
     extern double pow_dd(double *, double *);
     extern double pow_di(double *, integer *);
     extern short pow_hh(short *, shortint *);
     extern integer pow_ii(integer *, integer *);
     extern double pow_ri(float *, integer *);
     extern void pow_zi(doublecomplex *, doublecomplex *, integer *);
     extern void pow_zz(doublecomplex *, doublecomplex *, doublecomplex *);
     extern double r_abs(float *);
     extern double r_acos(float *);
     extern double r_asin(float *);
     extern double r_atan(float *);
     extern double r_atn2(float *, float *);
     extern void r_cnjg(complex *, complex *);
     extern double r_cos(float *);
     extern double r_cosh(float *);
     extern double r_dim(float *, float *);
     extern double r_exp(float *);
     extern double r_imag(complex *);
     extern double r_int(float *);
     extern double r_lg10(float *);
     extern double r_log(float *);
     extern double r_mod(float *, float *);
     extern double r_nint(float *);
     extern double r_sign(float *, float *);
     extern double r_sin(float *);
     extern double r_sinh(float *);
     extern double r_sqrt(float *);
     extern double r_tan(float *);
     extern double r_tanh(float *);
     extern void s_cat(char *, char **, integer *, integer *, ftnlen);
     extern integer s_cmp(char *, char *, ftnlen, ftnlen);
     extern void s_copy(char *, char *, ftnlen, ftnlen);
     extern int s_paus(char *, ftnlen);
     extern integer s_rdfe(cilist *);
     extern integer s_rdue(cilist *);
     extern integer s_rnge(char *, integer, char *, integer);
     extern integer s_rsfe(cilist *);
     extern integer s_rsfi(icilist *);
     extern integer s_rsle(cilist *);
     extern integer s_rsli(icilist *);
     extern integer s_rsne(cilist *);
     extern integer s_rsni(icilist *);
     extern integer s_rsue(cilist *);
     extern int s_stop(char *, ftnlen);
     extern integer s_wdfe(cilist *);
     extern integer s_wdue(cilist *);
     extern integer s_wsfe(cilist *);
     extern integer s_wsfi(icilist *);
     extern integer s_wsle(cilist *);
     extern integer s_wsli(icilist *);
     extern integer s_wsne(cilist *);
     extern integer s_wsni(icilist *);
     extern integer s_wsue(cilist *);
     extern void sig_die(char *, int);
     extern integer signal_(integer *, void (*)(int));
     extern integer system_(char *, ftnlen);
     extern double z_abs(doublecomplex *);
     extern void z_cos(doublecomplex *, doublecomplex *);
     extern void z_div(doublecomplex *, doublecomplex *, doublecomplex *);
     extern void z_exp(doublecomplex *, doublecomplex *);
     extern void z_log(doublecomplex *, doublecomplex *);
     extern void z_sin(doublecomplex *, doublecomplex *);
     extern void z_sqrt(doublecomplex *, doublecomplex *);
}
 
int aux1r5_(doublereal *a, integer *ia, integer *ja, 
            doublereal *u, doublereal *f,
            integer *ig, integer *nda, integer *ndia, integer *ndja, integer *ndu, 
            integer *ndf, integer *ndig, integer *nnu, integer *matrix, 
            doublereal *eps,
            integer *ifirst, integer *iswtch, integer *iout, integer *iprint, integer *ierr);

int amg1r5_(doublereal *a, integer *ia, integer *ja, doublereal *u, doublereal *f,
            integer *ig, integer *nda, integer *ndia, integer *ndja, integer *ndu, 
            integer *ndf, integer *ndig, integer *nnu, integer *matrix, integer *iswtch, 
            integer *iout, integer *iprint, integer *levelx, integer *ifirst, 
            integer *ncyc, doublereal *eps, integer *madapt, integer *nrd, integer *nsolco, 
            integer *nru, doublereal *ecg1, doublereal *ecg2, doublereal *ewt2,
            integer *nwt, integer *ntr, integer *ierr);

int setup_(integer *nnu, integer *matrix, integer *levelx, doublereal *ecg1, 
           doublereal *ecg2, doublereal *ewt2, integer *nwt, integer *ntr, 
           integer *ierr, doublereal *a, doublereal *u, integer *ia, integer *ja, 
           integer *iw, integer *imin, integer *imax, integer *iminw, integer *imaxw, 
           integer *icg, integer *ifg, integer *nstcol, integer *iarr,
           real *time, integer *levels, integer *irow0, integer *nda, integer *ndia, 
           integer *ndja, integer *ndu, integer *ndf, integer *ndicg, integer *ium, 
           integer *mda, integer *mdia, integer *mdja, integer *mdu, integer *mdf, 
           integer *mdig, integer *maxgr, integer *lratio);

int check_(integer *ierr, doublereal *a, integer *ia, 
           integer *ja, integer *imin, integer *imax, integer *icg, integer *ifg,
           real *time, integer *isym, integer *irow0, integer *nda, integer *ndicg, 
           integer *ndja, integer *ium);

int trunc_(integer *k, integer *ntr, doublereal *a, integer *ia, integer *ja, 
           integer *imin, integer *imax, real *time, integer *ierr, integer *ium);

int crsng_(integer *levelx, doublereal *eecg1, doublereal *eecg2, doublereal *eewt2,
           integer *nnwt, integer *ntr, integer *ierr, doublereal *a, doublereal *u,
           integer *ia, integer *ja, integer *iw, integer *imin, integer *imax, integer *iminw, 
           integer *imaxw, integer *icg, integer *ifg, integer *nstcol, integer *levels, 
           integer *irow0, integer *nda, integer *ndja, integer *ndia, integer *ndu, 
           integer *ndf, integer *ndicg, real *time, integer *ium, integer *mda, 
           integer *mdia, integer *mdja, integer *mdu, integer *mdf, integer *mdig, 
           integer *maxgr, integer *lratio);
           
int rwsrt_(integer *k, doublereal *ecg1, doublereal *ecg2, integer *ierr,
           doublereal *a, integer *ia, integer *ja, integer *iw, integer *imin, 
           integer *imax, integer *imaxw, integer *ifg, doublereal *jtr, real *time,
           integer *ndjtr, integer *ium, integer *mdjtr);

int pcol_(integer *k, integer *ierr, integer *ia, integer *ja, integer *iw, integer *imin, 
          integer *imax, integer *imaxw, integer *icg, integer *ifg, doublereal *ir, doublereal *jtr,
          real *time, integer *ndicg, integer *ndir, integer *ium, integer *mdicg, integer *mdir,
          integer *iias);

int pwint_(integer *k, doublereal *ewt2, integer *ichk, integer *mmax,
           doublereal *a, integer *ia, integer *ja, integer *iw, integer *imin, integer *imax, 
           integer *iminw, integer *imaxw, integer *ifg, integer *icg, doublereal *ncolor,
           real *time, integer *ierr, integer *irow0, integer *ncolx, integer *nda, 
           integer *ndja, integer *ndicg, integer *ndia, integer *ium, integer *mda, 
           integer *mdja, integer *iajas);
           
int opdfn_(integer *k, integer *ierr, integer *mmax, doublereal *a,
           integer *ia, integer *ja, integer *iw, integer *imin, integer *imax, 
           integer *iminw, integer *imaxw, integer *icg, integer *ifg, doublereal *ncolor, 
           integer *nstcol, integer *ncolx, real *time, integer *nda, integer *ndja, integer *ium, 
           integer *mda, integer *mdja, integer *iajas);
           
int setifg_(integer *imin, integer *imax, integer *icg, integer *ifg, integer *nstcol, 
            integer *levels, real *time);
           
int asolve_(integer *madapt, integer *ncyc, integer *nrd, integer *nsolco, integer *nru, 
            integer *iout, integer *ierr, doublereal *a, doublereal *u, doublereal *f,
            integer *ia, integer *ja, integer *iw, doublereal *eps, integer *imin, 
            integer *imax, integer *iminw, integer *imaxw, integer *icg, integer *ifg, 
            integer *nstcol, integer *iarr, real *time, integer *ncyc0, integer *irow0, 
            integer *levels, integer *nda, integer *ndja, integer *ndu, integer *ndf, 
            integer *mda, integer *mdja, integer *mdu, integer *mdf, integer *iup, 
            integer *ium, doublereal *resi, doublereal *res0, doublereal *res);
           
int cyc_(integer *l, integer *nrdx, integer *nrdtyp, integer *nrdlen, integer *nrcx, 
         integer *nrux, integer *nrutyp, integer *nrulen, integer *igam, doublereal *a, 
         doublereal *u, doublereal *f, integer *ia, integer *ja, integer *iw, integer *imin, 
         integer *imax, integer *iminw, integer *imaxw, integer *ifg, integer *icg, 
         integer *nstcol, integer *ng, real *time, integer *irow0, integer *m, integer *ium, 
         integer *ierr, integer *iter, integer *nsc, integer *nda, integer *ndja, integer *mda, 
         integer *mdja, integer *msel, doublereal *fac, doublereal *resi, integer *levels);

int coarse_(integer *m, integer *ifac, integer *nsc, integer *nrcx, integer *ium, 
            integer *ierr, doublereal *a, doublereal *u, doublereal *f, integer *ia, 
            integer *ja, integer *iw, integer *imin, integer *imax, integer *iminw, 
            integer *icg, integer *nstcol, real *time, integer *nda, integer *ndja, 
            integer *mda, integer *mdja, integer *irow0);
            
int relx_(integer *k, integer *irel, doublereal *a, doublereal *u, doublereal *f,
          integer *ia, integer *ja, integer *iw, integer *imin, integer *imax, 
          integer *iminw, integer *icg, integer *nstcol, real *time);
            
int vscale_(integer *k, integer *ivstar, doublereal *a, doublereal *u, doublereal *f,
            integer *ia, integer *ja, integer *iw, integer *imin, integer *imax, integer *iminw,
            real *time);
            
int inta_(integer *kf, doublereal *a, doublereal *u, integer *ia, integer *ja, 
          integer *iw, integer *imin, integer *imax, integer *iminw, integer *imaxw, 
          integer *ifg, real *time);
          
int resc_(integer *kc, doublereal *a, doublereal *u, doublereal *f,
          integer *ia, integer *ja, integer *iw, integer *imin, integer *imax, 
          integer *iminw, integer *imaxw, integer *ifg, real *time);
          
int putz_(integer *k, doublereal *u, integer *imin, integer *imax,
          real *time);
          
int first_(integer *ifirst, doublereal *u, integer *imin, integer *imax, integer *iarr, 
           integer *irow0);
          
int injf_(integer *kc, doublereal *f, integer *imin, integer *imax, integer *ifg);
          
int inju_(integer *kc, doublereal *u, integer *imin, integer *imax, integer *ifg);
          
int nrmu_(integer *k, doublereal *u, integer *imin, integer *imax, integer *irow0);
          
int resid_(integer *k, doublereal *res, doublereal *a, doublereal *u, doublereal *f,
           integer *ia, integer *ja, integer *iw, integer *imin, integer *imax, integer *iminw);
           
int cg_(integer *k, integer *icgr, integer *iter, doublereal *a, doublereal *u, 
        doublereal *f, integer *ia, integer *ja, integer *iw, integer *imin, integer *imax, 
        integer *iminw, integer *m, real *time, integer *ierr, integer  *ium);
           
int usave_(integer *k, integer *icgr, doublereal *u, integer *imin, integer *imax, 
           integer *ndu, integer *m, real *time, integer *ierr, integer *ium, integer *mdu, 
           integer *ndf, integer *mdf);
           
doublereal cgeps_(integer *k, doublereal *s2, doublereal *a, doublereal *u, doublereal *f,
                  integer *ia, integer *ja, integer *iw, integer *imin, integer *imax, 
                  integer *iminw, integer *m, integer *ierr, integer *ium);
           
doublereal cgalf_(integer *k, doublereal *s2, doublereal *a, doublereal *u, doublereal *f,
                  integer *ia, integer *ja, integer *iw, integer *imin, integer *imax, integer *iminw, integer *m);
           
int wrkcnt_(integer *iout, integer *ia, integer *iw, integer *imin, integer *imax, 
            integer *iminw, integer *levels, real *time, integer *ncyc0, integer  *iup, 
            integer *mda, integer *mdia, integer *mdja, integer *mdu, integer *mdf, 
            integer *mdig, doublereal *res0, doublereal *res);

int idec_(integer *into, integer *nnum, integer *ndigit, integer *iarr);
          
doublereal random_(doublereal *s);
          
int ndrv_(integer *n, integer *r__, integer *c__, integer *ic, integer *ia, 
          integer *ja, doublereal *a, doublereal *b, doublereal *z__, 
          integer *nsp, integer *isp, doublereal *rsp, integer *esp, integer *path, 
          integer *flag__);
          
int nsf8_(integer *n, integer *r__, integer *ic, integer *ia, integer *ja, 
          integer *il, integer *jl, integer *jlmax, integer *iu, integer *ju, 
          integer *jumax, integer *q, integer *im, integer	*flag__);
          
int nnf8_(integer *n, integer *r__, integer *c__, integer *ic, integer *ia, integer *ja,
          doublereal *a, doublereal *z__, doublereal *b, integer *il, integer *jl,
          doublereal *l, integer *lmax, doublereal *d__, integer *iu, integer *ju,
          doublereal *u, integer *umax, doublereal *row, doublereal *tmp,
          integer *flag__);
          
int nns8_(integer *n, integer *r__, integer *c__, integer *il, integer *jl,
          doublereal *l, doublereal *d__, integer *iu, integer *ju,
          doublereal *u, doublereal *z__, doublereal *b, doublereal *tmp);
            
int nnt8_(integer *n, integer *r__, integer *c__, integer *il, integer *jl,
          doublereal *l, doublereal *d__, integer *iu, integer *ju,
          doublereal *u, doublereal *z__, doublereal *b, doublereal *tmp);
           
int ctime_( real *time );

#endif
