#ifdef WIN32        
#pragma warning(disable:4786)        
#endif

#include <iostream>
#include <fstream>
#include <sstream>
#include <iomanip>
#include <cmath>
#include <cstdlib>
#include <cassert>
#include <ctime>
#include <set>
#include <vector> 
#include <string>
#include <algorithm>
#include <functional>
#include <utility>
#include <map>
using namespace std;

#include "f2c.h"
#include "sortedEvents.h"
#include "threeSome.h"
#include "inputData.h"
#include "node.h"
#include "fluid.h"
#include "shape.h"
#include "rockElem.h"
#include "solver.h"
#include "commonData.h"

CommonData::CommonData(vector< double >& weights, const string& poreFillAlg, double circWatCondMultFact,  
                       InputData& input, double gravX, double gravY, double gravZ) : m_gravConstX(gravX), 
                       m_gravConstY(gravY), m_gravConstZ(gravZ)
{    
	m_drainageCycle = 0;
    m_imbibitionCycle = 1;
    m_poreFillAlg = poreFillAlg;
    m_radiiWeights = weights;
    m_circWatCondMultFact = circWatCondMultFact;
    m_maxCappPress = 0.0;
	m_minCappPress = 0.0;
    m_maxPcLastCycle = 0.0;
    m_minPcLastCycle = 0.0;
    m_numSquares = 0;
    m_numTriangles = 0;
    m_numCircles = 0;
	m_injectant = 0;
    m_cappPress = 0;
    m_drainagePhase = false;

//    dbgOut.open("debug.out");   // delete me
}

CommonData::CommonData(const CommonData& data) : m_numPores(data.m_numPores), m_numThroats(data.m_numThroats), 
    m_gravConstX(data.m_gravConstX), m_gravConstY(data.m_gravConstY), m_gravConstZ(data.m_gravConstZ)
{
    m_injectant = data.m_injectant;
    m_maxCappPress = data.m_maxCappPress;
    m_minCappPress = data.m_minCappPress;
    m_maxPcLastCycle = data.m_maxPcLastCycle;
    m_minPcLastCycle = data.m_minPcLastCycle;
    m_numSquares = data.m_numSquares;
    m_numTriangles = data.m_numTriangles;
    m_numCircles = data.m_numCircles;
    m_radiiWeights = data.m_radiiWeights;
    m_poreFillAlg = data.m_poreFillAlg; 
    m_circWatCondMultFact = data.m_circWatCondMultFact; 
    m_cappPress = data.m_cappPress; 
}
 
void CommonData::finalizeCopyConstruct(const CommonData& data, const vector< RockElem* >& elems)
{
    m_trappedRegionsOil.resize(data.m_trappedRegionsOil.size());
    m_trappedRegionsWat.resize(data.m_trappedRegionsWat.size());

    size_t i, j;
    for(i = 0; i < data.m_trappedRegionsOil.size(); ++i)
    {
        for(j = 0; j < data.m_trappedRegionsOil[i].size(); ++j)
        {
            int index = data.m_trappedRegionsOil[i][j]->latticeIndex();
            m_trappedRegionsOil[i].push_back(elems[index]);
        }
    }

    for(i = 0; i < data.m_trappedRegionsWat.size(); ++i)
    {
        for(j = 0; j < data.m_trappedRegionsWat[i].size(); ++j)
        {
            int index = data.m_trappedRegionsWat[i][j].first->latticeIndex();
            pair< RockElem*, FluidBlob > elem(elems[index], data.m_trappedRegionsWat[i][j].second);
            m_trappedRegionsWat[i].push_back(elem);
        }
    }
}
