#ifndef FLUID_H
#define FLUID_H

class Fluid
{
public:

    Fluid(double viscosity, double interPhaseTen, double resistivity, double density) : m_viscosity(viscosity), 
        m_interPhaseTen(interPhaseTen), m_resistivity(resistivity), m_density(density) {}
    
    Fluid(const Fluid& fluid) : m_viscosity(fluid.m_viscosity), m_interPhaseTen(fluid.m_interPhaseTen), 
        m_resistivity(fluid.m_resistivity) {}

    virtual ~Fluid() {}

    double viscosity() const {return m_viscosity;}
    double interPhaseTen() const {return m_interPhaseTen;}
    double resistivity() const {return m_resistivity;}
    double density() const {return m_density;}    

protected:

    double                  m_viscosity;
    double                  m_interPhaseTen;
    double                  m_resistivity;
    double                  m_density;

};

class Oil : public Fluid
{
public:

    Oil(double viscosity, double interPhaseTen, double resistivity, double density) : Fluid(viscosity, 
        interPhaseTen, resistivity, density) {}
    Oil(const Oil& oil) : Fluid(oil) {}

private:

};

class Water : public Fluid
{
public:

    Water(double viscosity, double interPhaseTen, double resistivity, double density) : Fluid(viscosity, 
        interPhaseTen, resistivity, density) {}
    Water(const Water& water) : Fluid(water) {}

private:

};

#endif

