#ifdef WIN32        
#pragma warning(disable:4786)        
#endif

#include <iostream>
#include <fstream>
#include <sstream>
#include <iomanip>
#include <cmath>
#include <cstdlib>
#include <cassert>
#include <cstdio>
#include <ctime>
#include <set>
#include <vector>
#include <algorithm>
#include <functional>
#include <map>
using namespace std;

#include "f2c.h"
#include "sortedEvents.h"
#include "threeSome.h"
#include "inputData.h"
#include "netsim.h"

extern "C"
{
    extern void MAIN__();
}

void Wait4me();
void Drainage(InputData&, Netsim&, const string&, double&, double&, double, double, double, double, bool, bool, 
              bool, bool, bool);
void Imbibition(InputData&, Netsim&, const string&, double&, double&, double, double, double, double, bool, bool, 
                bool, bool, bool);
 
int main(int argc, char *argv[])
{
    //atexit(Wait4me); 

    string inputFileName;    
    cout<<"Network Model Code v2, build 20031028" << endl;
    
    if (argc > 1)
        inputFileName = argv[1];
    else
    {
        cout << "Please input data file : "; 
        cin >> inputFileName;
    }
        
    InputData input(inputFileName);    
    
    bool matlabMode(false), excelMode(false);
    input.resFormat(matlabMode, excelMode);

    int seedNum;
    input.randSeed(seedNum);

    string baseFileName;
    input.title(baseFileName);

    Netsim netsim(seedNum);
    
    string prtFile(baseFileName + ".prt");
    ofstream prtOut(prtFile.c_str());
    input.echoKeywords(prtOut);    
    
    netsim.addOStreamForPrt(&prtOut);
    netsim.addOStreamForPrt(&cout);
    
    netsim.init(input);
    
    bool propOut(false), swOut(false);
    input.output(propOut, swOut);
    
    bool calcKr, calcI;
    double sw(1.0), pc(0.0), finalSw, finalPc, deltaSw, deltaPc;

    while(input.satTarget(finalSw, finalPc, deltaSw, deltaPc, calcKr, calcI))
    {
        if(finalSw > 1.0)
        {
            cerr << "==========================================="   << endl
                << "Error: Saturations to be given as fractions"    << endl
                << "==========================================="    << endl;
            exit(-1);
        }
        if(finalSw < sw)
        {
            Drainage(input, netsim, baseFileName, sw, pc, finalSw, finalPc, deltaSw, deltaPc, 
                calcKr, calcI, swOut, matlabMode, excelMode);
        }
        else
        {
            Imbibition(input, netsim, baseFileName, sw, pc, finalSw, finalPc, deltaSw, deltaPc, 
                calcKr, calcI, swOut, matlabMode, excelMode);
        }
    }

    if(propOut) netsim.writePoreDataToFile(baseFileName);
    if(swOut) netsim.writeSwHistoryToFile(baseFileName);

    prtOut.close();
    return 0;
}

////////////////////////////////////////////////////////////////
// f2c on linux needs a reference to the entry point MAIN__
// otherwise it will not link. This function is never called
////////////////////////////////////////////////////////////////
void MAIN__()
{
    cout << "This function is never called" << endl;
    exit(-1);
}

void Wait4me()
{
    cout << "Press any key to exit" << endl;
    getchar();
}

void Drainage(InputData& input, Netsim& netsim, const string& baseFileName, double& sw, double& pc, double finalSw, double finalPc, 
              double deltaSw, double deltaPc, bool calcKr, bool calcI, bool swOut, bool matlabMode, bool excelMode)
{
    netsim.clearOStreamForDrainRes();
    string extension(".out");
    if(matlabMode) extension = ".m";
    else if(excelMode) extension = ".csv";

    ostringstream resFileName;
    resFileName << baseFileName << "_draincycle_" << netsim.drainageCycle()+1 << extension;
    string fileName(resFileName.str());
    
    ofstream resOut(fileName.c_str());
    if(!resOut)
    {
        cerr << endl
            << "============================================================"   << endl
            << "Error: Could not open " << fileName << " for writing."          << endl
            << "============================================================"   << endl;
        exit(-1);
    }
    netsim.addOStreamForDrainRes(&resOut);
    
    netsim.initDrainage(calcKr, calcI);

    bool satCompress(false), compressWat(false), compressOil(false);
    double krThreshold, newDeltaSw, dSw(deltaSw);
    input.relPermCompression(satCompress, krThreshold, newDeltaSw, compressWat, compressOil);
    if(satCompress && calcKr && compressOil) dSw = newDeltaSw;
    double swTarget = max(finalSw, sw - dSw);
    double pcTarget = min(finalPc, pc + deltaPc);
    bool residualSat(false);
    double krw, kro, resI;
    
    while(!residualSat && sw >= finalSw && pc <= finalPc)
    {
        netsim.drainage(swTarget, pcTarget, krw, kro, resI, residualSat);
        sw = swTarget;
        pc = pcTarget;            
        if(satCompress && calcKr && compressOil && kro > krThreshold) dSw = deltaSw;
        if(satCompress && calcKr && compressWat && krw < krThreshold) dSw = newDeltaSw;
        swTarget = max(finalSw, sw - dSw);
        pcTarget = min(finalPc, pc + deltaPc);
        if(swOut) netsim.recordWaterSatMap();
    }
    
    netsim.finaliseDrainage();
    resOut.close();
}

void Imbibition(InputData& input, Netsim& netsim, const string& baseFileName, double& sw, double& pc, double finalSw, double finalPc, 
              double deltaSw, double deltaPc, bool calcKr, bool calcI, bool swOut, bool matlabMode, bool excelMode)
{
    netsim.clearOStreamForImbRes();
    string extension(".out");
    if(matlabMode) extension = ".m";
    else if(excelMode) extension = ".csv";
    
    ostringstream resFileName;
    resFileName << baseFileName << "_imbcycle_" << netsim.imbibitionCycle()+1 << extension;
    string fileName(resFileName.str());
    
    ofstream resOut(fileName.c_str());
    if(!resOut)
    {
        cerr << endl
            << "============================================================"   << endl
            << "Error: Could not open " << fileName << " for writing."          << endl
            << "============================================================"   << endl;
        exit(-1);
    }
    netsim.addOStreamForImbRes(&resOut);
    
    netsim.initImbibition(calcKr, calcI, input);
    
    bool satCompress(false), compressWat(false), compressOil(false);
    double krThreshold, newDeltaSw, dSw(deltaSw);
    input.relPermCompression(satCompress, krThreshold, newDeltaSw, compressWat, compressOil);
    if(satCompress && calcKr && compressWat) dSw = newDeltaSw;
    double swTarget = min(finalSw, sw + dSw);
    double pcTarget = max(finalPc, pc - deltaPc);
    bool residualSat(false);
    double krw, kro, resI;
    
    while(!residualSat && sw <= finalSw && pc >= finalPc)
    {
        netsim.injectWater(swTarget, pcTarget, krw, kro, resI, residualSat);
        sw = swTarget;
        pc = pcTarget;            
        if(satCompress && calcKr && compressWat && krw > krThreshold) dSw = deltaSw;
        if(satCompress && calcKr && compressOil && kro < krThreshold) dSw = newDeltaSw;
        swTarget = min(finalSw, sw + dSw);
        pcTarget = max(finalPc, pc - deltaPc);
        if(swOut) netsim.recordWaterSatMap();
    }
    
    netsim.finaliseImbibition();
    resOut.close();
}
