#ifdef WIN32        
#pragma warning(disable:4786)        
#endif

#include <iostream>
#include <iomanip>
#include <algorithm>
#include <vector>
#include <utility>
#include <cmath>
#include <map>
using namespace std;

#include "f2c.h"
#include "node.h"

ostream& operator<< (ostream& out, const Node& node) 
{  
    out.flags(ios::showpoint);
    out.flags(ios::scientific);

    out << setprecision(4)
        << setw(15) << node.m_xPos
        << setw(15) << node.m_yPos
        << setw(15) << node.m_zPos;

    return out;
}

/////////////////////////////////////////////////////////////////////////////
// Constructor for the node class. Inlet node has index == 0 whereas outlet
// has the index has index == numPores + 1 If node is recognised to be inlet 
// or outlet reservoir the x location is moved outside the reservoir to prevent 
// them having the same x coord as the first line of pores (which usually are 
// at 0.0 or xSize. This is required for these to be recognised as in/outlet
// if boxsize is set to be 1.0.
/////////////////////////////////////////////////////////////////////////////
Node::Node(int index, int numPores, double xPos, double yPos, double zPos, 
           double exitSeparation) : m_index(index), m_numPores(numPores), 
           m_xPos(xPos), m_yPos(yPos), m_zPos(zPos), m_optimizedIndex(-1), m_oldIndex(index)
{
    m_exitSeparation = exitSeparation;
    
    if(m_index == 0) 
    {
        m_isOutsideLattice = false;             // We are at inlet face
        m_isEntryRes = true;
        m_isExitRes = false;
    }
    else if(m_index == m_numPores + 1) 
    {
        m_isOutsideLattice = false;             // We are at outlet face
        m_isEntryRes = false;
        m_isExitRes = true;
    }
    else if(m_index > 0 && m_index <= m_numPores) 
    {
        m_isOutsideLattice = false;             // We are inside network
        m_isEntryRes = false;
        m_isExitRes = false;
    }
    else
    {
        m_isOutsideLattice = true;             // We are outside lattice
        m_isEntryRes = false;
        m_isExitRes = false;
    }    
}

///////////////////////////////////////////////////////////////////
// In/outlet internally has indecies 0 and numPores+1. However when
// writing the data to file this has to be changed to -1 and 0 to
// be compatible with Oren's data format
///////////////////////////////////////////////////////////////////
int Node::indexOren() const
{
    if(m_isEntryRes)
        return -1;
    else if(m_isExitRes)
        return 0;
    else
        return m_index;
}

void Node::printInfo(ostream& out) const
{
    out.flags(ios::showpoint);
    out.flags(ios::scientific);

    out << setprecision(4)
        << setw(15) << m_xPos*1.0E6
        << setw(15) << m_yPos*1.0E6
        << setw(15) << m_zPos*1.0E6;
}

