#ifndef NODE_H
#define NODE_H

class Node
{

    friend ostream& operator<< (ostream&, const Node&);

public:
    
    Node(int index, int numPores, double xPos, double yPos, double zPos, double exitSeparation);

    bool operator==(const Node& rhs) const {return m_index == rhs.index();}
    bool operator>=(const Node& rhs) const {return m_index >= rhs.index();}
    bool operator<=(const Node& rhs) const {return m_index <= rhs.index();}
    bool operator>(const Node& rhs) const {return m_index > rhs.index();}
    bool operator<(const Node& rhs) const {return m_index < rhs.index();}

    void printInfo(ostream& out) const;
    void setOptimizedIndex(int idx) {m_optimizedIndex = idx;}
    inline bool optimizedIndex(int& optimizedIdx);
    int index() const {return m_index;}
    int indexOren() const;
    int oldIndex() const {return m_oldIndex;}
    double xPos() const {return m_xPos;}
    double yPos() const {return m_yPos;}
    double zPos() const {return m_zPos;}
    inline void rePosition(double scaleFactor);

    bool isInsideBox(double boxStart, double boxEnd) const {
        return m_xPos >= m_exitSeparation*boxStart &&  m_xPos <= m_exitSeparation*boxEnd;
    }

    bool isOutsideLattice() const {return m_isOutsideLattice;}
    bool isEntryRes() const {return m_isEntryRes;}
    bool isExitRes() const {return m_isExitRes;}
    bool isEntryOrExitRes() const {return m_isEntryRes || m_isExitRes;}

    double distToExit() const {return m_exitSeparation - m_xPos;}

private:

    void initNode();

    int                         m_index;                    // Single consecutive index
    int                         m_numPores;                 // The size of the lattice
    double                      m_xPos, m_yPos, m_zPos;     // The node coordinate
    double                      m_exitSeparation;
    bool                        m_isEntryRes, m_isExitRes;  // Is the node inlet or outlet node
    bool                        m_isOutsideLattice;         // Is node outside lattice
    int                         m_optimizedIndex;            // In order to reduce bandwidth
    int                         m_oldIndex;

};

inline bool Node::optimizedIndex(int& optimizedIdx)
{
    if(m_optimizedIndex >= 0)
    {
        m_index = m_optimizedIndex;
        optimizedIdx = m_optimizedIndex;
        return true;
    }
    else
    {
        optimizedIdx = m_optimizedIndex;
        return false;
    }    
}

inline void Node::rePosition(double scaleFactor)
{
    m_xPos *= scaleFactor;
    m_yPos *= scaleFactor;
    m_zPos *= scaleFactor;
    m_exitSeparation *= scaleFactor;
}

#endif

