#ifndef SOLVER_H
#define SOLVER_H

class RockElem;

class Solver
{

public:

    Solver(const vector< RockElem* >& network, const vector< RockElem* >& inlet, const vector< RockElem* >& outlet, 
        int outletIdx, int maxNonZeros, const string& matFileName, bool matlabFormat);

    Solver(const Solver& slover);
    ~Solver();

    double flowrate(double inPrs, double outPrs, const Fluid* fluid, double& flowErr, double& elap, 
        double satWat = 1.0, bool writeVelocity = false, bool writeMat = false, bool resistivitySolve = false);
    static void initSolver(double eps, int scaleFact, int slvrOutput, bool verboseSlvr, bool useGrav);


private:

    double getFlowRate(const Fluid*, double&, bool) const;
    void fillMatrix(double, double, const Fluid *, bool writeVelocity, bool resistivitySolve);
    void dumpMatrixMatlab(const string& fileName) const;
    void dumpMatrixStd(const string& fileName) const;
    void readMatrixStd(const string& fileName);
	void dumpVelocityStd(const string& fileName, const Fluid* fluid, bool resistivitySolve) const; 
	void dumpVelocityMatlab(const string& fileName, const Fluid* fluid, bool resistivitySolve) const; 
	void writeVelocityEntry(ostream& out, pair<const RockElem*, double> entry, const Fluid* fluid, bool resistivitySolve) const;
            
    static int                                              MAT_MEM_SCALE;
    static bool                                             INITIALISED;
    static bool                                             USE_GRAVITY;
    static long                                             SYMMETRIC_MAT;
    static long                                             SLVR_OUTPUT;
    static double                                           TOLERANCE;
    static long                                             VERBOSE_SLVR;
    static const double                                     SCALE_FACTOR;
    
    const vector< RockElem* >&                              m_network;
    const vector< RockElem* >&                              m_inletPores;
    const vector< RockElem* >&                              m_outletPores;
    const int                                               m_outletIdx;
    const int                                               m_maxNonZeros;      // of the network model
    const string                                            m_matrixFileName;
    const bool                                              m_matlabFormat;
    const int                                               m_probSize;         // Constant values given by the size
    const long                                              m_matElemFactor;
    const long                                              m_matSizeFactor;
    
    vector< FourSome<int, double, double, double> >         m_networkOutlets;
    vector< FourSome<int, double, double, double> >         m_networkInlets;
	vector< pair<const RockElem*, double> >			        m_throatConductances;
    
    mutable int                                             m_petscErr;
    long                                                    m_matrixSize;
    long                                                    m_nonZeroElems;
    long                                                    *m_rowPtr;
    long                                                    *m_colIndex;
    long                                                    *m_someIdxBuffer;
    int                                                     *m_colHash;
    int                                                     m_finalRowPointer;

    double                                                  *m_matElems;
    double                                                  *m_rhsVecBuffer;
    double                                                  *m_solVecBuffer;
    
    Pore                                                    **m_poreHash;
};


#endif
