#ifndef SORTEDEVENTS_H
#define SORTEDEVENTS_H


//////////////////////////////////////////////////////////////////////
// The class takes care of all the sorted events
//////////////////////////////////////////////////////////////////////
template<typename Type, typename CFunc>
class SortedEvents 
{    
public:
        
    void quickInsert(Type elm) {m_sortedContainer.push_back(elm);}
    inline void insert(Type elm);
    inline bool remove(Type elm);
    inline void sortEvents();
    inline Type pop();
    inline Type peek() const;
    inline bool present(Type elm) const;
    inline Type at(size_t pos) const;
    size_t size() const {return m_sortedContainer.size();}
    bool empty() const {return m_sortedContainer.empty();}
    void clear() {m_sortedContainer.clear();}

private:

    inline bool checkIfThere(Type elm) const;
    typedef typename vector< Type >::iterator        EventItr;

    vector<Type>                            m_sortedContainer;
};

//////////////////////////////////////  Inline Functions //////////////////////////////////////////////
//inline void SortedEvents<T, F>::insertEvent(T elem) 

template<typename Type, typename CFunc>
inline void SortedEvents<Type, CFunc>::insert(Type elem) 
{
    //assert(!checkIfThere(elem));    // Only enable for emergency debugging => EXTREMELY expensive
    m_sortedContainer.insert(lower_bound(m_sortedContainer.begin(), m_sortedContainer.end(), 
        elem, CFunc()), elem);
}

template<typename Type, typename CFunc>
inline bool SortedEvents<Type, CFunc>::checkIfThere(Type elem) const    // Very expensive function that might however be useful
{                                                                       // during debugging
    for(size_t i = 0; i < m_sortedContainer.size(); ++i)
    {
        if(elem == m_sortedContainer[i]) return true;
    }
    return false;
}


template<typename Type, typename CFunc>
inline void SortedEvents<Type, CFunc>::sortEvents() 
{
    sort(m_sortedContainer.begin(), m_sortedContainer.end(), CFunc());
}

template<typename Type, typename CFunc>
inline bool SortedEvents<Type, CFunc>::present(Type elem) const
{
    for(size_t i = 0; i < m_sortedContainer.size(); ++i)
    {
        if(elem == m_sortedContainer[i]) 
        {
            return true;
        }
    }
    return false;
}

template<typename Type, typename CFunc>
inline bool SortedEvents<Type, CFunc>::remove(Type elem) 
{
    EventItr delCand = lower_bound(m_sortedContainer.begin(), m_sortedContainer.end(), elem, CFunc());
    while(*delCand != elem && delCand != m_sortedContainer.end()) ++delCand;
    assert(*delCand == elem);
    m_sortedContainer.erase(delCand);
    return m_sortedContainer.empty();
}

template<typename Type, typename CFunc>
inline Type SortedEvents<Type, CFunc>::pop() 
{
    assert(!m_sortedContainer.empty());   
    Type elem = m_sortedContainer.back();
    m_sortedContainer.pop_back();
    return elem;
}

template<typename Type, typename CFunc>
inline Type SortedEvents<Type, CFunc>::peek() const 
{
    assert(!m_sortedContainer.empty());   
    return m_sortedContainer.back();
}    

template<typename Type, typename CFunc>
inline Type SortedEvents<Type, CFunc>::at(size_t pos) const 
{
    assert(m_sortedContainer.size() > pos);   
    return m_sortedContainer[pos];
}    

#endif
