% The format of the data files are as follows:
%
% Some header line (includes number of pores and size of network)
% Total number of colums, n
% Title for column number 1
% Title for column number 2
% Title for column number n
% Actual data
%
% Thses files will be created by keyword OUTPUT, option 1
% ==================== START USER INPUT ===================================

fid = fopen('flow_mat_pore.out', 'r');
fid2 = fopen('flow_mat_throat.out', 'r');
propColPore = 8;     % The column of pore/throat file you're interested in. In this case it
propColThroat = 7;   % is advancing contact angle

% ======================================================================-===

if fid == -1
   disp('oops, cant open pore file')
end

m_numPores = fscanf(fid, '%d', 1);
m_size = fscanf(fid, '%g', 3);
m_size = m_size.*1.0E6;
tmpStr = fgetl(fid);
m_numProps = fscanf(fid, '%d', 1) - 5;

for j = 1:15
   tmpStr = fgetl(fid);
end

m_poreLocX = zeros(m_numPores, 1);
m_poreLocY = zeros(m_numPores, 1);
m_poreLocZ = zeros(m_numPores, 1);
m_prop = zeros(m_numPores, 1);

for i = 1:m_numPores
   m_poreLocX(i) = fscanf(fid, '%g', 1)';
   m_poreLocY(i) = fscanf(fid, '%g', 1)';
   m_poreLocZ(i) = fscanf(fid, '%g', 1)';
   tmp(1:propColPore-4) = fscanf(fid, '%g', propColPore-4);
   m_prop(i) = fscanf(fid, '%g', 1);
   tmpStr = fgetl(fid);
end

fclose(fid);
% done reading pore data

% Start reading throat data
if fid2 == -1
   disp('oops, cant open throat file')
end

m_numThroats = fscanf(fid2, '%d', 1);

for j = 1:17
   tmpStr = fgetl(fid2);
end

m_poreIdxOne = zeros(m_numThroats, 1);
m_poreIdxTwo = zeros(m_numThroats, 1);
m_propT = zeros(m_numThroats, 1);

for i = 1:m_numThroats
   m_poreIdxOne(i) =  fscanf(fid2, '%d', 1)';
   m_poreIdxTwo(i) =  fscanf(fid2, '%d', 1)';
   tmp(1:propColPore-3) = fscanf(fid2, '%g', propColPore-3);
   m_propT(i) = fscanf(fid2, '%g', 1)';
   tmpStr = fgetl(fid2);
end

fclose(fid2);
% done

