% ================== START USER INPUT DATA =======================

m_cut = 90;     % The cut-off threshold to determine wheter to render an element back/white
m_numSlices 30; % How many slices should the box be split into
m_slice = 10;   % Which slice to plot

% ================= END USER INPUT DATA ==========================

%figure('Position', [100 100 800 800])   % If you want higher resolution in the output
figure
xlim([0 m_size(1)]);
ylim([0 m_size(2)]);
set(gca,'YTick',[-1.0 1.0E9])
set(gca,'XTick',[-1.0 1.0E9])
box on
pbaspect([1 1 1])

m_thick = m_size(3)/m_numSlices;

hold on
for i = 1:m_numThroats
   if (m_poreIdxOne(i)*m_poreIdxTwo(i)) > 0         % If index is either 0 or -1 the result
      m_pos(1, 1) = m_poreLocX(m_poreIdxOne(i));    % will 0 or negative (Don't want to include
      m_pos(1, 2) = m_poreLocY(m_poreIdxOne(i));    % entry/exit res
      m_pos(1, 3) = m_poreLocZ(m_poreIdxOne(i));
      m_pos(2, 1) = m_poreLocX(m_poreIdxTwo(i));
      m_pos(2, 2) = m_poreLocY(m_poreIdxTwo(i));
      m_pos(2, 3) = m_poreLocZ(m_poreIdxTwo(i));

      m_insideOne = m_poreLocZ(m_poreIdxOne(i)) > (m_slice-1)*m_thick & ...
                    m_poreLocZ(m_poreIdxOne(i)) < (m_slice)*m_thick;

      m_insideTwo = m_poreLocZ(m_poreIdxTwo(i)) > (m_slice-1)*m_thick & ...
                    m_poreLocZ(m_poreIdxTwo(i)) < (m_slice)*m_thick;

      m_vec = m_pos(2,:) - m_pos(1,:);
      m_len = sqrt(m_vec * m_vec');


      if m_len < 0.5*mean(m_size) & m_propT(i) > m_cut  & (m_insideOne | m_insideTwo)
         plot(m_pos(:,1), m_pos(:,2), '-', 'Color', 'black', 'LineWidth', 0.5);
      end
   end
end

for i = 1:m_numPores
   m_inside = m_poreLocZ(i) > (m_slice-1)*m_thick & m_poreLocZ(i) < (m_slice)*m_thick;
   if  m_prop(i) > m_cut & m_inside
      plot(m_poreLocX(i), m_poreLocY(i), 'o', 'MarkerFaceColor', 'black', ...
                                              'MarkerEdgeColor', 'black', ...
                                              'MarkerSize', 5);
   end
end
















