% First you'll have to decide what aspect of the displacement process you want
% to investigate. Both drainage and imbibition is given in the same file. Drainage
% data will naturally be in the first colums, followed by imbibition data. Imbibition
% starts where you see the global sw starting to increase again. The format of the data
% files are as follows:
%
% Some header line (includes number of pores and size of network)
% Total number of colums, n
% Title for column number 1
% Title for column number 2
% Title for column number n
% Actual data
% =============================== START USER INPUT =====================================

fid = fopen('corr_pore_sw.out', 'r');       % File containing pore data
fid2 = fopen('corr_throat_sw.out', 'r');    % File containing throat data
m_startSwData = 3;                          % Which sw data do you want to read into memory. A starting index of 1 starts reading first
m_endSwData = 3;                            % available sw data (drainage), and you also chose an ending column. The more columns you want
                                            % to read in the higher the memory requirement of matlab will be
% ================================ END USER INPUT =====================================


m_numSwData = m_endSwData - m_startSwData + 1;

if fid == -1
   disp('oops, cant open pore file')
end

m_numPores = fscanf(fid, '%d', 1);
m_size = fscanf(fid, '%g', 3);
tmpStr = fgetl(fid);
m_numSwDataTrue = fscanf(fid, '%d', 1) - 5;

for j = 1:6
   tmpStr = fgetl(fid);
end

j=0;
for i = 1:m_numSwDataTrue
   if (i >= m_startSwData & i <= m_endSwData)
      j = j+1;
      m_globalSw(j) = fscanf(fid, '%g', 1);
      tmpStr = fgetl(fid);
   else
      tmpStr = fgetl(fid);
   end
end

m_poreLocX = zeros(m_numPores, 1);
m_poreLocY = zeros(m_numPores, 1);
m_poreLocZ = zeros(m_numPores, 1);
m_Sw = zeros(m_numPores, m_numSwData);

for i = 1:m_numPores
   tmp = fscanf(fid, '%d', 1);
   m_poreLocX(i) = fscanf(fid, '%g', 1)';
   m_poreLocY(i) = fscanf(fid, '%g', 1)';
   m_poreLocZ(i) = fscanf(fid, '%g', 1)';
   tmp(1:m_startSwData) = fscanf(fid, '%g', m_startSwData);
   m_Sw(i,1:m_numSwData) = fscanf(fid, '%g', m_numSwData)';
   tmpStr = fgetl(fid);
end

fclose(fid);
% done reading pore data

% Start reading throat data
if fid2 == -1
   disp('oops, cant open throat file')
end

m_numThroats = fscanf(fid2, '%d', 1);

for j = 1:(m_numSwDataTrue + 5)
   tmpStr = fgetl(fid2);
end

m_poreIdxOne = zeros(m_numThroats, 1);
m_poreIdxTwo = zeros(m_numThroats, 1);
m_SwT = zeros(m_numThroats, m_numSwData);

for i = 1:m_numThroats
   m_poreIdxOne(i) =  fscanf(fid2, '%d', 1)';
   m_poreIdxTwo(i) =  fscanf(fid2, '%d', 1)';
   tmp(1:m_startSwData) = fscanf(fid2, '%g', m_startSwData);
   m_SwT(i,1:m_numSwData) = fscanf(fid2, '%g', m_numSwData)';
   tmpStr = fgetl(fid2);
end

fclose(fid2);
% done






