m_aviObj = avifile('test.avi', 'compression', 'Indeo5', 'fps', 15, 'quality', 100);
numFrames = 300;    % How long should the movie be x/fps, in this case 300/15=20 sec

figure('Position', [10 10 800 800]) % Non-default size?
%figure
xlim([0 modSize(1)]);
ylim([0 modSize(2)]);
zlim([0 modSize(3)]);

set(gca,'YTick',[-1.0 1.0])
set(gca,'XTick',[-1.0 1.0])
set(gca,'ZTick',[-1.0 1.0])

box on
pbaspect([1 1 1])
hold on

view([30 40])   % Change this to set a different perspecive

numSteps = size(backbone);
for i = 1:numSteps(1)
    idx = backbone(i,1);
    if backbone(i,2) == 1   % pore
        plot3(poreLoc(idx,1), poreLoc(idx,2), poreLoc(idx,3), ...
                                                  'o', 'EraseMode', 'none', ...
                                                  'MarkerFaceColor', 'red', ...
                                                  'MarkerEdgeColor', 'red', ...
                                                  'MarkerSize', 1.5);
    else
        pore1 = throatConn(idx,1);
        pore2 = throatConn(idx,2);
        if pore1*pore2 > 0
            pos(1, 1) = poreLoc(pore1, 1);
            pos(1, 2) = poreLoc(pore1, 2);
            pos(1, 3) = poreLoc(pore1, 3);
            pos(2, 1) = poreLoc(pore2, 1);
            pos(2, 2) = poreLoc(pore2, 2);
            pos(2, 3) = poreLoc(pore2, 3);
            vec = pos(2,:) - pos(1,:);
            len = sqrt(vec * vec');

            if len < 0.5*mean(modSize)
                plot3(pos(:,1), pos(:,2), pos(:,3), '-', 'EraseMode', 'none', ...
                                                    'Color', 'red', ...
                                                    'LineWidth', 1.0);
            end
        end
    end
end
F = getframe;
m_aviObj = addframe(m_aviObj, F);


numSteps = size(fill);
frameEvery = numSteps / numFrames;
frameCounter = 0;
frameNum = 0;

for i = 1:numSteps(1)
    idx = fill(i,1);
    frameCounter = frameCounter + 1;
    if fill(i,2) == 1   % pore
        plot3(poreLoc(idx,1), poreLoc(idx,2), poreLoc(idx,3), ...
                                                  'o', 'EraseMode', 'none', ...
                                                  'MarkerFaceColor', 'red', ...
                                                  'MarkerEdgeColor', 'red', ...
                                                  'MarkerSize', 1.5);
    else
        pore1 = throatConn(idx,1);
        pore2 = throatConn(idx,2);
        if pore1*pore2 > 0
            pos(1, 1) = poreLoc(pore1, 1);
            pos(1, 2) = poreLoc(pore1, 2);
            pos(1, 3) = poreLoc(pore1, 3);
            pos(2, 1) = poreLoc(pore2, 1);
            pos(2, 2) = poreLoc(pore2, 2);
            pos(2, 3) = poreLoc(pore2, 3);
            vec = pos(2,:) - pos(1,:);
            len = sqrt(vec * vec');

            if len < 0.5*mean(modSize)
                plot3(pos(:,1), pos(:,2), pos(:,3), '-', 'EraseMode', 'none', ...
                                                    'Color', 'red', ...
                                                    'LineWidth', 1.0);
            end
        end
    end

    if frameCounter > frameEvery
        frameNum = frameNum + 1;
        F = getframe;
        m_aviObj = addframe(m_aviObj, F);
        frameCounter = 0;
    end
end

m_aviObj = close(m_aviObj);
