/*$Id: alloc_multicomp.c 887 2006-03-01 18:21:01Z rcatwood $*/
#include <stdio.h>
#include "machine.h"
#include "blocks.h"
#include "readmat.h"

void free_ms (MultiS_struct * ms, int ele_1)
{
  int i;

  for (i = 0; i < ele_1; i++) {
    free (ms->Diff_matrix_liq[i]);
    free (ms->Diff_matrix_sol[i]);
    free (ms->Clim_multi[i]);
    free (ms->part_coef_matrix[i]);
  }
  free (ms->Cinit_multi);
  free (ms->LDiff_multi);
  free (ms->SDiff_multi);
  free (ms->part_coef_multi);
  free (ms->part_coef_matrix);
  free (ms->Clim_multi);
  free (ms->slope_multi);
  free (ms->Diff_matrix_liq);
  free (ms->Diff_matrix_sol);
  return;
}

void alloc_ms (MultiS_struct * ms, int ele_1, int nc)
{
  int errs = 0;
  int i, j;

   /******************allocating memory to array pointers******************/

  ms->Cinit_multi = (CA_FLOAT *) calloc (ele_1, sizeof (CA_FLOAT));
  if (ms->Cinit_multi == NULL)
    errs++;
  ms->LDiff_multi = (CA_FLOAT *) calloc (ele_1, sizeof (CA_FLOAT));
  if (ms->LDiff_multi == NULL)
    errs++;
  ms->SDiff_multi = (CA_FLOAT *) calloc (ele_1, sizeof (CA_FLOAT));
  if (ms->SDiff_multi == NULL)
    errs++;
  ms->part_coef_multi = (CA_FLOAT *) calloc (ele_1, sizeof (CA_FLOAT));
  if (ms->part_coef_multi == NULL)
    errs++;
  ms->part_coef_matrix = (CA_FLOAT **) calloc (ele_1, sizeof (CA_FLOAT *));
  if (ms->part_coef_matrix == NULL)
    errs++;
  ms->Clim_multi = (CA_FLOAT **) calloc (ele_1, sizeof (CA_FLOAT *));
  if (ms->Clim_multi == NULL)
    errs++;
  ms->slope_multi = (CA_FLOAT *) calloc (ele_1, sizeof (CA_FLOAT));
  if (ms->slope_multi == NULL)
    errs++;

  ms->Diff_matrix_liq = (CA_FLOAT **) calloc (ele_1, sizeof (CA_FLOAT *));
  if (ms->Diff_matrix_liq == NULL)
    errs++;

  ms->Diff_matrix_sol = (CA_FLOAT **) calloc (ele_1, sizeof (CA_FLOAT *));
  if (ms->Diff_matrix_sol == NULL)
    errs++;

  for (i = 0; i < ele_1; i++) {
    ms->Diff_matrix_liq[i] = (CA_FLOAT *) calloc (ele_1, sizeof (CA_FLOAT));
    if (ms->Diff_matrix_liq[i] == NULL)
      errs++;
    ms->Diff_matrix_sol[i] = (CA_FLOAT *) calloc (ele_1, sizeof (CA_FLOAT));
    if (ms->Diff_matrix_sol[i] == NULL)
      errs++;
    ms->Clim_multi[i] = (CA_FLOAT *) calloc (nc, sizeof (CA_FLOAT));
    if (ms->Clim_multi[i] == NULL)
      errs++;
    ms->part_coef_matrix[i] = (CA_FLOAT *) calloc (nc, sizeof (CA_FLOAT));
    if (ms->part_coef_matrix[i] == NULL)
      errs++;
  }

      /*********************************************************/
  /* Set the default values...                         */
      /*********************************************************/
  for (i = 0; i < ele_1; i++) { /*definning the default values for diff coeff *//*initial concentration and partitionning for */
    ms->Cinit_multi[i] = 6.0;   /*solute elements */
    ms->LDiff_multi[i] = 1.0E-08;
    ms->SDiff_multi[i] = 1.0E-13;
    ms->part_coef_multi[i] = 0.13;
    ms->slope_multi[i] = -7.0;
    ms->bin_eut_max[i] = 12;
    ms->bin_eut_temp[i] = 570.0;
    ms->ter_eut_max[i] = 27.0;
    ms->ter_eut_temp[i] = 520.0;
    for (j = 0; j < ele_1; j++) {
      if (j != i) {
        ms->Diff_matrix_liq[i][j] = (ms->LDiff_multi[i] + ms->LDiff_multi[j]) / 20.0;
        ms->Diff_matrix_sol[i][j] = (ms->SDiff_multi[i] + ms->SDiff_multi[j]) / 20.0;
      } else {
        ms->Diff_matrix_liq[i][j] = (ms->LDiff_multi[i] + ms->LDiff_multi[j]) / 2.0;
        ms->Diff_matrix_sol[i][j] = (ms->SDiff_multi[i] + ms->SDiff_multi[j]) / 2.0;
      }
    }
  }
   /*************************************************************************/
  if (errs != 0) {
    fprintf (stderr, "ERROR: alloc_multicomp: Allocation failed %i \n", errs);
  }
  return;
}

/***************************************************/
/* rcs id routine to include rcs id in the program */
/* generated by make_rcs_sub.sh script             */
/***************************************************/
char const *alloc_multicomp_c ()
{
  static char const rcsid[] = "$Id: alloc_multicomp.c 887 2006-03-01 18:21:01Z rcatwood $";

  return (rcsid);
}
