#include <stdio.h>
#include <math.h>
#include "machine.h"
#include "ca_histo.h"

/* if stat flag is FIRST_CALL, print the bin values otherwise just the histo.*/
/* if there are more than 255 bins then you cannot easily read it into excel!*/
int ca_histo (FILE * listfile, Histo_struct * hp, CA_FLOAT * list, int stepnum)
{

  int errors = 0;
  int bin, i;
  CA_FLOAT *listp;
  CA_FLOAT maxbin;
  CA_FLOAT binsize;
  CA_FLOAT thisbin;
  int *g_nuc_histo;

  /* no grains */
  if (list == NULL)
    return (0);

  /*there are grains */
  maxbin = hp->minbin + hp->nbins * hp->binsize;
  g_nuc_histo = calloc (hp->nbins + 1, sizeof (int));

  for (listp = list; listp < list + hp->ndata; listp++) {
    bin = (int) FLOOR ((*listp - hp->minbin) / hp->binsize);
    bin = bin < 0 ? 0 : bin;
    bin = bin > hp->nbins ? hp->nbins : bin;
    (*(g_nuc_histo + bin))++;
  }

  fprintf (listfile, "%i", stepnum);
  /* print the statistical values */
  for (i = 0; i < 4; i++) {
    fprintf (listfile, ",%.5g", hp->stat[i]);
  }
  /* print the histogram values */
  for (bin = 0; bin <= hp->nbins; bin++) {
    fprintf (listfile, ",%i", (*(g_nuc_histo + bin)));
  }
  fprintf (listfile, "\n");

  free (g_nuc_histo);
  return (errors);
}

/* Little subroutine to get rcs id into the object code */
/* so you can use ident on the compiled program  */
/* also you can call this to print out or include the rcs id in a file */
char const *rcs_id_ca_histo_c ()
{
  static char const rcsid[] = "$Id: ca_histo.c 887 2006-03-01 18:21:01Z rcatwood $";

  return (rcsid);
}

/* end of rcs_id_subroutine */
