/****************************************************************/
/*      Copyright (c) 1998 Dept. of Materials, ICSTM            */
/*      All Rights Reserved                                     */
/*      THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF ICSTM    */
/*      The copyright notice above does not evidence any        */
/*      actual or intended publication of such source code,     */
/*      and is an unpublished work by Dept. of Materials, ICSTM.*/
/*      This material contains CONFIDENTIAL INFORMATION that    */
/*      is the property of Imperial College. Any use,           */
/*      duplication or disclosure not specifically authorized   */
/*      by Imperial College is strictly prohibited.             */
/****************************************************************/
/* This code is part of the umats routines developed at in the  */
/* Materials Processing Group, Dept. of Materials, ICSTM.       */
/*	email p.d.lee or r.atwood @ic.ac.uk for details         */
/****************************************************************/

/****************************************************************/
/* READ_MAT.C:   (Part of CA code)                              */
/* Subroutine to read the material properties from a file.      */
/* The file is formated, using the style:                       */
/*    # as first character:     Comment                         */
/* and values are input in the format:                          */
/*    command value  #comments                                  */
/****************************************************************/
/****************************************************************/
/* Written by Peter D. Lee & Robert C. Atwood, Imperial College */
/* Jul 1, 1998                                                  */
/* Ludovic Thuinet                                              */
/* 2005                                                         */
/****************************************************************/

/****************************************************************/
/* Versions maintained with CVS                                 */
/* see log at end of file ***************************************/
/****************************************************************/
/*RCS id $Id: calc_solprops_poly.c 887 2006-03-01 18:21:01Z rcatwood $*/
#include <stdio.h>
#include <string.h>
#include <math.h>
#include "machine.h"
#include "read_ctrl.h"
#include "readmat.h"
#include "blocks.h"
#include "solprops_reader.h"
#include "solprops_writer.h"
void calc_solprops_poly(BB_struct *bp, Mat_str *mp, Solute_props *sp, int tp_flag, int ieq_tot) {
  /* subroutine to calculate derived properties for POLYCOMPONENT alloys */
  /* this routine shoud not be called at all if poly-component mode is not selected */
  /*THUINET 02/05 et 04/05 */

  int ieq;

  if (tp_flag == 1) {

    fprintf (stderr, "T_pure specified for polycomponent alloys, OVERRIDING liquidus\n");

    for (ieq = 0; ieq < ieq_tot; ieq++) {
      mp->Tliq_poly[ieq] += sp->m_solute[ieq] * sp->Cinit;
      fprintf (stderr, "Liquidus Temperature Tliq[%d] = %.6g\n", ieq, mp->Tliq_poly[ieq]);
    }

  } else {

    fprintf (stderr, "T_pure not specified for polycomponent alloys, calculating..\n");

    for (ieq = 0; ieq < ieq_tot; ieq++) {
      mp->tp_poly[ieq] -= sp->m_solute[ieq] * sp->Cinit;
      fprintf (stderr, "Reference Temperature Tp[%d] = %.6g\n", ieq, mp->tp_poly[ieq]);
    }

  }

  sp->Fs_eut = 1.0;

  /*FIN THUINET 02/05 and 04/05 */

}/* end of calc_solprops_poly */
