/****************************************************************/
/*   Copyright (c) 1998 Dept. of Materials, ICSTM               */
/*   All Rights Reserved                                        */
/*   THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF ICSTM       */
/*   The copyright notice above does not evidence any           */
/*   actual or intended publication of such source code,        */
/*   and is an unpublished work by Dept. of Materials, ICSTM.   */
/*   This material contains CONFIDENTIAL INFORMATION that       */
/*   is the property of Imperial College. Any use,              */
/*   duplication or disclosure not specifically authorized      */
/*   by Imperial College is strictly prohibited.                */
/****************************************************************/
/* This code is part of the umats routines developed at in the  */
/* Materials Processing Group, Dept. of Materials, ICSTM.       */
/*      email p.d.lee or r.atwood @ic.ac.uk for details         */
/****************************************************************/

/****************************************************************/
/* CUBE.H:                                                      */
/* Structures and flags for copysurf.c and initface.c.          */
/****************************************************************/
/****************************************************************/
/* Written by Peter D. Lee & Robert C. Atwood, Imperial College */
/* Aug 24, 1998                                                  */
/****************************************************************/
/*      MODIFIED by:                                            */
/*  PDL: Aug 24, 1998                                           */
/*  RCA: Sept 4, 1998                                                            */
/*                                                              */
/*                                                              */
/****************************************************************/
/*RCS Id:$Id: cube.h 887 2006-03-01 18:21:01Z rcatwood $*/
#ifndef CUBE_H
#define CUBE_H


/******************************************************/
/*  flags for copy_surf routines                      */
/******************************************************/
#define WRAP    0
#define PAD     1
#define FIX_BDY 2
#define INS     3
#define FLUX_BDY 4

#define FORWARD 0
#define BACK 1

#define TWO_D_CA   2
#define THREE_D 3
/******************************************************/
/* indices into face code lookup table                */
/******************************************************/
#define START   0
#define SKIP    1
#define JUMP    2
#define POFF    3
#define WOFF    4
#define ISTART  5
#define ISKIP   6
#define IJUMP   7
#define IPOFF   8
#define NBOFF   9
/* axis defs  -- might not use these after all as they are not useful as loop indices  */
#define XAXIS 0
#define YAXIS 1
#define ZAXIS 2

#define CM_INS  0
#define CM_FACE 1
#define CM_EDGE 2
#define CM_CORN 3
#define XY_INS 2
#define XY_EDGE 3
#define XY_CORN 4

/***********************************************/
/* a useful little structure that has x,y,z axes  */
/* this is used by Frame structure below          */
/***********************************************/
typedef struct axes {
   int x,y,z;     
} Geom;

/***********************************************/
/*  This structure stores the information      */
/*  that describes the symmetry of the (cubic) */
/*  neighbourhoods and subblock shapes used.   */
/*  elist and clist store the permutations of  */
/*  faces that adjoin each edge and corner     */
/*  so that the external neighbours of a cell  */
/*  at the edge of a subblock can be easily    */
/*  looked up.  The other members store the    */
/*  offsets in the main array of the various   */
/*  neighbour cells.                           */
/* it is a little confusing but it works!!!    */
/* and saves doing lots of cnditional tests    */
/***********************************************/
typedef struct symm { /* This assumes hexahedral subblocks! It should be*/ 
   CA_FLOAT ivalue; /*to pass the init. value for type FIX_BDY copy_surf*/
   CA_FLOAT dtbydx; /* flux coefficient deltat / deltax */
   int code;
   int nouts;
   int curr;
   int bbins[3];
   int ins[3];        /* to pass the inside block size       */
   int outs[3];       /* and not have to figure it out again */
   int flist[6][10];   /* the face offsets for pad copying    */
   int ndim;          /* the number of dimensions */
   int edge[3][4];    /* possibe to use even if not rectangular, I think!*/
   int elist[12][6];  /* the edge permutations       */
   int clist[8][6];   /* the corner permutations     */
   int dlist[8][6];   /* the flat 2-d corner permutations  */
   int neigh[6];      /* offset of normal neighbours */
   int corner[8];     /* location of corner cells    */
   int face[6];       /* offset of opposite face     */
   int facectrl[6];    /* flags to control face wrap/pad */
   Geom nn;    /* for the bigblock, # sblocks to avoid duplicate calc's   */
} Frame;

#endif /* CUBE_H */
/*
RCS Log:$Log$
RCS Log:Revision 11.1  2006/03/01 18:20:39  rcatwood
RCS Log:Merging polycomponent and gas with meltback
RCS Log:
RCS Log:Revision 10.2  2005/12/01 14:38:01  rcatwood
RCS Log:Merged xly_05 changes into the main trunk
RCS Log:Primarily involving melt-back
RCS Log:
RCS Log:Revision 10.1.2.2  2005/11/23 18:18:53  rcatwood
RCS Log:Result of merging mould_source and xly meltback+curvature 2d versions
RCS Log:
RCS Log:Revision 10.1  2005/11/03 11:56:46  rcatwood
RCS Log:New version number -- using mould_src as base
RCS Log:
RCS Log:Revision 8.1.14.2  2005/11/02 11:55:05  rcatwood
RCS Log:Fixing up the revision nubmer after loss of repository
RCS Log:
RCS Log:Revision 9.2  2003/10/27 20:01:11  rcatwood
RCS Log:Harmonized header file cpp protection
RCS Log:Fixed filename bug for restart
RCS Log:
RCS Log:Revision 9.1  2003/08/14 14:38:35  rcatwood
RCS Log:Working merge with decentered/porosity/procast, also including
RCS Log:Ali Chirazi's multicomponent (not tested in this version)
RCS Log:
RCS Log:Revision 8.1.8.5  2003/05/19 18:55:16  rcatwood
RCS Log:Addded option to allow horizontal or vertical directional growth
RCS Log:and flux boundary condition
RCS Log:
RCS Log:Revision 8.1.8.4  2003/03/21 18:16:41  rcatwood
RCS Log:added flat (xy-plane) mulitblock geometry
RCS Log:Tried to improve Makefile for ca_read
RCS Log:
RCS Log:Revision 8.1.8.3  2003/01/22 16:53:43  rcatwood
RCS Log:Almost working read_fg version
RCS Log:
RCS Log:Revision 8.1.8.2  2003/01/15 19:02:00  rcatwood
RCS Log:*** empty log message ***
RCS Log:
RCS Log:Revision 8.1.6.1  2002/11/06 17:27:45  rcatwood
RCS Log:NOT WORKING check-in of first stage merge with ca_procast
RCS Log:
RCS Log:Revision 7.0.8.1  2002/08/27 14:18:17  chirazi
RCS Log:adding files for multi-component-Procast version of CA
RCS Log:
RCS Log:Revision 7.0  2000/11/07 15:55:38  rcatwood
RCS Log:Multi Cell Pores added
RCS Log:
RCS Log:Revision 6.0  2000/09/25 18:03:37  rcatwood
RCS Log:After PORE_00 and NLM
RCS Log:
RCS Log:Revision 2.0  2000/08/02 10:21:56  rcatwood
RCS Log:Version used for pore paper runs
RCS Log:
RCS Log:Revision 1.1  2000/05/22 12:29:24  rcatwood
RCS Log:Fixed fs finish. Casolid to C from  W file. Global option
RCS Log:
RCS Log:Revision 5.1  2000/03/02 16:11:10  rcatwood
RCS Log:Merged xxu and rca versions
RCS Log:
RCS Log:Revision 5.0.2.1  2000/03/01 15:54:30  rcatwood
RCS Log:merged VAR and Multiblock updates. Not tested
RCS Log:
RCS Log:Revision 5.0.1.1  2000/02/22 19:04:27  rcatwood
RCS Log:Not yet tested
RCS Log:
RCS Log:Revision 4.2  1999/12/23 18:12:24  rcatwood
RCS Log:Version used for Mcwasp runs
RCS Log:
RCS Log:Revision 4.1  1999/12/16 13:33:44  rcatwood
RCS Log:Finalised improved use of RCS in all files.
RCS Log:
RCS Log:Revision 4.0.2.1  1999/12/16 12:37:36  rcatwood
RCS Log:Improving rcs id for all files, this may require several checkins to test.
RCS Log:
*/
