/*---------------------------------------------------------------------*/
/*             external temperature  Code   by LY   11/2009     
							allocate memory and free memory
*/
/*---------------------------------------------------------------------*/

#include "ext_inp.h"
#include "ff_memory.h"

int ext_alloc_bb(BB_struct *bp)
{
 
  int xmax, ymax, zmax;

  xmax = bp->ext_nc[0];
  ymax = bp->ext_nc[1];
  zmax = bp->ext_nc[2];
  
  bp->ext_times = (double *)(malloc(sizeof(double)*(bp->ext_num_steps)));
 	
	
  bp->ext_temp_new = realmemalloc(0, xmax, 0, ymax, 0, zmax);
  bp->ext_temp = realmemalloc(0, xmax, 0, ymax, 0, zmax);
  bp->ext_temp_old = realmemalloc(0, xmax, 0, ymax, 0, zmax);
  bp->ext_status= intmemalloc(0, xmax, 0, ymax, 0, zmax);

  fprintf(stderr, "EXTERNAL_TEMP: Memory allocated!!!\n");
  return 0;

}


int ext_free_bb(BB_struct *bp)
{
  int xmax, ymax, zmax;

  xmax = bp->ext_nc[0];
  ymax = bp->ext_nc[1];
  zmax = bp->ext_nc[2];
	   
	
  free(bp->ext_times);
  freerealmem(bp->ext_temp_new, 0, xmax, 0, ymax, 0, zmax);
  freerealmem(bp->ext_temp, 0, xmax, 0, ymax, 0, zmax);
  freerealmem(bp->ext_temp_old, 0, xmax, 0, ymax, 0, zmax);
  freeintmem(bp->ext_status, 0, xmax, 0, ymax, 0, zmax);

  fprintf(stderr, "EXTERNAL_TEMP: Memory free!!!\n");
  return 0;

}
