/************************************************************************/
/*             Fluid Flow Code   by LY   12/2008   
                  boundary condtions for cycling velocity
*/
/************************************************************************/

#include "ff_mpflow.h"
#include <math.h>

void boundary_cyc (BB_struct *bp)
{

	int i,j,k;
	
	CA_FLOAT ***ca_cell_u, ***ca_cell_v, ***ca_cell_w, ***ca_cell_p;
	CA_FLOAT ***ca_cell_t, ***ca_cell_ftry, ***enthalpy;
	int ***cflag;
	CA_FLOAT theta;
	
        int IMAX, JMAX, KMAX;
        CA_FLOAT sizex, sizey, sizez;
	
        CA_FLOAT INITTEMPCOLD, INITTEMPHIGH;
	CA_FLOAT heatflux, thermcond;
	CA_FLOAT latent;
	CA_FLOAT cp;
				
        IMAX = bp->tnc[0];
	JMAX = bp->tnc[1];
	KMAX = bp->tnc[2];
	INITTEMPHIGH = bp->inithighT;
	INITTEMPCOLD = bp->initcoldT;
	sizex = bp->size_c[0];
	sizey = bp->size_c[1];
	sizez = bp->size_c[2];
	heatflux = bp->heatflux;
	thermcond = bp->mprops.thermcond;
	//      INITVELO = bp->initvelo;
	latent = bp->mprops.latentH;
	cp = bp->mprops.cp;


	ca_cell_u = bp->ca_cell_u;
	ca_cell_v = bp->ca_cell_v;
	ca_cell_w = bp->ca_cell_w;
	ca_cell_p = bp->ca_cell_p;
	ca_cell_t = bp->ca_cell_t;
//	ca_cell_fl = bp->ca_cell_fl;
	ca_cell_ftry = bp->ca_cell_ftry;

	cflag = bp->cflag;

	theta = bp->sim_time * 2 * PI / bp->tonecyc;

//	theta = 1;

	for (i=1; i<=IMAX; i++){
 	  for (j=1; j<=JMAX; j++){
	    for (k=1; k<=KMAX; k++){
	      if (cflag[i][j][k] == FFCELL){
		if (cflag[i-1][j][k] == BCCELL){
		  ca_cell_u[i-1][j][k] = bp->initvelo[0] * cos(theta);
		  ca_cell_v[i-1][j][k] = 2 * bp->initvelo[0] * sin(theta) - ca_cell_v[i][j][k];
		  ca_cell_w[i-1][j][k] = (-1.0) * ca_cell_w[i][j][k];
		  
//	          ca_cell_t[i-1][j][k] = 2*INITTEMPHIGH - ca_cell_t[i][j][k];
		  ca_cell_t[i-1][j][k] =  ca_cell_t[i][j][k];
//		  ca_cell_fl[i-1][j][k] = ca_cell_fl[i][j][k];
		  ca_cell_p[i-1][j][k] = ca_cell_p[i][j][k];
		  ca_cell_ftry[i-1][j][k] = ca_cell_ftry[i][j][k];
		  
		} 
		if (cflag[i+1][j][k] == BCCELL)	{
		  ca_cell_u[i][j][k] = bp->initvelo[0] * cos(theta);
		  ca_cell_v[i+1][j][k] = 2 * bp->initvelo[0] * sin(theta) - ca_cell_v[i][j][k];
		  ca_cell_w[i+1][j][k] = (-1.0) * ca_cell_w[i][j][k]; 

//		  ca_cell_t[i+1][j][k] = 2*INITTEMPCOLD - ca_cell_t[i][j][k];
		  ca_cell_t[i+1][j][k] =   ca_cell_t[i][j][k];
//  		  ca_cell_fl[i+1][j][k] = ca_cell_fl[i][j][k];
  		  ca_cell_p[i+1][j][k] = ca_cell_p[i][j][k];
		  ca_cell_ftry[i+1][j][k] = ca_cell_ftry[i][j][k];
		}
		if (cflag[i][j-1][k] == BCCELL)	{
		  ca_cell_u[i][j-1][k] = 2 * bp->initvelo[0] * cos(theta)-ca_cell_u[i][j][k];
		  ca_cell_v[i][j-1][k] = bp->initvelo[0] * sin(theta);
		  ca_cell_w[i][j-1][k] = (-1.0) * ca_cell_w[i][j][k]; 
		  
		  ca_cell_t[i][j-1][k] = heatflux*sizey/thermcond + ca_cell_t[i][j][k];
//		  ca_cell_fl[i][j-1][k] = ca_cell_fl[i][j][k];
		  ca_cell_p[i][j-1][k] = ca_cell_p[i][j][k];
//		  ca_cell_p[i][j-1][k] = 0.0;
		  ca_cell_ftry[i][j-1][k] = ca_cell_ftry[i][j][k];
		}
		if (cflag[i][j+1][k] == BCCELL)	{
		  ca_cell_u[i][j+1][k] = 2 * bp->initvelo[0] * cos(theta)-ca_cell_u[i][j][k];
		  ca_cell_v[i][j][k] = bp->initvelo[0] * sin(theta);
		  ca_cell_w[i][j+1][k] = (-1.0) * ca_cell_w[i][j][k]; 

//		  ca_cell_t[i][j+1][k] = ca_cell_t[i][j][k];
		  ca_cell_t[i][j+1][k] = - heatflux*sizey/thermcond + ca_cell_t[i][j][k];
//		  ca_cell_fl[i][j+1][k] = ca_cell_fl[i][j][k];
		  ca_cell_p[i][j+1][k] = ca_cell_p[i][j][k];
//		  ca_cell_p[i][j+1][k] = 0.0;
		  ca_cell_ftry[i][j+1][k] = ca_cell_ftry[i][j][k];
		  
		}
		if (cflag[i][j][k-1] == BCCELL)	{
		  ca_cell_u[i][j][k-1] = ca_cell_u[i][j][k];
		  ca_cell_v[i][j][k-1] = ca_cell_v[i][j][k];
		  ca_cell_w[i][j][k-1] = ca_cell_w[i][j][k];
		  
		  ca_cell_t[i][j][k-1] = ca_cell_t[i][j][k];
		  ca_cell_p[i][j][k-1] = ca_cell_p[i][j][k];
		  ca_cell_ftry[i][j][k-1] = ca_cell_ftry[i][j][k];
		}
		if (cflag[i][j][k+1] == BCCELL) {
		  ca_cell_u[i][j][k+1] = ca_cell_u[i][j][k];
		  ca_cell_v[i][j][k+1] = ca_cell_v[i][j][k]; 
		  ca_cell_w[i][j][k] = ca_cell_w[i][j][k-1];
		  
		  ca_cell_t[i][j][k+1] = ca_cell_t[i][j][k];
		  ca_cell_p[i][j][k+1] = ca_cell_p[i][j][k];
		  ca_cell_ftry[i][j][k+1] = ca_cell_ftry[i][j][k];
		  
		}

	      } 

	    } /* end of k loop*/
	  } /* end of j loop*/
	} /* end of i loop*/


}
