/*----------------------------------------------------------------------*/
/*             Fluid Flow Code   by LY   01/2008      
						Computation of tentative velocity field (F,G,H)
*/
/*----------------------------------------------------------------------*/

#include "ff_mpflow.h"


void calc_fgh_imptest(BB_struct *bp){

	int i,j,k;
	
	CA_FLOAT ***ca_cell_u, ***ca_cell_v, ***ca_cell_w, ***ca_cell_p;
	int ***cflag;
	CA_FLOAT ***ca_cell_t;
	CA_FLOAT ***cell_f, ***cell_g, ***cell_h;
	CA_FLOAT ***ca_cell_ftry;
	CA_FLOAT tempftry;

	CA_FLOAT sizex,sizey,sizez;
	CA_FLOAT delttime;
	CA_FLOAT m_density, m_viscosity, dy_visc;

	CA_FLOAT ***urhs, ***vrhs, ***wrhs;
	int iteru, iterv, iterw;

	CA_FLOAT laplu, laplv, laplw;
	CA_FLOAT du2dx, duvdy, duwdz;	
	CA_FLOAT duvdx, dv2dy, dvwdz;
	CA_FLOAT duwdx, dvwdy, dw2dz;


	CA_FLOAT conv_term_x, diff_term_x, source_term_x, ***conv_x_old;
	CA_FLOAT conv_term_y, diff_term_y, source_term_y, ***conv_y_old;
	CA_FLOAT conv_term_z, diff_term_z, source_term_z, ***conv_z_old;
	CA_FLOAT carcoz_x, carcoz_y, carcoz_z;   //Carman-Cozeny 
	CA_FLOAT delpx, delpy, delpz;
	CA_FLOAT rev_dx2, rev_dy2, rev_dz2, rev_dxyz;
        int IMAX, JMAX, KMAX;
	CA_FLOAT TEMP_REF;
	CA_FLOAT GX,GY,GZ;
	CA_FLOAT CCCONST;
	CA_FLOAT BETA;
					
	CA_FLOAT ***pe, ***pw, ***pn, ***ps, ***pt, ***pb, ***pp;

	IMAX = bp->tnc[0];
	JMAX = bp->tnc[1];
	KMAX = bp->tnc[2];
	GX = bp->mprops.gravity_x;
	GY = bp->mprops.gravity_y;
	GZ = bp->mprops.gravity_z;
	CCCONST = bp->mprops.CCconst;
	TEMP_REF = bp->mprops.ref_T;
	BETA = bp->mprops.beta_T;
								

	
	pe = realmemalloc(0, IMAX+1, 0, JMAX+1, 0, KMAX+1);
	pw = realmemalloc(0, IMAX+1, 0, JMAX+1, 0, KMAX+1);
	pn = realmemalloc(0, IMAX+1, 0, JMAX+1, 0, KMAX+1);
	ps = realmemalloc(0, IMAX+1, 0, JMAX+1, 0, KMAX+1);
	pt = realmemalloc(0, IMAX+1, 0, JMAX+1, 0, KMAX+1);
	pb = realmemalloc(0, IMAX+1, 0, JMAX+1, 0, KMAX+1);
	pp = realmemalloc(0, IMAX+1, 0, JMAX+1, 0, KMAX+1);

	
	ca_cell_u = bp->ca_cell_u;
	ca_cell_v = bp->ca_cell_v;
	ca_cell_w = bp->ca_cell_w;
	ca_cell_p = bp->ca_cell_p;
	cflag = bp->cflag;

	conv_x_old = bp->conv_x_old;
	conv_y_old = bp->conv_y_old;
	conv_z_old = bp->conv_z_old;

	ca_cell_t = bp->ca_cell_t;
	ca_cell_ftry = bp->ca_cell_ftry;
		
	cell_f = bp->cell_f;
	cell_g = bp->cell_g;
	cell_h = bp->cell_h;

	/* constant values */

	sizex = bp->size_c[0];
	sizey = bp->size_c[1];
	sizez = bp->size_c[2];
	delttime = bp->delt;
	m_density = bp->mprops.rho;
	m_viscosity = bp->mprops.viscosity;

	carcoz_x = carcoz_y = carcoz_z = 0.0;
	tempftry = 0.0;

	dy_visc = m_viscosity/m_density;

	rev_dx2 = - delttime*dy_visc/sizex/sizex/2;
	rev_dy2 = - delttime*dy_visc/sizey/sizey/2;
	rev_dz2 = - delttime*dy_visc/sizez/sizez/2;
	rev_dxyz = 1 - 2.0 * (rev_dx2 + rev_dy2 + rev_dz2);
	


/*-----  ---allocation --- temporary use ---- */


	urhs = realmemalloc(0, IMAX+1, 0, JMAX+1, 0, KMAX+1);
	vrhs = realmemalloc(0, IMAX+1, 0, JMAX+1, 0, KMAX+1);
	wrhs = realmemalloc(0, IMAX+1, 0, JMAX+1, 0, KMAX+1);


/*--------------- initialize -----------------------*/

	for (i=0; i<=IMAX+1; i++){
		for (j=0; j<=JMAX+1; j++){
			for (k=0; k<=KMAX+1; k++){

				urhs[i][j][k] = 0.0;
				vrhs[i][j][k] = 0.0;
				wrhs[i][j][k] = 0.0;
				pe[i][j][k] = rev_dx2;
				pw[i][j][k] = rev_dx2;
				pn[i][j][k] = rev_dy2;
				ps[i][j][k] = rev_dy2;
				pt[i][j][k] = rev_dz2;
				pb[i][j][k] = rev_dz2;
				pp[i][j][k] = rev_dxyz;
			}
		}
	}


/*--------------------------------------------------------------------------*/

/*-------------  F rhs-------------*/

	for (i=1; i<=IMAX-1; i++){
		for (j=1; j<=JMAX; j++){
			for (k=1; k<=KMAX; k++){
			  
				if (cflag[i][j][k] == FFCELL && cflag[i+1][j][k] == FFCELL ){ //
				laplu = (ca_cell_u[i+1][j][k] - 2.0 * ca_cell_u[i][j][k] + ca_cell_u[i-1][j][k])/sizex/sizex +	(ca_cell_u[i][j+1][k] - 2.0 * ca_cell_u[i][j][k] + ca_cell_u[i][j-1][k])/sizey/sizey +(ca_cell_u[i][j][k+1] - 2.0 * ca_cell_u[i][j][k] + ca_cell_u[i][j][k-1])/sizez/sizez;

				du2dx = (((ca_cell_u[i][j][k] + ca_cell_u[i+1][j][k])*(ca_cell_u[i][j][k] + ca_cell_u[i+1][j][k]) -  (ca_cell_u[i-1][j][k] + ca_cell_u[i][j][k])*(ca_cell_u[i-1][j][k] + ca_cell_u[i][j][k])) +	GAMMA*(fabs((ca_cell_u[i][j][k] + ca_cell_u[i+1][j][k])) * (ca_cell_u[i][j][k] - ca_cell_u[i+1][j][k]) -fabs((ca_cell_u[i-1][j][k] + ca_cell_u[i][j][k])) * (ca_cell_u[i-1][j][k] - ca_cell_u[i][j][k])))/sizex/4;
				
				duvdy = (((ca_cell_v[i][j][k] + ca_cell_v[i+1][j][k])*(ca_cell_u[i][j][k] + ca_cell_u[i][j+1][k]) - (ca_cell_v[i][j-1][k] + ca_cell_v[i+1][j-1][k])*(ca_cell_u[i][j][k] + ca_cell_u[i][j-1][k])) +GAMMA*(fabs((ca_cell_v[i][j][k] + ca_cell_v[i+1][j][k])) * (ca_cell_u[i][j][k] - ca_cell_u[i][j+1][k]) -fabs((ca_cell_v[i][j-1][k] + ca_cell_v[i+1][j-1][k])) * (ca_cell_u[i][j-1][k] - ca_cell_u[i][j][k])))/sizey/4;

				duwdz = (((ca_cell_w[i][j][k] + ca_cell_w[i+1][j][k])*(ca_cell_u[i][j][k] + ca_cell_u[i][j][k+1]) - (ca_cell_w[i][j][k-1] + ca_cell_w[i+1][j][k-1])*(ca_cell_u[i][j][k] + ca_cell_u[i][j][k-1])) +GAMMA*(fabs((ca_cell_w[i][j][k] + ca_cell_w[i+1][j][k])) * (ca_cell_u[i][j][k] - ca_cell_u[i][j][k+1]) -fabs((ca_cell_w[i][j][k-1] + ca_cell_w[i+1][j][k-1])) * (ca_cell_u[i][j][k-1] - ca_cell_u[i][j][k])))/sizez/4;
				
				
				diff_term_x = laplu;
				conv_term_x = du2dx+duvdy+duwdz;
				source_term_x = 0.0;
				if(ca_cell_ftry[i][j][k] > 0) source_term_x = (1-BETA*((ca_cell_t[i][j][k]+ca_cell_t[i+1][j][k])/2-TEMP_REF))*GX;  //Buoyancy force

	//			source_term_x = (1-BETA*((ca_cell_t[i][j][k]+ca_cell_t[i+1][j][k])/2-TEMP_REF))*GX;

				tempftry = (ca_cell_ftry[i][j][k]+ca_cell_ftry[i+1][j][k])/2;
	//			tempftry = ca_cell_ftry[i][j][k];
				carcoz_x = CCCONST * (1- tempftry) * (1- tempftry) / (tempftry*tempftry*tempftry+EPS)/m_density ;

				delpx = 0.0;
//				delpx = (ca_cell_p[i+1][j][k]-ca_cell_p[i][j][k])/sizex;

				urhs[i][j][k] = ca_cell_u[i][j][k] +  delttime * (0.5 * dy_visc * diff_term_x - (1.5*conv_term_x-0.5*conv_x_old[i][j][k]) -delpx + source_term_x);
				
				urhs[i][j][k] =  urhs[i][j][k] * tempftry ;
				conv_x_old[i][j][k] = conv_term_x ; 

			  }
			  else {
				urhs[i][j][k] = ca_cell_u[i][j][k]* (ca_cell_ftry[i][j][k]+ca_cell_ftry[i+1][j][k])/2 ;

			  }

			} /* end of k loop*/
		} /* end of j loop*/
	} /* end of i loop*/


	iteru = PPE_ICCG(bp, pe, pw, pn, ps, pt, pb, pp, urhs, cell_f);


/*-------------  G rhs-------------*/

	for (i=1; i<=IMAX; i++){
		for (j=1; j<=JMAX-1; j++){
			for (k=1; k<=KMAX; k++){
			  
				if (cflag[i][j][k] == FFCELL && cflag[i][j+1][k] == FFCELL){ // 
/*
				dvl = (ca_cell_v[i][j][k]-ca_cell_v[i-1][j][k])/sizex;
				dvr = (ca_cell_v[i+1][j][k]-ca_cell_v[i][j][k])/sizex;
				vuy = (ca_cell_u[i][j][k]+ca_cell_u[i-1][j][k]+ca_cell_u[i-1][j+1][k]+ca_cell_u[i][j+1][k])/4;
				sgu = (vuy >=0 ? 1.0 : -1.0);
				dvdx = (dvl+dvr+GAMMA*sgu*(dvl-dvr))/2;

				dvf = (ca_cell_v[i][j+1][k]-ca_cell_v[i][j][k])/sizey;
				dvb = (ca_cell_v[i][j][k]-ca_cell_v[i][j-1][k])/sizey;
				sgv = (ca_cell_v[i][j][k]>=0 ? 1.0 : -1.0);
				dvdy = (dvf+dvb+GAMMA*sgv*(dvb-dvf))/2;

				dvu = (ca_cell_v[i][j][k+1]-ca_cell_v[i][j][k])/sizez;
				dvd = (ca_cell_v[i][j][k]-ca_cell_v[i][j][k-1])/sizez;
				vwy = (ca_cell_w[i][j][k-1]+ca_cell_w[i][j+1][k-1]+ca_cell_w[i][j][k]+ca_cell_w[i][j+1][k])/4;
				sgw = (vwy >=0 ? 1.0 :-1.0);
				dvdz = (dvu+dvd+GAMMA*sgw*(dvd-dvu))/2;
*/
				laplv = (ca_cell_v[i+1][j][k] - 2.0 * ca_cell_v[i][j][k] + ca_cell_v[i-1][j][k])/sizex/sizex + (ca_cell_v[i][j+1][k] - 2.0 * ca_cell_v[i][j][k] + ca_cell_v[i][j-1][k])/sizey/sizey +(ca_cell_v[i][j][k+1] - 2.0 * ca_cell_v[i][j][k] + ca_cell_v[i][j][k-1])/sizez/sizez;

				duvdx = (((ca_cell_u[i][j][k] + ca_cell_u[i][j+1][k])*(ca_cell_v[i][j][k] + ca_cell_v[i+1][j][k]) - (ca_cell_u[i-1][j][k] + ca_cell_u[i-1][j+1][k])*(ca_cell_v[i-1][j][k] + ca_cell_v[i][j][k])) +GAMMA*(fabs((ca_cell_u[i][j][k] + ca_cell_u[i][j+1][k])) * (ca_cell_v[i][j][k] - ca_cell_v[i+1][j][k]) -fabs((ca_cell_u[i-1][j][k] + ca_cell_u[i-1][j+1][k])) * (ca_cell_v[i-1][j][k] - ca_cell_v[i][j][k])))/sizex/4;
				
				dv2dy = (((ca_cell_v[i][j][k] + ca_cell_v[i][j+1][k])*(ca_cell_v[i][j][k] + ca_cell_v[i][j+1][k]) - (ca_cell_v[i][j-1][k] + ca_cell_v[i][j][k])*(ca_cell_v[i][j][k] + ca_cell_v[i][j-1][k])) +GAMMA*(fabs((ca_cell_v[i][j][k] + ca_cell_v[i][j+1][k])) * (ca_cell_v[i][j][k] - ca_cell_v[i][j+1][k]) -fabs((ca_cell_v[i][j-1][k] + ca_cell_v[i][j][k])) * (ca_cell_v[i][j-1][k] - ca_cell_v[i][j][k])))/sizey/4;

				dvwdz = (((ca_cell_w[i][j][k] + ca_cell_w[i][j+1][k])*(ca_cell_v[i][j][k] + ca_cell_v[i][j][k+1]) - (ca_cell_w[i][j][k-1] + ca_cell_w[i][j+1][k-1])*(ca_cell_v[i][j][k] + ca_cell_v[i][j][k-1]))+ GAMMA*(fabs((ca_cell_w[i][j][k] + ca_cell_w[i][j+1][k])) * (ca_cell_v[i][j][k] - ca_cell_v[i][j][k+1]) -fabs((ca_cell_w[i][j][k-1] + ca_cell_w[i][j+1][k-1])) * (ca_cell_v[i][j][k-1] - ca_cell_v[i][j][k])))/sizez/4;
				
/*				diff_term_y = ca_cell_fl[i][j][k]*laplv+ca_cell_v[i][j][k]*laplf[i][j][k]+2*(dfdx[i][j][k]*dvdx+dfdy[i][j][k]*dvdy+dfdz[i][j][k]*dvdz);
				conv_term_y = ca_cell_fl[i][j][k]*(duvdx+dv2dy+dvwdz) + ca_cell_u[i][j][k]*ca_cell_v[i][j][k]*dfdx[i][j][k] + 
				            	ca_cell_v[i][j][k]*ca_cell_v[i][j][k]*dfdy[i][j][k] + ca_cell_v[i][j][k]*ca_cell_w[i][j][k]*dfdz[i][j][k];
*/				
				diff_term_y = laplv;
				conv_term_y = duvdx+dv2dy+dvwdz;
				source_term_y = 0.0;
				if(ca_cell_ftry[i][j][k] == 1) source_term_y = (1-BETA*((ca_cell_t[i][j][k]+ca_cell_t[i][j+1][k])/2-TEMP_REF))*GY;   //Buoyancy force
			
//				source_term_y = (1-BETA*((ca_cell_t[i][j][k]+ca_cell_t[i][j+1][k])/2-TEMP_REF))*GY;

		    	tempftry = (ca_cell_ftry[i][j][k]+ca_cell_ftry[i][j+1][k])/2;
//				tempftry = ca_cell_ftry[i][j][k];
				carcoz_y = CCCONST * (1- tempftry) * (1- tempftry) / (tempftry*tempftry*tempftry+EPS)/m_density ;
				delpy = 0.0;
//				delpy = (ca_cell_p[i][j+1][k]-ca_cell_p[i][j][k])/sizey;
				
//				vrhs[i][j][k] = ca_cell_v[i][j][k] + delttime * ( -conv_term_y -delpy + source_term_y);

				vrhs[i][j][k] = ca_cell_v[i][j][k] + delttime * (0.5 * dy_visc * diff_term_y -(1.5 * conv_term_y- 0.5 * conv_y_old[i][j][k]) -delpy + source_term_y);
			 vrhs[i][j][k] =  vrhs[i][j][k] * tempftry;	
				conv_y_old[i][j][k] = conv_term_y ;
			  }
			  else{
				vrhs[i][j][k] = ca_cell_v[i][j][k] * (ca_cell_ftry[i][j][k]+ca_cell_ftry[i][j+1][k])/2;

			  }
				
				
			} /* end of k loop*/
		} /* end of j loop*/
	} /* end of i loop*/

	
	iterv = PPE_ICCG(bp, pe, pw, pn, ps, pt, pb, pp, vrhs, cell_g);

/*-------------  H rhs-------------*/

	for (i=1; i<=IMAX; i++){
		for (j=1; j<=JMAX; j++){
			for (k=1; k<=KMAX-1; k++){
				if (cflag[i][j][k] == FFCELL && cflag[i][j][k+1] == FFCELL){ // 

/*				dwl = (ca_cell_w[i][j][k]-ca_cell_w[i-1][j][k])/sizex;
				dwr = (ca_cell_w[i+1][j][k]-ca_cell_w[i][j][k])/sizex;
				wuz = (ca_cell_u[i][j][k]+ca_cell_u[i-1][j][k]+ca_cell_u[i-1][j][k+1]+ca_cell_u[i][j][k+1])/4;
				sgu = (wuz >=0 ? 1.0 : -1.0);
				dwdx = (dwl+dwr+GAMMA*sgu*(dwl-dwr))/2;

				dwf = (ca_cell_w[i][j+1][k]-ca_cell_w[i][j][k])/sizey;
				dwb = (ca_cell_w[i][j][k]-ca_cell_w[i][j-1][k])/sizey;
				wvz = (ca_cell_v[i][j][k]+ca_cell_v[i][j-1][k]+ca_cell_v[i][j-1][k+1]+ca_cell_v[i][j-1][k+1])/4;
				sgv = (wvz>=0 ? 1.0 : -1.0);
				dwdy = (dwf+dwb+GAMMA*sgv*(dwb-dwf))/2;

				dwu = (ca_cell_w[i][j][k+1]-ca_cell_w[i][j][k])/sizez;
				dwd = (ca_cell_w[i][j][k]-ca_cell_w[i][j][k-1])/sizez;
				sgw = (ca_cell_w[i][j][k] >= 0 ? 1.0 :-1.0);
				dwdz = (dwu+dwd+GAMMA*sgw*(dwd-dwu))/2;
*/
				laplw = (ca_cell_w[i+1][j][k] - 2.0 * ca_cell_w[i][j][k] + ca_cell_w[i-1][j][k])/sizex/sizex + (ca_cell_w[i][j+1][k] - 2.0 * ca_cell_w[i][j][k] + ca_cell_w[i][j-1][k])/sizey/sizey +(ca_cell_w[i][j][k+1] - 2.0 * ca_cell_w[i][j][k] + ca_cell_w[i][j][k-1])/sizez/sizez;

				duwdx = (((ca_cell_u[i][j][k] + ca_cell_u[i][j][k+1])*(ca_cell_w[i][j][k] + ca_cell_w[i+1][j][k]) - (ca_cell_u[i-1][j][k] + ca_cell_u[i-1][j][k+1])*(ca_cell_w[i-1][j][k] + ca_cell_w[i][j][k])) +GAMMA*(fabs((ca_cell_u[i][j][k] + ca_cell_u[i][j][k+1])) * (ca_cell_w[i][j][k] - ca_cell_w[i+1][j][k]) -fabs((ca_cell_u[i-1][j][k] + ca_cell_u[i-1][j][k+1])) * (ca_cell_w[i-1][j][k] - ca_cell_w[i][j][k])))/sizex/4;
				
				dvwdy = (((ca_cell_v[i][j][k] + ca_cell_v[i][j][k+1])*(ca_cell_w[i][j][k] + ca_cell_w[i][j+1][k]) - (ca_cell_v[i][j-1][k] + ca_cell_v[i][j-1][k+1])*(ca_cell_w[i][j][k] + ca_cell_w[i][j-1][k])) +GAMMA*(fabs((ca_cell_v[i][j][k] + ca_cell_v[i][j][k+1])) * (ca_cell_w[i][j][k] - ca_cell_w[i][j+1][k]) -fabs((ca_cell_v[i][j-1][k] + ca_cell_v[i][j-1][k+1])) * (ca_cell_w[i][j-1][k] - ca_cell_w[i][j][k])))/sizey/4;

				dw2dz = (((ca_cell_w[i][j][k] + ca_cell_w[i][j][k+1])*(ca_cell_w[i][j][k] + ca_cell_w[i][j][k+1]) - (ca_cell_w[i][j][k] + ca_cell_w[i][j][k-1])*(ca_cell_w[i][j][k] + ca_cell_w[i][j][k-1])) +	GAMMA*(fabs((ca_cell_w[i][j][k] + ca_cell_w[i][j][k+1])) * (ca_cell_w[i][j][k] - ca_cell_w[i][j][k+1]) -fabs((ca_cell_w[i][j][k] + ca_cell_w[i][j][k-1])) * (ca_cell_w[i][j][k-1] - ca_cell_w[i][j][k])))/sizez/4;
				
/*				diff_term_z = ca_cell_fl[i][j][k]*laplw+ca_cell_w[i][j][k]*laplf[i][j][k]+2*(dfdx[i][j][k]*dwdx+dfdy[i][j][k]*dwdy+dfdz[i][j][k]*dwdz);
				conv_term_z = ca_cell_fl[i][j][k]*(duwdx+dvwdy+dw2dz) + ca_cell_u[i][j][k]*ca_cell_w[i][j][k]*dfdx[i][j][k] + 
				            	ca_cell_v[i][j][k]*ca_cell_w[i][j][k]*dfdy[i][j][k] + ca_cell_w[i][j][k]*ca_cell_w[i][j][k]*dfdz[i][j][k];
								
*/				
				diff_term_z = laplw;
				conv_term_z = duwdx+dvwdy+dw2dz;
				source_term_z = 0.0;
				if(ca_cell_ftry[i][j][k] > 0) source_term_z = (1-BETA*((ca_cell_t[i][j][k]+ca_cell_t[i][j][k+1])/2-TEMP_REF))*GZ;    //Buoyancy force
	
//				source_term_z = (1-BETA*((ca_cell_t[i][j][k]+ca_cell_t[i][j][k+1])/2-TEMP_REF))*GZ;

				tempftry = (ca_cell_ftry[i][j][k]+ca_cell_ftry[i][j][k+1])/2;
//				tempftry = ca_cell_ftry[i][j][k];
				carcoz_z = CCCONST * (1- tempftry) * (1- tempftry) / (tempftry*tempftry*tempftry+EPS)/m_density ;
				delpz = 0.0;
//				delpz = (ca_cell_p[i][j][k+1]-ca_cell_p[i][j][k])/sizez;
				
/*				conv_term_z = ca_cell_fl[i][j][k]*(duwdx+dvwdy+dw2dz) + wuz*ca_cell_w[i][j][k]*dfdx[i][j][k] + 
					wvz*ca_cell_w[i][j][k]*dfdy[i][j][k] + ca_cell_w[i][j][k]*ca_cell_w[i][j][k]*dfdz[i][j][k];
*/				  // different way of trying u v and w

				wrhs[i][j][k] = ca_cell_w[i][j][k] + delttime * ( 0.5 * dy_visc * diff_term_z - (1.5*conv_term_z - 0.5*conv_z_old[i][j][k]) -delpz + source_term_z);
//				wrhs[i][j][k] = ca_cell_w[i][j][k] + delttime * (  - conv_term_z -delpz + source_term_z);
				wrhs[i][j][k] = wrhs[i][j][k] *tempftry;
				conv_z_old[i][j][k] = conv_term_z ;
			  }
			  else{
				wrhs[i][j][k] = ca_cell_w[i][j][k]* (ca_cell_ftry[i][j][k]+ca_cell_ftry[i][j][k+1])/2;

			  }
				
				
			} /* end of k loop*/
		} /* end of j loop*/
	} /* end of i loop*/

	/*-------------  Implicitly calculate F G H -------------*/
		
	iterw = PPE_ICCG(bp, pe, pw, pn, ps, pt, pb, pp, wrhs, cell_h);


/*
	for (j=1; j<=JMAX; j++){
		for (k=1; k<=KMAX; k++)	{
			
			urhs[0][j][k] = ca_cell_u[0][j][k];
			urhs[IMAX][j][k] = ca_cell_u[IMAX][j][k];
		}
	}
	for (i=1; i<=IMAX; i++){
		for (k=1; k<=KMAX; k++)	{
			
			vrhs[i][0][k] = ca_cell_v[i][0][k];
			vrhs[i][JMAX][k] = ca_cell_v[i][JMAX][k];
		}
	}
	for (i=1; i<=IMAX; i++){
		for (j=1; j<=JMAX; j++)	{
			
			wrhs[i][j][0] = ca_cell_w[i][j][0];
			wrhs[i][j][KMAX] = ca_cell_w[i][j][KMAX];
		}
	}

  */

	
/*-------------  F G H at the boundaries -------------*/

	for (j=1; j<=JMAX; j++){
		for (k=1; k<=KMAX; k++)	{
			
			cell_f[0][j][k] = (ca_cell_ftry[0][j][k] + ca_cell_ftry[1][j][k] ) * ca_cell_u[0][j][k] /2;
			cell_f[IMAX][j][k] = (ca_cell_ftry[IMAX][j][k]+ca_cell_ftry[IMAX+1][j][k]) * ca_cell_u[IMAX][j][k] /2;
		}
	}
	for (i=1; i<=IMAX; i++){
		for (k=1; k<=KMAX; k++)	{
			
			cell_g[i][0][k] = (ca_cell_ftry[i][0][k]+ca_cell_ftry[i][1][k]) * ca_cell_v[i][0][k] /2;
			cell_g[i][JMAX][k] = (ca_cell_ftry[i][JMAX][k]+ca_cell_ftry[i][JMAX+1][k]) * ca_cell_v[i][JMAX][k] /2;
		}
	}
	for (i=1; i<=IMAX; i++){
		for (j=1; j<=JMAX; j++)	{
			
			cell_h[i][j][0] = (ca_cell_ftry[i][j][0]+ca_cell_ftry[i][j][1]) * ca_cell_w[i][j][0] /2;
			cell_h[i][j][KMAX] = (ca_cell_ftry[i][j][KMAX]+ca_cell_ftry[i][j][KMAX+1]) * ca_cell_w[i][j][KMAX] /2;
		}
	}

 
/*
	for (j=1; j<=JMAX; j++){
		for (k=1; k<=KMAX; k++)	{
			
			cell_f[0][j][k] = 0.0;
			cell_f[IMAX][j][k] = 0.0;
		}
	}
	for (i=1; i<=IMAX; i++){
		for (k=1; k<=KMAX; k++)	{
			
			cell_g[i][0][k] = 0.0;
			cell_g[i][JMAX][k] = 0.0;
		}
	}
	for (i=1; i<=IMAX; i++){
		for (j=1; j<=JMAX; j++)	{
			
			cell_h[i][j][0] = 0.0;
			cell_h[i][j][KMAX] = 0.0;
		}
	}



	for (j=1; j<=JMAX; j++){
		for (k=1; k<=KMAX; k++)	{
		
			cell_f[0][j][k] = ca_cell_u[0][j][k];
			cell_f[IMAX][j][k] = ca_cell_u[IMAX][j][k];
		}
	}
	for (i=1; i<=IMAX; i++){
		for (k=1; k<=KMAX; k++)	{
			
			cell_g[i][0][k] = ca_cell_v[i][0][k];
			cell_g[i][JMAX][k] = ca_cell_v[i][JMAX][k];
		}
	}
	for (i=1; i<=IMAX; i++){
		for (j=1; j<=JMAX; j++)	{
			
			cell_h[i][j][0] = ca_cell_w[i][j][0];
			cell_h[i][j][KMAX] = ca_cell_w[i][j][KMAX];
		}
	}
*/
/*---------------------------------------------------*/

	freerealmem(pe, 0, IMAX+1, 0, JMAX+1, 0, KMAX+1);
	freerealmem(pw, 0, IMAX+1, 0, JMAX+1, 0, KMAX+1);
	freerealmem(pn, 0, IMAX+1, 0, JMAX+1, 0, KMAX+1);
	freerealmem(ps, 0, IMAX+1, 0, JMAX+1, 0, KMAX+1);
	freerealmem(pt, 0, IMAX+1, 0, JMAX+1, 0, KMAX+1);
	freerealmem(pb, 0, IMAX+1, 0, JMAX+1, 0, KMAX+1);
	freerealmem(pp, 0, IMAX+1, 0, JMAX+1, 0, KMAX+1);
	freerealmem(urhs, 0, IMAX+1, 0, JMAX+1, 0, KMAX+1);
	freerealmem(vrhs, 0, IMAX+1, 0, JMAX+1, 0, KMAX+1);
	freerealmem(wrhs, 0, IMAX+1, 0, JMAX+1, 0, KMAX+1);


}







