/*----------------------------------------------------------------------*/
/*             Fluid Flow Code   by LY   01/2008      
				initial the velocity field
*/
/*--------------------------------------------------------------------*/


#include "ff_mpflow.h"

void initvelocity(BB_struct *bp)
{
	int i,j,k;
	int ffnum;

	CA_FLOAT ***ca_cell_u, ***ca_cell_v, ***ca_cell_w, ***ca_cell_p;
	int ***cflag;

//	CA_FLOAT ***ca_cell_fl, ***ca_cell_flold;
	CA_FLOAT ***ca_cell_ftry;
	CA_FLOAT ***ca_cell_t, ***ppe_rhs, ***ca_cell_delp;
	CA_FLOAT ***cell_f, ***cell_g, ***cell_h;
	CA_FLOAT ***ca_cell_dfs;
	CA_FLOAT ***ca_cell_h;
	CA_FLOAT ***ca_cell_ce; 

        int IMAX, JMAX, KMAX;
	CA_FLOAT latent, cp;

	IMAX = bp->tnc[0];
	JMAX = bp->tnc[1];
	KMAX = bp->tnc[2];
	latent = bp->mprops.latentH;
	cp = bp->mprops.cp;

	ca_cell_u = bp->ca_cell_u;
	ca_cell_v = bp->ca_cell_v;
	ca_cell_w = bp->ca_cell_w;
	ca_cell_p = bp->ca_cell_p;
	ca_cell_ce = bp->ca_cell_ce;

//	ca_cell_fl = bp->ca_cell_fl;
//	ca_cell_flold = bp->ca_cell_flold;
	ca_cell_ftry = bp->ca_cell_ftry;

	ca_cell_t = bp->ca_cell_t;
	ca_cell_h = bp->ca_cell_h;
	cell_f = bp->cell_f;
	cell_g = bp->cell_g;
	cell_h = bp->cell_h;
	ppe_rhs = bp->ppe_rhs;
	ca_cell_delp = bp->ca_cell_delp;
	ca_cell_dfs = bp->ca_cell_dfs;

	cflag = bp->cflag;

	ffnum = 0;
	bp->H_L = bp->mprops.Tliq * cp + latent;
	bp->H_S = bp->mprops.Tsol * cp;
	
	for (i=0; i<=IMAX+1; i++){
	  for (j=0; j<=JMAX+1; j++){
	    for (k=0; k<=KMAX+1; k++)
	    {

              cflag[i][j][k] = FFCELL;

	      if (i==0 || i==IMAX+1) cflag[i][j][k] = BCCELL;
              if (j==0 || j==JMAX+1) cflag[i][j][k] = BCCELL;
              if (k==0 || k==KMAX+1) cflag[i][j][k] = BCCELL;
		  
	      ca_cell_u[i][j][k] =  0; //bp->initvelo[0];
	      ca_cell_v[i][j][k] =  0; //bp->initvelo[1];
	      ca_cell_w[i][j][k] =  0; //bp->initvelo[2];
	      
#ifdef LYUAN_LEFTIN
	        if (i==0)              cflag[i][j][k] = INLETCELL;
		if (i==IMAX+1)         cflag[i][j][k] = OUTLETCELL;

		if(bp->ctrl->fluidflow){
		  ca_cell_u[i][j][k] =  bp->initvelo[0];
		  ca_cell_v[i][j][k] =  bp->initvelo[1];
		  ca_cell_w[i][j][k] =  bp->initvelo[2];
		}
		
#endif		

#ifdef LYUAN_DOWNIN
		
//		if (j==0)              cflag[i][j][k] = INLETCELL;
  //              if (j==JMAX+1)         cflag[i][j][k] = OUTLETCELL;
		
		
		if(bp->ctrl->fluidflow){
		  ca_cell_u[i][j][k] = bp->initvelo[0];
		  ca_cell_v[i][j][k] = bp->initvelo[1];
		  ca_cell_w[i][j][k] = bp->initvelo[2];
		} 
		
#endif
								
		ca_cell_p[i][j][k] = 0.0;
		ca_cell_t[i][j][k] = bp->Tinit;    //defined in geo inputfile

		cell_f[i][j][k] = 0.0;
		cell_g[i][j][k] = 0.0;
		cell_h[i][j][k] = 0.0;
		ppe_rhs[i][j][k] = 0.0;
		ca_cell_delp[i][j][k] = 0.0;

//		ca_cell_fl[i][j][k] = INITFL;
//		ca_cell_flold[i][j][k] = INITFL;   
		ca_cell_ftry[i][j][k] = 1.0;
		ca_cell_dfs[i][j][k] = 0.0;
		ca_cell_ce[i][j][k] = bp->mprops.alloyprops[0].Cinit;   // initial concentration.. try..

		ca_cell_h[i][j][k] = cp*ca_cell_t[i][j][k] + ca_cell_ftry[i][j][k]*latent;
			
				
/*				
		if (i==0 || i==IMAX+1) cflag[i][j][k] = BCCELL;
		if (j==0 || j==JMAX+1) cflag[i][j][k] = BCCELL;
		if (k==0 || k==KMAX+1) cflag[i][j][k] = BCCELL;

//		if (j==0)              cflag[i][j][k] = INLETCELL;
//		if (j==JMAX+1)	       cflag[i][j][k] = OUTLETCELL;

		if (i==0)              cflag[i][j][k] = INLETCELL;
		if (i==IMAX+1)         cflag[i][j][k] = OUTLETCELL;
				
//		if (i==1 || i==2 || i==3) ca_cell_ftry[i][j][k]=1;
*/
		if (cflag[i][j][k] == FFCELL) ffnum++;
				
            } /* end of k loop*/
	  } /* end of j loop*/
	} /* end of i loop*/
	
	bp->totalffcnum = ffnum;

}

