/*--------------------------------------------------------------------------*/
/* Memory allocation for CA_FLOAT and int type                              */
/*                          Created by LY      11/2007                      */
/*--------------------------------------------------------------------------*/


#include "ff_mpflow.h"
#include "ff_memory.h"

/*----------------------------------------------------------------------------*/
/*
   allocates memory for a [nxl,nxh][nyl,nyh][nzl,nzh]-array of CA_FLOAT-type  
*/
/*----------------------------------------------------------------------------*/

CA_FLOAT ***realmemalloc(int nxl,int nxh,int nyl,int nyh,int nzl, int nzh)
{
  int i,j;
  CA_FLOAT ***m;
  if((m = (CA_FLOAT ***) malloc((unsigned) (nxh-nxl+1)*sizeof(CA_FLOAT **))) == NULL)
     {	
      printf("no memory\n");
      exit(0);
     }
  m -= nxl;
 
  for(i=nxl;i<=nxh;i++)
    {
     if((m[i] = (CA_FLOAT **) malloc((unsigned) (nyh-nyl+1)*sizeof(CA_FLOAT *)))==NULL)
       {	
        printf("no memory\n");
        exit(0);
       }
   m[i] -= nyl;
    }

  for (i=nxl; i<=nxh; i++){
	  for (j=nyl; j<=nyh; j++)
	  {
		  if((m[i][j] = (CA_FLOAT *) malloc((unsigned) (nzh-nzl+1)*sizeof(CA_FLOAT)))==NULL)
		  {	
			 printf("no memory\n");
			 exit(0);
		  }
		  
	  m[i][j] -= nzl;
	  }
  }

  
  return m;
} 

/*-------------------------------------------------------------------------*/
/* 
      frees the memory of an array allocated with realmemalloc                
*/
/*-------------------------------------------------------------------------*/
void freerealmem(CA_FLOAT ***m,int nxl,int nxh,int nyl,int nyh,int nzl, int nzh)
{
  int i,j;

  for (i=nxh;i>=nxl;i--) {
	  for (j=nyh; j>=nyl; j--)
	  {
		  free((char*)(m[i][j]+nzl));
	  }
  }
  for (i=nxh;i>=nxl;i--) {
	  free((char*)(m[i]+nyl));
  }
  
  free((char*)(m+nxl));
}

/*-------------------------------------------------------------------------*/
/* 
  allocates memory for a [nxl,nxh][nyl,nyh][nzl,nzh]-array of integer-type
*/
/*-------------------------------------------------------------------------*/
int ***intmemalloc(int nxl,int nxh,int nyl,int nyh,int nzl, int nzh)
{
  int i,j;
  int ***m;
  if((m = (int ***) malloc((unsigned) (nxh-nxl+1)*sizeof(int **))) == NULL)
     {	
      printf("no memory\n");
      exit(0);
     }
  m -= nxl;
 
  for(i=nxl;i<=nxh;i++)
    {
     if((m[i] = (int **) malloc((unsigned) (nyh-nyl+1)*sizeof(int *)))==NULL)
       {	
        printf("no memory\n");
        exit(0);
       }
   m[i] -= nyl;
    }

  for (i=nxl; i<=nxh; i++){
	  for (j=nyl; j<=nyh; j++)
	  {
		  if((m[i][j] = (int *) malloc((unsigned) (nzh-nzl+1)*sizeof(int)))==NULL)
		  {	
			 printf("no memory\n");
			 exit(0);
		  }
		  
	m[i][j] -= nzl;
	  }
  }

  return m;
} 

/*-------------------------------------------------------------------------*/
/* 
  frees the memory of an array allocated with intmemalloc                 
*/
/*-------------------------------------------------------------------------*/
void freeintmem(int ***m,int nxl,int nxh,int nyl,int nyh,int nzl, int nzh)
{
  int i,j;

  for (i=nxh;i>=nxl;i--) {
	  for (j=nyh; j>=nyl; j--)
	  {
		  free((char*)(m[i][j]+nzl));
	  }
  }
  for (i=nxh;i>=nxl;i--) {
	  free((char*)(m[i]+nyl));
  }
  
  free((char*)(m+nxl));
}

