/*----------------------------------------------------------------------*/
/*             Fluid Flow Code   by LY   02/2008      
						Solution of Pressure by solving PPE using ICCG
*/
/*----------------------------------------------------------------------*/

#include "ff_mpflow.h"



int ppe_iccgtest(BB_struct *bp){

	int i,j,k;
	int iter, ffnum;
	CA_FLOAT ***ca_cell_p, ***ppe_rhs, ***ca_cell_delp;
	int ***cflag;

	CA_FLOAT sizex,sizey,sizez;
	CA_FLOAT rev_dx2, rev_dy2, rev_dz2;
	CA_FLOAT rev_dxyz;
	int IMAX, JMAX, KMAX;

	IMAX = bp->tnc[0];
	JMAX = bp->tnc[1];
	KMAX = bp->tnc[2];
	
	CA_FLOAT ***pe, ***pw, ***pn, ***ps, ***pt, ***pb, ***pp;

	pe = realmemalloc(0, IMAX+1, 0, JMAX+1, 0, KMAX+1);
	pw = realmemalloc(0, IMAX+1, 0, JMAX+1, 0, KMAX+1);
	pn = realmemalloc(0, IMAX+1, 0, JMAX+1, 0, KMAX+1);
	ps = realmemalloc(0, IMAX+1, 0, JMAX+1, 0, KMAX+1);
	pt = realmemalloc(0, IMAX+1, 0, JMAX+1, 0, KMAX+1);
	pb = realmemalloc(0, IMAX+1, 0, JMAX+1, 0, KMAX+1);
	pp = realmemalloc(0, IMAX+1, 0, JMAX+1, 0, KMAX+1);

	ca_cell_p = bp->ca_cell_p;
	ca_cell_delp = bp->ca_cell_delp;
	ppe_rhs = bp->ppe_rhs;

	cflag = bp->cflag;
	ffnum = bp->totalffcnum;
        sizex = bp->size_c[0];
	sizey = bp->size_c[1];
	sizez = bp->size_c[2];

	rev_dx2 = -1.0/sizex/sizex;
	rev_dy2 = -1.0/sizey/sizey;
	rev_dz2 = -1.0/sizez/sizez;
	rev_dxyz = -2.0 * (rev_dx2 + rev_dy2 + rev_dz2);

	for (i=0; i<=IMAX+1; i++){
	  for (j=0; j<=JMAX+1; j++){
	    for (k=0; k<=KMAX+1; k++){
		
	      pe[i][j][k] = rev_dx2;
	      pw[i][j][k] = rev_dx2;
	      pn[i][j][k] = rev_dy2;
	      ps[i][j][k] = rev_dy2;
	      pt[i][j][k] = rev_dz2;
	      pb[i][j][k] = rev_dz2;
	      pp[i][j][k] = rev_dxyz;
	    }
	  }
	}
/*
	for (i=1; i<=IMAX; i++){
	  for (k=1; k<=KMAX; k++){
	    ca_cell_delp[i][0][k] = ca_cell_delp[i][1][k];
	    ca_cell_delp[i][JMAX+1][k] = ca_cell_delp[i][JMAX][k];
	  }
	}
	
	for (i=1; i<=IMAX; i++){
	  for (j=1; j<=JMAX; j++){
	    ca_cell_delp[i][j][0] = ca_cell_delp[i][j][1];
	    ca_cell_delp[i][j][KMAX+1] = ca_cell_delp[i][j][KMAX];
	  }
	}
	
	for (j=1;j<=JMAX; j++){
	  for (k=1; k<=KMAX; k++){
	    ca_cell_delp[0][j][k] = ca_cell_delp[1][j][k];
	    ca_cell_delp[IMAX+1][j][k] = ca_cell_delp[IMAX][j][k];
	  }
	}

*/
	iter = PPE_ICCG(bp, pe, pw, pn, ps, pt, pb, pp, ppe_rhs, ca_cell_delp);


	for (i=1; i<=IMAX; i++){
	  for (k=1; k<=KMAX; k++){
	    ca_cell_delp[i][0][k] = ca_cell_delp[i][1][k] ;
	    ca_cell_delp[i][JMAX+1][k] = ca_cell_delp[i][JMAX][k] ;
    
    	/*--------Zero pressure bc------------- */
//            ca_cell_delp[i][0][k] = 0.0;
//            ca_cell_delp[i][JMAX+1][k] = 0.0;
	  }
	}
	
	for (i=1; i<=IMAX; i++){
	  for (j=1; j<=JMAX; j++){
	    ca_cell_delp[i][j][0] = ca_cell_delp[i][j][1];
	    ca_cell_delp[i][j][KMAX+1] = ca_cell_delp[i][j][KMAX];
	  }
	}
	
	for (j=1;j<=JMAX; j++){
	  for (k=1; k<=KMAX; k++){
	    ca_cell_delp[0][j][k] = ca_cell_delp[1][j][k];
	    ca_cell_delp[IMAX+1][j][k] = ca_cell_delp[IMAX][j][k];
	  }
	}
	
	
	for (i=0; i<=IMAX+1; i++){
	  for (j=0; j<=JMAX+1; j++){
	    for (k=0; k<=KMAX+1; k++){
//	      ca_cell_p[i][j][k] = ca_cell_p[i][j][k] + ca_cell_delp[i][j][k];
	      ca_cell_p[i][j][k] = ca_cell_delp[i][j][k];
	    }
	  }
	}



	freerealmem(pe, 0, IMAX+1, 0, JMAX+1, 0, KMAX+1);
	freerealmem(pw, 0, IMAX+1, 0, JMAX+1, 0, KMAX+1);
	freerealmem(pn, 0, IMAX+1, 0, JMAX+1, 0, KMAX+1);
	freerealmem(ps, 0, IMAX+1, 0, JMAX+1, 0, KMAX+1);
	freerealmem(pt, 0, IMAX+1, 0, JMAX+1, 0, KMAX+1);
	freerealmem(pb, 0, IMAX+1, 0, JMAX+1, 0, KMAX+1);
	freerealmem(pp, 0, IMAX+1, 0, JMAX+1, 0, KMAX+1);

	return iter;

}

