/*RCS Id:$Id: fg_read.c 887 2006-03-01 18:21:01Z rcatwood $*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <signal.h>
#include "safeopen.h"
#include "machine.h"
#include "constants.h"
#include "fidap.h"
#include "read_list/read_fg_list.h"
#include "read_list/readwrite_fg.h"
#include "read_list/freecsv.h"

/***********************************************************************/
/* subroutine to input fg temperature files.                           */
/*   Inputs: file name where the list is stored,                       */
/*            pointer to the FGrid location,                           */
/*           flag to indicate first/last/transient step                */
/*                                                                     */
/*   Output:  Non zero if the list is finished                         */
/*                                                                     */
/*   Result:  First time - calles read_listfile to store the list of time and filename */
/*                         Reads the first set of data                 */
/*           Other times - Read the next set fo data                   */
/*           Last time - free the locally allocated arrays             */
/**            \todo  decide how to handle non-transient (only one file) data  -- coupled */
/***********************************************************************/
int fg_read (const char *listfilename, FGrid_str * fg, int fg_flag)
{
  static FGrid_list_str fgl;
  static int n_names = 0, this_idx = 0;

  CA_FLOAT thistime = 0, nexttime = 0;

  int i;
  char thisname[255];

  fgl.nheaders_list = 1;

  switch (fg_flag) {
  case FG_FIRST_READ:
    n_names = read_listfile (listfilename, &fgl);
    /* fall through */
  case FG_TRANS_READ:
    sprintf (thisname, "%s.fgb", fgl.rows[this_idx]->filename);
    thistime = fgl.rows[this_idx]->time;

    if (n_names > this_idx + 1) {
      nexttime = fgl.rows[this_idx + 1]->time;
    } else {
      fprintf (stderr, "ERROR:read_fg_list: Ran out of file names! \n");
      fprintf (stderr, "Trying to finish ... \n");
      raise (SIGUSR1);
      exit (0);
    }
    break;

  case FG_CLEANUP:
    free_fg_list (&fgl);
    return (0);
    break;

  default:
    break;
  }
  read_fg_bin (thisname, fg, fg_flag);
  fg->tstart = thistime;
  fg->tnext = nexttime;
  this_idx++;
  if (this_idx >= n_names)
    return (1);
  return (0);

}

/*
RCS Log:$Log$
RCS Log:Revision 11.1  2006/03/01 18:20:39  rcatwood
RCS Log:Merging polycomponent and gas with meltback
RCS Log:
RCS Log:Revision 10.5  2005/12/06 13:09:54  rcatwood
RCS Log:Changed todo lists to Doxygen syntax
RCS Log:
RCS Log:Revision 10.4  2005/12/06 12:58:01  rcatwood
RCS Log:Improved the to-do list information
RCS Log:
RCS Log:Revision 10.3  2005/12/01 14:38:01  rcatwood
RCS Log:Merged xly_05 changes into the main trunk
RCS Log:Primarily involving melt-back
RCS Log:
RCS Log:Revision 10.1.2.3  2005/12/01 13:09:37  rcatwood
RCS Log:Fixed some implicit function declarations
RCS Log:
RCS Log:Revision 10.1.2.2  2005/11/23 18:18:53  rcatwood
RCS Log:Result of merging mould_source and xly meltback+curvature 2d versions
RCS Log:
RCS Log:Revision 10.1  2005/11/03 11:56:46  rcatwood
RCS Log:New version number -- using mould_src as base
RCS Log:
RCS Log:Revision 1.1.4.2  2005/11/02 11:55:05  rcatwood
RCS Log:Fixing up the revision nubmer after loss of repository
RCS Log:
RCS Log:Revision 9.2  2003/10/16 13:48:06  rcatwood
RCS Log:added rcs id routines
RCS Log:
RCS Log:Revision 9.1  2003/08/14 14:38:35  rcatwood
RCS Log:Working merge with decentered/porosity/procast, also including
RCS Log:Ali Chirazi's multicomponent (not tested in this version)
RCS Log:
RCS Log:Revision 1.1.2.5  2003/02/27 23:04:38  rcatwood
RCS Log:Removed use of old temperature routines , all temperatures shoudl
RCS Log:be determined by checking the array c_temp in teh subblock, if the
RCS Log:subblock is open
RCS Log:
RCS Log:Revision 1.1.2.4  2003/01/28 18:11:47  rcatwood
RCS Log:ALL_SIG flag to disable signal blocking
RCS Log:Fixed double free of node structure
RCS Log:
RCS Log:Revision 1.1.2.3  2003/01/23 17:47:27  rcatwood
RCS Log:finite grid applied to decentered square,
RCS Log:works, but not checked for correct results.
RCS Log:
RCS Log:Revision 1.1.2.2  2003/01/22 16:53:43  rcatwood
RCS Log:Almost working read_fg version
RCS Log:
RCS Log:Revision 1.1.2.1  2003/01/17 16:09:29  rcatwood
RCS Log:Before changing all CA_FLOAT to CA_CA_FLOAT
RCS Log:
RCS Log:Revision 8.2.2.1  2003/01/16 16:07:58  rcatwood
RCS Log:*** empty log message ***
RCS Log:
RCS Log:Revision 8.2  2002/12/13 14:04:43  rcatwood
RCS Log:Compile without errors
RCS Log:
RCS Log:Revision 8.1  2002/12/13 13:42:25  rcatwood
RCS Log:Read and organize the data files for inputting
RCS Log:finite-element data
RCS Log:
RCS Log:Revision 2.1  2002/10/17 16:56:01  rcatwood
RCS Log:*** empty log message ***
RCS Log:
RCS Log:Revision 1.2  2002/09/06 13:06:42  rcatwood
RCS Log:improved for compatiblity with CA code
RCS Log:
RCS Log:Revision 1.1  2002/09/06 12:52:36  rcatwood
RCS Log:Cured all memory allocation problems .. I hope.
RCS Log:
RCS Log:Revision 1.2  2002/09/05 18:05:44  rcatwood
RCS Log:Included convert, read and write fg binary, and tested. It seems to work.
RCS Log:
RCS Log:Revision 1.1  2002/09/04 14:58:33  rcatwood
RCS Log:First working version -- reads and writes CSV files (no conversion)
RCS Log:
*/
/***************************************************/
/* rcs id routine to include rcs id in the program */
/* generated by make_rcs_sub.sh script             */
/***************************************************/
char const *fg_read_c ()
{
  static char const rcsid[] = "$Id: fg_read.c 887 2006-03-01 18:21:01Z rcatwood $";

  return (rcsid);
}
