/****************************************************************/
/*   Copyright (c) 1998 Dept. of Materials, ICSTM               */
/*   All Rights Reserved                                        */
/*   THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF ICSTM       */
/*   The copyright notice above does not evidence any           */
/*   actual or intended publication of such source code,        */
/*   and is an unpublished work by Dept. of Materials, ICSTM.   */
/*   This material contains CONFIDENTIAL INFORMATION that       */
/*   is the property of Imperial College. Any use,              */
/*   duplication or disclosure not specifically authorized      */
/*   by Imperial College is strictly prohibited.                */
/****************************************************************/
/* This code is part of the umats routines developed at in the  */
/* Materials Processing Group, Dept. of Materials, ICSTM.       */
/*      email p.d.lee or r.atwood @ic.ac.uk for details         */
/****************************************************************/

/****************************************************************/
/* grain.h                                                      */
/* Header file defining grain structure.                        */
/****************************************************************/
/* Written by Peter D. Lee & Robert C. Atwood, Imperial College */
/* Wed Oct. 28 1998                                             */
/****************************************************************/
/*RCS Id:$Id: grain.h 887 2006-03-01 18:21:01Z rcatwood $*/

#ifndef GRAIN_H
#define GRAIN_H

#define GRAINREV "grain.h $Revision: 887 $"  
/* define cpp variables for neighbourhood definition */
#define N_NEIGH 27
#define NEIGH_6  6
#define NEIGH_8  8
#define NEIGH_10  10
#define NEIGH_26  26


/****************************************************************/
/* Structure to define a single grain.                          */
/****************************************************************/
typedef struct grain {
        int num;                /* grain number                 */
        int state;              /* current state                */
        int sbnum;              /* number of sb it centres in   */
        int cell;               /* cell at centre               */
        int ncells;             /* # cells it occupies          */
        int ngrow;              /* # of growing cells */
        int blocks;		/* how many blocks for this grain*/
        CA_FLOAT NucTh; /* the threshold for the nucleation */
        CA_FLOAT TNuc;             /* cell temp at which grain nuc. */
        CA_FLOAT TunderNuc;        /* cell undercooling at which nuc*/
        CA_FLOAT CellConcNuc;      /* cell conc. at which nuc.     */
        int max[3];             /* highest x,y,z value cell    */
        int nuccell[3];
        int min[3];             /* lowest xyz value cell      */

                                /* stuff for dir. growth..      */
/* NOTE: mdir should be moved out with a limited # of dirs! */
        CA_FLOAT mdir[N_NEIGH];         /* Factor for directionnal growth*/
        CA_FLOAT dir_fact;         /* Factor for directional growth*/
        CA_FLOAT gro_fact;         /* Factor for directional growth*/
        CA_FLOAT ph;         /* Factor for hex growth*/
        CA_FLOAT pq;         /* Factor for quad growth*/
        CA_FLOAT po;        /* factor for oct growht          */
        CA_FLOAT dir_angle;        /* Crystal orientation          */

        /*orientation used in decentred octahedron*/ /*by Wei WANG 11-07-02*/
        CA_FLOAT ang[3];
        CA_FLOAT sang[3];       /*sin(ang[])*/
        CA_FLOAT cang[3];       /*cos(ang[])*/
        CA_FLOAT g[3][3];       /*rotation matrix*/

} Ind_grain;

#endif /* GRAIN_H */
/*
RCS Log:$Log$
RCS Log:Revision 11.1  2006/03/01 18:20:39  rcatwood
RCS Log:Merging polycomponent and gas with meltback
RCS Log:
RCS Log:Revision 10.2  2005/12/01 14:38:01  rcatwood
RCS Log:Merged xly_05 changes into the main trunk
RCS Log:Primarily involving melt-back
RCS Log:
RCS Log:Revision 10.1.2.2  2005/11/23 18:18:53  rcatwood
RCS Log:Result of merging mould_source and xly meltback+curvature 2d versions
RCS Log:
RCS Log:Revision 10.1  2005/11/03 11:56:46  rcatwood
RCS Log:New version number -- using mould_src as base
RCS Log:
RCS Log:Revision 8.1.12.2  2005/11/02 11:55:05  rcatwood
RCS Log:Fixing up the revision nubmer after loss of repository
RCS Log:
RCS Log:Revision 9.1  2003/08/14 14:38:35  rcatwood
RCS Log:Working merge with decentered/porosity/procast, also including
RCS Log:Ali Chirazi's multicomponent (not tested in this version)
RCS Log:
RCS Log:Revision 8.1.6.2  2003/08/14 14:17:57  rcatwood
RCS Log:Working ca_procast new version, on linux
RCS Log:Added surface nucleation
RCS Log:Added mould source term
RCS Log:Changed printout headers
RCS Log:Temperature output image
RCS Log:
RCS Log:Revision 8.1.6.1  2003/01/22 16:53:43  rcatwood
RCS Log:Almost working read_fg version
RCS Log:
RCS Log:Revision 8.1  2002/10/17 17:01:01  rcatwood
RCS Log:New version number! for decentered/porosity merge! Alpha Version!
RCS Log:
RCS Log:Revision 7.3  2002/10/17 16:52:37  rcatwood
RCS Log:Merge from branch: combined Robert (porosity) and Wei (decentered octahedron) versions
RCS Log:
RCS Log:Revision 7.2.10.2  2002/09/03 13:31:59  rcatwood
RCS Log:Merged with reorganized allocation routines, and adjusted nucleation to compartmentalize
RCS Log:the grain information assignment.
RCS Log:
RCS Log:Revision 7.2.10.1  2002/08/22 15:13:43  ww1
RCS Log:Merge of Wei Wang's decentered octahedron/square method
RCS Log:Revision 7.2.2.2  2002/05/29 14:24:50  rcatwood
RCS Log:Working up to subblock header & array data
RCS Log:
RCS Log:Revision 7.2.2.1  2002/05/29 11:11:53  rcatwood
RCS Log:Added revision string macro
RCS Log:for checking compatibliity
RCS Log:
RCS Log:Revision 7.2  2002/05/23 17:28:01  rcatwood
RCS Log:Used dbmalloc to eliminate all memory leaks!
RCS Log:Started close-sb routine to improve multiblock
RCS Log:
RCS Log:Revision 7.1  2000/12/06 21:10:40  rcatwood
RCS Log:fixed up heatfolw, tctrace
RCS Log:
RCS Log:Revision 7.0  2000/11/07 15:55:38  rcatwood
RCS Log:Multi Cell Pores added
RCS Log:
RCS Log:Revision 6.0  2000/09/25 18:03:37  rcatwood
RCS Log:After PORE_00 and NLM
RCS Log:
RCS Log:Revision 2.0  2000/08/02 10:21:56  rcatwood
RCS Log:Version used for pore paper runs
RCS Log:
RCS Log:Revision 1.1  2000/05/22 12:29:24  rcatwood
RCS Log:Fixed fs finish. Casolid to C from  W file. Global option
RCS Log:
RCS Log:Revision 5.2  2000/03/15 16:25:32  rcatwood
RCS Log:backup checkin
RCS Log:
RCS Log:Revision 5.1  2000/03/02 16:11:10  rcatwood
RCS Log:Merged xxu and rca versions
RCS Log:
RCS Log:Revision 5.0.2.1  2000/03/01 15:54:30  rcatwood
RCS Log:merged VAR and Multiblock updates. Not tested
RCS Log:
RCS Log:Revision 5.0.1.1  2000/02/22 19:04:27  rcatwood
RCS Log:Not yet tested
RCS Log:
RCS Log:Revision 4.3  1999/12/23 18:12:24  rcatwood
RCS Log:Version used for Mcwasp runs
RCS Log:
RCS Log:Revision 4.2  1999/12/23 18:09:21  rcatwood
RCS Log:Solute arrays migrated to structure.
RCS Log:
RCS Log:Revision 4.1  1999/12/16 13:33:44  rcatwood
RCS Log:Finalised improved use of RCS in all files.
RCS Log:
RCS Log:Revision 4.0.2.1  1999/12/16 12:37:36  rcatwood
RCS Log:Improving rcs id for all files, this may require several checkins to test.
RCS Log:
*/
