/****************************************************************/
/*   Copyright (c) 1998 Dept. of Materials, ICSTM               */
/*   All Rights Reserved                                        */
/*   THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF ICSTM       */
/*   The copyright notice above does not evidence any           */
/*   actual or intended publication of such source code,        */
/*   and is an unpublished work by Dept. of Materials, ICSTM.   */
/*   This material contains CONFIDENTIAL INFORMATION that       */
/*   is the property of Imperial College. Any use,              */
/*   duplication or disclosure not specifically authorized      */
/*   by Imperial College is strictly prohibited.                */
/****************************************************************/
/* This code is part of the umats routines developed at in the  */
/* Materials Processing Group, Dept. of Materials, ICSTM.       */
/*      email p.d.lee or r.atwood @ic.ac.uk for details         */
/****************************************************************/

/****************************************************************/
/* machine.h                                                    */
/* Header file defining the cpp operatives                      */
/* that are machine and compile flag specific.                  */
/****************************************************************/
/****************************************************************/
/* Written by Peter D. Lee & Robert C. Atwood, Imperial College */
/* Wed Jul  1 18:38:31 bst 1998                                 */
/****************************************************************/
/*RCS Id:$Id: machine.h 1038 2007-07-17 12:05:09Z  $*/
#ifndef MACHINE_H
#define MACHINE_H
/* if specified, include the headers for dbmalloc debugging */
   #include <stdio.h>
#ifdef DBM
   #include <sys/types.h>
   #include "/usr/local/include/dbmalloc.h"
#elif DMALLOC
   #include <stdlib.h>
   #include <dmalloc.h>
#else /* no debugging of malloc */
   #include <stdlib.h>
#endif /* DBM debug malloc */

/* macro to replace the random generator using the preprocessor */
#ifdef REPLACERAND
   extern double replacerand(); 
   extern void replaceSrand(long int seedval); 
#  ifdef drand48
#      undef drand48
#   endif

#   define drand48 replacerand
#   ifdef srand48
#      undef sdrand48
#   endif
#   define srand48 replaceSrand
#endif
#define MAX_REWRITES (100)

#ifdef SGI
#define THE_CLOCK CLK_TCK
#else
#define THE_CLOCK CLOCKS_PER_SEC
#endif

/* the debug malloc header sets this flag, otherwise these funcitons are deactivated */
#ifndef _DEBUG_MALLOC_INC
   #define malloc_enter(func)
   #define malloc_leave(func)
   #define malloc_chain_check()
   #define malloc_dump(fd)
   #define malloc_list(a,b,c)
   #define malloc_inuse(hist)	(*(hist) = 0, 0)
#endif


#include "constants.h"
#include "safeopen.h"

#ifdef DMALLOC /* dmalloc debugging library instead (redhat default) */
#include <dmalloc.h>
#endif


/****************************************************************/
/* set to either single or double precision!                    */
/****************************************************************/ 
/* single precision! *//*by Wei WANG 31-07-02*/
#ifdef CA_DOUBLE
#define CA_FLOAT double
#define SCAN_F "%lf"
#define SQRT(A) sqrt(A)
#define SIN(a) sin(a)
#define POW(A,B) pow( (A),(B) )
#define EXP(A) exp( (A) )
#define CEIL(A) ceil(A)
#define FLOOR(A) floor(A)
#define LOGP(A) log1p(A)
#define LOG(A) log(A)
#define ABS(A) fabs(A)
#define MINVAL (1e-14)

#else /* SINGLE */
#define CA_FLOAT float
#define SCAN_F "%g"
#ifndef SGI
#define SIN(A) ((float) sin((double) A))
#define SQRT(A) ((float) sqrt( (double) A ))
#define POW(A,B) ((float) pow( (double) (A), (double) (B) ))
#define EXP(A) ((float) exp( (double) (A) ))
#define CEIL(A) ((float) ceil((double) A))
#define FLOOR(A) ((float) floor((double) A))
#define LOG(A) ((float) log((double) A))
#define LOGP(A) ((float) log1p((double)  A ))
#define ABS(A)  ((float) fabs((double) A))
#else
#define SQRT(A) sqrtf( A )
#define POW(A,B) powf( (A),(B) )
#define EXP(A) expf( (A) )
#define CEIL(A) ceilf( A )
#define FLOOR(A) floorf( A )
#define LOGP(A) (flog1p( A ))
#define LOG(A) (flog( A ))
#define ABS(A) fabsf(A)
#endif
#define MINVAL (1e-6)
#endif /* DOUBLE/SINGLE */
/* flags for diffusion routine */
#define GAS 0
#define ALLOY 1
/*flag to indicate eutectic solid*/
#define EUT_GRAIN -1
/*flags for nucleation distribution (pores)*/

/*logical flags*/
#if     !defined(TRUE) || ((TRUE) != 1)
#define TRUE    (1)
#endif

#define LINELENGTH 1200
#if     !defined(FALSE) || ((FALSE) != 0)
#define FALSE   (0)
#endif
/* useful small functions */
#ifndef MAX
#define MAX(A,B) ( (A) > (B) ? (A) : (B))
#endif /* MAX */

#ifndef MIN
#define MIN(A,B) ( (A) < (B) ? (A) : (B))
#endif /* MIN */

#define INIT (-1)


/***********************************************************/
/* Default sizes of character strings, etc...              */
/***********************************************************/
#define MAX_STRING_LEN (256)

typedef enum SourceFunctionType{
        MouldSourceNONE,
        MouldSourceCONSTANT,
        MouldSourceDIFF,
        MouldSourcePLIN,
        MouldSourceFLUX
} SrcFn_T;

/* base file name to use for autogenerated restarts and checkpoints */
/* better leave it as "step" , or alter any queue and external checkpointing scripts */

#ifndef DEFAULT_CHECKPOINT_NAME
#  define DEFAULT_CHECKPOINT_NAME ("step") 
#endif
#ifdef BL_COMPRESS
#   define READARRAY read_comp_array
#   define WRITEARRAY write_comp_array
#   define BL_EXT "blz"
#else
#   define READARRAY fread
#   define WRITEARRAY fwrite
#   define BL_EXT "blk"
#endif

#endif /* MACHINE_H */
/*
RCS Log:$Log$
RCS Log:Revision 11.2  2006/08/30 12:50:27  rcatwood
RCS Log:Added constant step file name to block output
RCS Log:
RCS Log:Revision 11.1  2006/03/01 18:20:40  rcatwood
RCS Log:Merging polycomponent and gas with meltback
RCS Log:
RCS Log:Revision 10.2  2005/12/01 14:38:01  rcatwood
RCS Log:Merged xly_05 changes into the main trunk
RCS Log:Primarily involving melt-back
RCS Log:
RCS Log:Revision 10.1.2.2  2005/11/23 18:18:53  rcatwood
RCS Log:Result of merging mould_source and xly meltback+curvature 2d versions
RCS Log:
RCS Log:Revision 10.1  2005/11/03 11:56:47  rcatwood
RCS Log:New version number -- using mould_src as base
RCS Log:
RCS Log:Revision 8.4.8.2  2005/11/02 11:55:05  rcatwood
RCS Log:Fixing up the revision nubmer after loss of repository
RCS Log:
RCS Log:Revision 9.3.4.2  2004/03/04 11:29:24  rcatwood
RCS Log:*** empty log message ***
RCS Log:
RCS Log:Revision 9.3.4.1  2003/12/11 16:04:03  rcatwood
RCS Log:Branch for developing the mould solute source function
RCS Log:
RCS Log:Revision 9.3  2003/11/05 17:00:39  rcatwood
RCS Log:Combined the ca_solid and ca_solid_procast into a single version (ca_solid.c)
RCS Log:this required some changes to wrapper and other files
RCS Log:
RCS Log:Revision 9.2  2003/10/23 16:32:39  rcatwood
RCS Log:chagned signal result to allow writing of the final files on USR1
RCS Log:
RCS Log:Revision 9.1  2003/08/14 14:38:37  rcatwood
RCS Log:Working merge with decentered/porosity/procast, also including
RCS Log:Ali Chirazi's multicomponent (not tested in this version)
RCS Log:
RCS Log:Revision 8.4.2.5  2003/08/14 14:18:03  rcatwood
RCS Log:Working ca_procast new version, on linux
RCS Log:Added surface nucleation
RCS Log:Added mould source term
RCS Log:Changed printout headers
RCS Log:Temperature output image
RCS Log:
RCS Log:Revision 8.4.2.4  2003/03/12 18:32:31  rcatwood
RCS Log:Added diagnostic output to readwrite_fg
RCS Log:
RCS Log:Revision 8.4.2.3  2003/01/22 16:53:44  rcatwood
RCS Log:Almost working read_fg version
RCS Log:
RCS Log:Revision 8.4.2.2  2003/01/15 19:02:00  rcatwood
RCS Log:*** empty log message ***
RCS Log:
RCS Log:Revision 8.4  2003/01/10 19:06:47  rcatwood
RCS Log:changed location of dbmalloc library & header
RCS Log:
RCS Log:Revision 8.3  2002/12/13 18:06:06  rcatwood
RCS Log:Started rewriting input section for VAR input
RCS Log:
RCS Log:Revision 8.2  2002/10/31 18:02:57  rcatwood
RCS Log:Moved clock tick macro to machine.h where it belongs
RCS Log:
RCS Log:Revision 8.1  2002/10/17 17:01:02  rcatwood
RCS Log:New version number! for decentered/porosity merge! Alpha Version!
RCS Log:
RCS Log:Revision 7.4  2002/10/17 16:52:37  rcatwood
RCS Log:Merge from branch: combined Robert (porosity) and Wei (decentered octahedron) versions
RCS Log:
RCS Log:Revision 7.3.10.1  2002/08/22 15:13:43  ww1
RCS Log:Merge of Wei Wang's decentered octahedron/square method
RCS Log:
RCS Log:Revision 7.3  2002/05/23 17:28:01  rcatwood
RCS Log:Used dbmalloc to eliminate all memory leaks!
RCS Log:Started close-sb routine to improve multiblock
RCS Log:
RCS Log:Revision 7.2  2001/08/28 19:08:51  rcatwood
RCS Log:thesis version
RCS Log:
RCS Log:Revision 7.1  2000/12/06 21:10:40  rcatwood
RCS Log:fixed up heatfolw, tctrace
RCS Log:
RCS Log:Revision 7.0  2000/11/07 15:55:38  rcatwood
RCS Log:Multi Cell Pores added
RCS Log:
RCS Log:Revision 6.1  2000/10/16 10:37:22  rcatwood
RCS Log:Changed grain nuc to include block_nuc method
RCS Log:
RCS Log:Revision 6.0  2000/09/25 18:03:36  rcatwood
RCS Log:After PORE_00 and NLM
RCS Log:
RCS Log:Revision 2.0  2000/08/02 10:21:56  rcatwood
RCS Log:Version used for pore paper runs
RCS Log:
RCS Log:Revision 1.2  2000/07/11 16:33:44  rcatwood
RCS Log:Changed pore output.
RCS Log:
RCS Log:Revision 1.1  2000/05/22 12:29:24  rcatwood
RCS Log:Fixed fs finish. Casolid to C from  W file. Global option
RCS Log:
RCS Log:Revision 5.3  2000/04/11 14:44:05  rcatwood
RCS Log:Seperated castats routines. Fixed sreenprint bug and error overruns
RCS Log:
RCS Log:Revision 5.2  2000/03/15 16:25:32  rcatwood
RCS Log:backup checkin
RCS Log:
RCS Log:Revision 5.1  2000/03/02 16:11:10  rcatwood
RCS Log:Merged xxu and rca versions
RCS Log:
RCS Log:Revision 5.0.2.2  2000/03/02 13:09:59  rcatwood
RCS Log:Fixed copy-mat bug.
RCS Log:
RCS Log:Revision 5.0.2.1  2000/03/01 15:54:30  rcatwood
RCS Log:merged VAR and Multiblock updates. Not tested
RCS Log:
RCS Log:Revision 5.0.1.2  2000/02/29 18:00:25  rcatwood
RCS Log:Bug fixed when growing into new block
RCS Log:
RCS Log:Revision 5.0.1.1  2000/02/22 19:04:27  rcatwood
RCS Log:Not yet tested
RCS Log:
RCS Log:Revision 4.2  1999/12/23 18:12:24  rcatwood
RCS Log:Version used for Mcwasp runs
RCS Log:
RCS Log:Revision 4.1  1999/12/16 13:33:44  rcatwood
RCS Log:Finalised improved use of RCS in all files.
RCS Log:
RCS Log:Revision 4.0.2.1  1999/12/16 12:37:36  rcatwood
RCS Log:Improving rcs id for all files, this may require several checkins to test.
RCS Log:
*/

