#include <stdio.h>
#include <math.h>
#include "machine.h"

CA_FLOAT rand_square (CA_FLOAT * params)
{
  int i;

  /*  Three parameters:  */
  /*  bottom = params[0] */
  /*  width = params[1] */
  /*  power = params[2] */
  /*   should be 1/3 for y^2 (Oldfield) distribution */
  /*   (the inverse-function of the integral) */

  /* make sure the parameters exist */
  for (i = 0; i < 3; i++) {
    if ((params + i) == NULL) {
      fprintf (stderr, "ERROR: rand_square: You didn't give me enough information (NULL pointer)\n");
      fprintf (stderr, "ERROR: rand_square: You really need to debug this.\n");
      exit (1);
    }
  }

  for (i = 0; i < 3; i++) {
    if (*(params + i) < 0) {
      fprintf (stderr, "ERROR: rand_square: Parameter %i less than zero %.5g\n", i, *(params + i));
      exit (1);
    }
  }

  return (params[0] + POW (drand48 (), params[2]) * params[1]);
}

/* Little subroutine to get rcs id into the object code */
/* so you can use ident on the compiled program  */
/* also you can call this to print out or include the rcs id in a file */
char const *rcs_id_rand_square_c ()
{
  static char const rcsid[] = "$Id: rand_square.c 887 2006-03-01 18:21:01Z rcatwood $";

  return (rcsid);
}

/* end of rcs_id_subroutine */
