/*$Id: read_ca_procast.c 887 2006-03-01 18:21:01Z rcatwood $*/
/* #define DEBUG */
/****************************************************************/
/*      Copyright (c) 1998 Dept. of Materials, ICSTM            */
/*      All Rights Reserved                                     */
/*      THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF ICSTM    */
/*      The copyright notice above does not evidence any        */
/*      actual or intended publication of such source code,     */
/*      and is an unpublished work by Dept. of Materials, ICSTM.*/
/*      This material contains CONFIDENTIAL INFORMATION that    */
/*      is the property of Imperial College. Any use,           */
/*      duplication or disclosure not specifically authorized   */
/*      by Imperial College is strictly prohibited.             */
/****************************************************************/
/* This code is part of the umats routines developed at in the  */
/* Materials Processing Group, Dept. of Materials, ICSTM.       */
/*	email p.d.lee or r.atwood @ic.ac.uk for details         */
/****************************************************************/

/****************************************************************/
/* READ_CA_PROCAST.C:   (Part of CA code)                       */
/* Subroutine to read the initial values for ca_procast.        */
/* The file is formated, using the style:                       */
/*    # as first character:     Comment                         */
/* and values are input in the format:                          */
/*    command value  #comments                                  */
/****************************************************************/
/****************************************************************/
/* Written by Peter D. Lee, Robert C. Atwood & A. Chirazi       */
/*                                           , Imperial College */
/* Feb 25, 2002                                                 */
/****************************************************************/

#include <stdio.h>
#include <string.h>
#include <math.h>
#include "blocks.h"

#define D_CELL_OPTION 2
#define D_NSB 1
#define D_CELL_SIZE 10.0E-06
#define D_NC_SB 50

int read_ca_procast (Ctrl_str * cp, BB_struct * bp)
{
  char line[MAX_STRING_LEN];
  char *token;
  int i, error;
  int rflag = 0;

   /*********************************************************/
  /* Open the file                                         */
   /*********************************************************/
  if ((cp->fd_ca_procast = fopen (cp->fn_ca_procast, "r")) == NULL) {
    fprintf (stderr, "Error: can't open input file [%s]\n", cp->fn_ca_procast);
    exit (0);
  }

  while (fgets (line, MAX_STRING_LEN, cp->fd_ca_procast) != NULL) {

    /* ignore comment and blank lines */
    if (line[0] == '%' || line[0] == '#' || (token = strtok (line, " ,;\t")) == NULL) {
      continue;

      /*********************************************************/
      /* All values in the bigblock structure                  */
      /*********************************************************/
      /* CellOption int */
    } else if (strcasecmp (token, "CellOption") == 0) {
      if ((token = strtok (NULL, " ,;\t\n")) != NULL)
        bp->cell_option = atoi (token);
      else {
        bp->cell_option = D_CELL_OPTION;
        rflag++;
        fprintf (stderr, "Error: CellOption, default value used: %d.\n", bp->cell_option);
      }
      /* BigBlockOrigin CA_FLOAT CA_FLOAT CA_FLOAT */
    } else if (strcasecmp (token, "BigBlockOrigin") == 0 && bp->cell_option == 2) {
      for (i = 0; i < 3; i++) {
        if ((token = strtok (NULL, " ,;\t\n")) != NULL)
          bp->orig_bb[i] = atof (token);
        else {
          bp->orig_bb[i] = 0.0;
          fprintf (stderr, "Error: BigBlockOrigin, default value used: %f.\n", 0.0);
        }
      }
      /* Default if command not recognised */
    } else {
      fprintf (stderr, "Warning: Unknown command: %s.\n", token);
      rflag++;
    }
  }                             /* end while */

  return rflag;

}                               /* end of read_ca_procast routine */

/***************************************************/
/* rcs id routine to include rcs id in the program */
/* generated by make_rcs_sub.sh script             */
/***************************************************/
char const *read_ca_procast_c ()
{
  static char const rcsid[] = "$Id: read_ca_procast.c 887 2006-03-01 18:21:01Z rcatwood $";

  return (rcsid);
}
