/****************************************************************/
/*   Copyright (c) 1998 Dept. of Materials, ICSTM               */
/*   All Rights Reserved                                        */
/*   THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF ICSTM       */
/*   The copyright notice above does not evidence any           */
/*   actual or intended publication of such source code,        */
/*   and is an unpublished work by Dept. of Materials, ICSTM.   */
/*   This material contains CONFIDENTIAL INFORMATION that       */
/*   is the property of Imperial College. Any use,              */
/*   duplication or disclosure not specifically authorized      */
/*   by Imperial College is strictly prohibited.                */
/****************************************************************/
/* This code is part of the umats routines developed at in the  */
/* Materials Processing Group, Dept. of Materials, ICSTM.       */
/*      email p.d.lee or r.atwood @ic.ac.uk for details         */
/****************************************************************/

/****************************************************************/
/* output.h                                                     */
/* Header file defining output structure                        */
/****************************************************************/
/* Written by Peter D. Lee & Robert C. Atwood, Imperial College */
/* Aug 15, 1998                                                 */
/*RCS Id:$Id: read_ctrl.h 1482 2009-11-25 21:08:47Z  $*/
/****************************************************************/


#ifndef READCTRL_H
#define READCTRL_H
#define CTRLREV "read_ctrl.h $Revision: 1482 $"

#ifndef OUTPUT_H
  #include "output.h"
#endif /* OUTPUT_H */


/****************************************************************/
/* Ouput_Str holds things which set output options     */
/****************************************************************/
typedef struct ctrl_opt {
   char * cflags;
   int jflg;                    /* behaviour due to signal handler*/
   int restart;                 /* is this a restart? */
   int restart_pore_on;         /* reinitialize with pores turned on at restart */
   int restart_gas_on;          /* reinitialize the gas array at restart */
   int mould_nuc;
   int mould_src;              /*  mould function 0=no 1=yes */
   int mould_src_pert;          /* perturb the mould source? */

   CA_FLOAT mould_source_value;
   CA_FLOAT mould_source_pert;  /* magnitude of perturbation */
   CA_FLOAT mould_source_freq;  /* spatial lenght scale of pert. */

   int solo;                    /* flag: true running alone       */
   int cap;                     /* flag to state if CAP mode      */
   int post;                    /* flag: true - postprocessing    */
   int input;                   /* flag: true - input bigblock    */
   int t_input;                 /* flag: true - temperature input */
   int fgrid_input;             /* flag: true - input fgrid       */
   int fg_tr;                   /* flag: true - transient       */
   int con_cast;                /* contiuous casting postpro      */
   int particle;                /* particle mode 0=no 1=yes       */
   int diffuse;                 /* gas diffusion 0=no 1=yes          */
   int pore;                    /* pores 0=no 1=yes               */
   int temp_lookup;             /* Ali version lookup for temperature */
   int pr_lookup;               /* lookup for pressure */
   int swap_xy;
   int diffuse_alloy;
   int diffuse_alloy_multi;     /* 0=no and 1=yes */

/*THUINET 07-02-05*/
   int diffuse_alloy_poly;      /* 0=no and 1=yes */
/*End THUINET 07-02-05*/

   int thermocalc;              /* 0=no and 1=yes */
   int temp_dep_diff;           /* 0=no and 1=yes */
   int interpolate;             /* 1, 2 or 3 */
   int show_eut;                /*show eutectic as special colour*/
   int phase_diag_on;           /* use phase diag. for cell Tund*/
   int das_limrad;              /* use limiting radius based on das*/
   int global_undercooling;     /* use und. wrt bulk liquidus for nucleation */
   int diffuse_step;            /*  no of diff steps per growth */
   int window_moving;           /* true window moving */ /*by Wei WANG on 11-07-02*/
   int melt_back;               /* melt-back */
   int isotherm_curv;           /* producing concave or convex isotherm */
   int init_cont;               /* 0 initial 1 continuous calculation */ /*by Wei WANG on 11-07-02 */
   int decentred_octahedron;    /* true use decentred square_octahedron algorithm */ /*by Wei WANG on 11-07-02*/
   int procast;                 /* the procast mode is on *******/
   int ca_feedback;             /* the fully coupled version is used*/
   int flow_on;                 /* the flow option of procast is on */
   int curvature_3D;		/* PLIC algorithm for 3D curvature */
   int curvature_2D;             /* PLIC algorithm for 2D curvature */
				/* Control of CA neighbourhood  */
   int ca_method;               /* use push or pull method?     */
   int scheil;                   /* use schiel rules?            */
   int n_neigh;                 /* # of neighbours to use       */
   int32_t seed;              /* rand. num. gen. seedval      */

				/* FILES FOR INPUT              */
   char *fn_ca_procast;                /* Filename for ca_procast file */
   char *fn_ctrl;                      /* Filename the control options were read from*/ 
   char *fn_block_restart;             /* Filename for restart data */ 
   FILE *fd_ca_procast;                /* File Handle for ca_procast file */
   char *fn_phadia;             /* Filename for phase diagram   */
   FILE *fd_phadia;             /* File Handle for phase diagram */
   char *fn_cap;                /* Filename for CAP CA file     */
   FILE *fd_cap;                /* File Handle for CAP CA file  */
   char *fn_geo;                /* Filename for readgeoplus     */
   FILE *fd_geo;                /* File Handle for readgeoplus  */
   char *fn_mat;                /* Filename for readmat         */
   FILE *fd_mat;                /* File Handle for readmat      */
   char *fn_inp;                /* Filename for read Input      */
   FILE *fd_inp;                /* File Handle for read Input   */
   char *fn_base;               /* Filename base for all output */
   char *fn_fgrid;              /* filename for input of FGrid_str nodal values data */
   char *fn_t_input;
   char *fn_solprops_gas;       /* filename for input of gas solute props */
   char *fn_solprops_alloy[NSOLMAX];     /* filename for input of alloy solute props */

   char *fn_extinp;
   int extinput;
				/* VARIABLES RELATED TO OUTPUT  */
   int nsbslice;                /* # of SB slices to print      */
   int nbbslice;                /* # of BB slices to print      */
   int pore_dump_sb;            /* dump pore radius for sb #    */
   int write_block;
   int grainslice;              /* do line intercept on slice # */
   int slice[MAX_CTRL][2];      /* gif ouput of slice: sb#, sl# */
   int bbslice[MAX_CTRL];       /* gif ouput of BB slice:  sl#  */
   int nfsprint;                /* create output when fs is reached */
   CA_FLOAT fsprint[MAX_CTRL];
   int do_conc_prof;            /* do a conc profile> true/false */
   int conc_prof[3];            /* concentration profile sb#,sl#,row*/
   int time_dump;               /* interpret output step as time (not absolute steps */
   int time_exp;                /* unit of time 0=seconds -3 = millisecond +1 = 10sec */
   CA_FLOAT time_unit;          /* unit of time calculated from time_exp */
   int slice_dmp_freq;          /* Slice  print Freq.           */
   int blk_dmp_freq;          /* Slice  print Freq.           */
   int scr_dmp_freq;            /* Screen print Freq.           */
   int plt_dmp_freq;            /* Tecplot file output Freq.  LY*/
   int vtk_dmp_freq;            /*  Paraview file output Freq. LY*/
   int maxucmap_freq;           /*  max uncercooling map freq. LY*/
   int point_dmp_freq;          /* extra point information output freq. LY*/
   int line_dmp_freq;
   int ptrack[MAX_CTRL][3]; /*points to track*/
   int **lntrack; /*lines to track*/
   int nptrack;
   int nlntrack;

   
   int nscrdumps;               /*est. number of screen dumps */
   int tempslice;                /*print a temperature slice of bb*/
   int floatdump;               /* dump the float info for slice*/
   int excel;                   /* Printout excel files 1/0=t/f */
   FILE *fd_ex;                 /* File Handle for excel output */
   FILE *fd_ex_diff;            /* File Handle for conc. output */
   FILE *fd_ex_pore;            /* File handle for pores output */
   FILE *fd_ex_pore_stats;            /* File handle for pores output */
   FILE *fd_ex_pore_extent;     /* File handle for  pore extent output */
   RGB_struct *rgbp;             /* RGB colouring scheme         */
   int rgbmode;                 /* RGB colouring scheme          */
   int rgbgrey;
				/* VARIABLES FOR CONCENTRATION OUTPUT */
   int diff_rgbmode;            /* RGB colouring scheme for diff */
   int diff_log_disp;           /* Logarithmic Concentration Display*/
   int diff_ratio_disp;         /* Use max at each step for ratio*/
   CA_FLOAT alloy_disp_max;           /* Value for max colour          */
   CA_FLOAT gas_disp_max;           /* Value for max colour          */
   int diff_disp_cap;           /* use const colour over max, or wrap? */
				/* VARIABLES RELATED TO TESTING */
   int fixed_Pore;               /* true/false: use fixed porenucl.  */
   int nfPore;                   /* number of fixed nuclei       */
   CA_FLOAT nPsite[MAX_CTRL][5];      /* location of fixed nuclei     */

   int fixed_nuc;               /* true/false: use fixed nucl.  */
   int block_nuc;
   int nfnuc;                   /* number of fixed nuclei       */

   int flowdiffusion;
   /* CA- PHYSICA variables by lyuan*/

   FILE *fd_ca_phy;              /* Control file of caphy.in*/
   char *fn_ca_phy;                   
   char Phyfn[MAX_STRING_LEN];   /* physica case name */
   int  physica;                 /* physica mode on/off  1/0  by lyuan*/
   int  fluidflow;               /* Fluidflow mode on/off 1/0  by lyuan */
   int  ffheattran;               /* Heat transfer mode */
   int  ffstepgap;    /*velocity field solved each * steps*/
   int  remelt;  /*remelt calculation on/off 1/0*/
   int maxucmap;  /* calculate max undercooling map if freq. > 0*/
   CA_FLOAT fstarttime;  /* fluid flow starting timer*/
   CA_FLOAT wmstarttime;  /* fluid flow starting timer*/
   
/*THUINET 04/05*/
   int nfnuc_poly[NPHAMAX];
/*END THUINET 04/05*/

/*THUINET 04/05*/
  /*CA_FLOAT nsite[MAX_CTRL][7];*/      /* fixed nuclei */ /*modified by Wei WANG on 29-01-03*/
  CA_FLOAT nsite[MAX_CTRL][8];
/*END THUINET 05/05*/  

/*THUINET 04/05*/
   int nsite_poly[NPHAMAX][MAX_CTRL][7];
/*END THUINET 04/05*/

   int coolrate;               /* Const. cooling */
   CA_FLOAT fs_finish;
   CA_FLOAT ref_pres;             /* reference pressure used for pressure calculation */
   CA_FLOAT delT;                  /* cooling rate  */
   int NUM_COMP;                  /*number of component*/
   int ele_1;
/*THUINET 04/05*/
   int NUM_PHS; /*number of solid phases for multiphase solidification*/
   int NUM_EQ; /*number of equilibria for multiphase solidification*/
   int NUM_NUC_LAW;/*number of distinct gaussian nucleation law*/
   int ietat; /*define the state of a cell*/
/*END THUINET*/ 
   /* logically combined options -- precalculated to save time */

   int use_global_undercooling;
   int use_csol_alloy;
   int use_cell_nuc;
   int use_cell_temp;
   int eut_nuc_option;
   int strontium;
   /* for debugging memory with dbMalloc */
   unsigned long int hist[5];
   /*DBM - can't ifdef this without messing up the read_bin_blocks*/

} Ctrl_str;

/****************************************************************/
/* Define all of the default values below to be used            */
/* if the user does not specify them.                           */
/****************************************************************/
#define D_SOLO TRUE             /* flag: true running alone     */
#define D_PHASE_DIAG FALSE
#define D_GLOBAL_UNDERCOOLING FALSE
#define D_SHOW_EUT FALSE
#define D_DAS_LIMRAD FALSE
#define D_INP  FALSE            /* flag to state if CAP mode    */
#define D_CAP  FALSE            /* flag to state if CAP mode    */
#define D_POST FALSE            /* flag: true - postprocessing  */
#define D_PROCAST FALSE
#define D_RESTART FALSE
#define D_RESTART_PORE FALSE 
#define D_RESTART_GAS FALSE 
#define D_FEEDBACK FALSE
#define D_FLOW_ON FALSE
#define D_EutNucOption 0         /* default value for the eutectic nucleation threshold setting */
#define D_StrontiumOption 0      /* default value for the strontium flag */
#define D_REF_PRES 1.0           /* default for the reference pressure */
#define D_TEMPSLICE FALSE         /* flag: true -  print temp slice*/
#define D_PARTICLE FALSE
#define D_DIFFUSE FALSE         /* flag: true - diffuse gas     */
#define D_DIFFUSE_ALLOY FALSE   /* flag: true - diffuse alloy   */
#define D_DIFFUSE_ALLOY_MULTI FALSE  /* flag for multi diffusion */
#define D_TEMP_DEP_DIFF FALSE    /* flag for temperature dependent diffusion */
#define D_INTERPOLATION LINEAR1  /* flag for the choice of inter function */
#define D_DIFFUSE_STEP 1        /* no of diff steps per gro.st. */
#define D_WINDOW_MOVING FALSE   /* by Wei WANG on 11-07-02*/
#define D_INIT_CONT 0           /* by Wei WANG on 11-07-02*/
#define D_DECENTRED_OCTAHEDRON FALSE /*by Wei WANG on 11-07-02*/
#define D_ISOTHERM_CURV FALSE
#define D_MELT_BACK FALSE
#define D_CON_CAST FALSE        /* flag: true - con_cast mode   */
#define D_CAP_FILE "bigblock.dat"
#define D_BLOCK_RESTART_FILE "no_such_file.blk"
#define D_GEO_FILE "ca_geoplus.in"
#define D_MAT_FILE "ca_matprop.in"
#define D_INP_FILE "ca_test.inp"
#define D_PHADIA_FILE "ca_phadia.in"
#define D_FG_FILE "ca_fg.fbn"
#define D_PORE TRUE
#define D_BASEFILE "ca_testout"
#define D_FS_FINISH 1.1
#define D_SEEDVAL 98724351	/* random num. gen. seedval     */
#define D_THERMOCALC FALSE
#define D_NUM_COMP 3           /* default num of components */
#define D_NUMTIETRI 20         /* default num of tie triangles produced by thermocalc for the ternary alloy */

#define D_EXTINP_FILE "test.bin"

/****************************************************************/
/* Define CA method defs...                                     */
/****************************************************************/
#define CA_PULL 1               /* turn node solid dep. on neigh*/
#define CA_PUSH 2               /* if node turn sol, push on n's*/
#define CA_NOSCH 0               /* if node turn sol, push on n's*/

/****************************************************************/
/* Define all of the default output values below to be used     */
/* if the user does not specify them.                           */
/****************************************************************/
#define D_CA_FLOATDUMP 0
#define D_EXCEL 1               /* Printout excel files 1/0=t/f */
#define D_SLICE_FREQ 10         /* Screen print Freq.           */
#define D_SCREEN_FREQ 1         /* Screen print Freq.           */
#define D_BLK_FREQ 0         /* block print Freq.           */
#define D_RGB_RANDOM 1          /* RGB colour scheme            */
#define D_DIFF_RGBMODE 1        /* RGB colour scheme for diff.  */
#define D_DIFF_DISP_MAX 100     /*max for concentration display */

/****************************************************************/
/* Define default DEBUGGING states                              */
/****************************************************************/
#define D_DEL_TEMP 1.0          /* fixed T drop for testing     */

/***************************************************************/
/*Define CA-PHYSICA                                            */
/***************************************************************/
#define D_CA_PHY_FILE "ca_phy.in"
#define D_PHYCASE_FILE "ingot"
#define D_PHY_OPTION 2
#define D_PHY_GROWVELOCITY 2e-5
#define D_PHY_CONVECTION 0
#define D_PHYSICA FALSE


#endif /* READCTRL_H */
/*
RCS Log:$Log$
RCS Log:Revision 11.1  2006/03/01 18:20:40  rcatwood
RCS Log:Merging polycomponent and gas with meltback
RCS Log:
RCS Log:Revision 10.2.2.2  2006/01/18 12:01:17  lthuinet
RCS Log:*** empty log message ***
RCS Log:
RCS Log:Revision 10.2.2.1  2006/01/10 13:58:24  rcatwood
RCS Log:Temporary branch for merging lthuinet poly-component and main branch
RCS Log:
RCS Log:Revision 10.2  2005/12/01 14:38:01  rcatwood
RCS Log:Merged xly_05 changes into the main trunk
RCS Log:Primarily involving melt-back
RCS Log:
RCS Log:Revision 10.1.2.2  2005/11/23 18:18:53  rcatwood
RCS Log:Result of merging mould_source and xly meltback+curvature 2d versions
RCS Log:
RCS Log:Revision 10.1.2.1  2005/11/07 17:47:56  rcatwood
RCS Log:Branch uisng Xiao Li Yang final version
RCS Log:Revision 10.1  2005/11/03 11:56:47  rcatwood
RCS Log:New version number -- using mould_src as base
RCS Log:
RCS Log:Revision 9.3.2.4.4.2  2005/01/18 11:45:20  xly
RCS Log:*** empty log message ***
RCS Log:
RCS Log:Revision 9.3.2.4.4.1  2004/08/02 13:09:58  xly
RCS Log:*** empty log message ***
RCS Log:Revision 8.3.8.2  2005/11/02 11:55:06  rcatwood
RCS Log:Fixing up the revision nubmer after loss of repository
RCS Log:
RCS Log:Revision 9.3.2.4  2004/06/18 18:26:37  rcatwood
RCS Log:Added option for output freqency at uniform sim-time instead of steps
RCS Log:
RCS Log:Revision 9.3.2.3  2004/03/09 11:30:53  rcatwood
RCS Log:Changed to read materials properties from separate files for alloy and gas
RCS Log:
RCS Log:Revision 9.3.2.2  2004/03/04 11:29:25  rcatwood
RCS Log:*** empty log message ***
RCS Log:
RCS Log:Revision 9.3.2.1  2003/12/11 16:04:03  rcatwood
RCS Log:Branch for developing the mould solute source function
RCS Log:
RCS Log:Revision 9.3  2003/12/11 15:56:03  rcatwood
RCS Log:Changed block output : uses .blk file and separate frequecy step
RCS Log:
RCS Log:Revision 9.2  2003/11/05 17:00:39  rcatwood
RCS Log:Combined the ca_solid and ca_solid_procast into a single version (ca_solid.c)
RCS Log:this required some changes to wrapper and other files
RCS Log:
RCS Log:Revision 9.1  2003/08/14 14:38:38  rcatwood
RCS Log:Working merge with decentered/porosity/procast, also including
RCS Log:Ali Chirazi's multicomponent (not tested in this version)
RCS Log:
RCS Log:Revision 8.3.2.13  2003/08/14 14:18:04  rcatwood
RCS Log:Working ca_procast new version, on linux
RCS Log:Added surface nucleation
RCS Log:Added mould source term
RCS Log:Changed printout headers
RCS Log:Temperature output image
RCS Log:
RCS Log:Revision 8.3.2.12  2003/07/17 10:10:56  rcatwood
RCS Log:activated supersaturation output for gas
RCS Log:
RCS Log:Revision 8.3.2.11  2003/06/30 16:32:54  rcatwood
RCS Log:Flux from not-casting boundary
RCS Log:
RCS Log:Revision 8.3.2.10  2003/06/16 17:19:27  rcatwood
RCS Log:Added restart with pores turned on
RCS Log:
RCS Log:Revision 8.3.2.9  2003/06/13 17:55:32  rcatwood
RCS Log:Added restart with ability to turn on gas diffusion
RCS Log:
RCS Log:Revision 8.3.2.8  2003/05/19 18:55:17  rcatwood
RCS Log:Addded option to allow horizontal or vertical directional growth
RCS Log:and flux boundary condition
RCS Log:
RCS Log:Revision 8.3.2.7  2003/05/14 11:49:54  rcatwood
RCS Log:Fixed temperature input to conform wiht new temperature calculation methods
RCS Log:and control input file
RCS Log:
RCS Log:Revision 8.3.2.6  2003/02/11 20:02:11  ww1
RCS Log:
RCS Log:add output for equivalent concentration and undercooling
RCS Log:
RCS Log:Revision 8.3.2.5  2003/01/23 17:47:27  rcatwood
RCS Log:finite grid applied to decentered square,
RCS Log:works, but not checked for correct results.
RCS Log:
RCS Log:Revision 8.3.2.4  2003/01/22 16:53:46  rcatwood
RCS Log:Almost working read_fg version
RCS Log:
RCS Log:Revision 8.3.2.3  2003/01/16 18:55:31  rcatwood
RCS Log:Modified location of bb into ca_wrapper from ca_solid
RCS Log:Makefile modified to use subdirectories
RCS Log:
RCS Log:Revision 8.3  2002/12/17 13:36:40  rcatwood
RCS Log:Changed lcoation of readwrite_fg
RCS Log:
RCS Log:Revision 8.1.6.1  2002/11/06 17:27:48  rcatwood
RCS Log:NOT WORKING check-in of first stage merge with ca_procast
RCS Log:
RCS Log:Revision 8.1  2002/10/17 17:01:03  rcatwood
RCS Log:New version number! for decentered/porosity merge! Alpha Version!
RCS Log:
RCS Log:Revision 7.9  2002/10/17 16:52:38  rcatwood
RCS Log:Merge from branch: combined Robert (porosity) and Wei (decentered octahedron) versions
RCS Log:
RCS Log:Revision 7.8.10.6  2002/10/09 12:19:10  rcatwood
RCS Log:alpha merge of decentered and pore versions
RCS Log:with added write_(structue)_values routines and aux program files for autogenerating
RCS Log:these routines from the structure definitions.
RCS Log:
RCS Log:Revision 7.8.10.5  2002/10/07 13:24:29  ww1
RCS Log:fixed total fraction solid at each time step and remove curv from ctrl
RCS Log:
RCS Log:Revision 7.8.10.4  2002/09/19 11:25:43  rcatwood
RCS Log:added control to print out at a specified fraction-solid
RCS Log:
RCS Log:Revision 7.8.10.3  2002/09/17 20:51:07  rcatwood
RCS Log:Rearranged so that read/write leave the memory clean
RCS Log:Added signal 16 (SIGUSR1) catching for trapping after finishing the current timestep.
RCS Log:
RCS Log:Revision 7.8.10.2  2002/09/03 13:31:59  rcatwood
RCS Log:Merged with reorganized allocation routines, and adjusted nucleation to compartmentalize
RCS Log:the grain information assignment.
RCS Log:
RCS Log:Revision 7.8.10.1  2002/08/22 15:13:43  ww1
RCS Log:Merge of Wei Wang's decentered octahedron/square method
RCS Log:Revision 7.8.2.3  2002/07/09 11:46:38  rcatwood
RCS Log:Split big block memory allocation and value initialization into seperate files.
RCS Log:Use alloc_bb for reading the block file.
RCS Log:Test program read_binblocks.c working (almost) TODO: all strings in ctrl, pore lists
RCS Log:
RCS Log:Revision 7.8.2.2  2002/05/29 14:24:50  rcatwood
RCS Log:Working up to subblock header & array data
RCS Log:
RCS Log:Revision 7.8.2.1  2002/05/29 11:11:09  rcatwood
RCS Log:Added revision string macro to block header files
RCS Log:for testing compatiblity when reading
RCS Log:
RCS Log:Revision 7.8  2002/05/23 17:28:01  rcatwood
RCS Log:Used dbmalloc to eliminate all memory leaks!
RCS Log:Started close-sb routine to improve multiblock
RCS Log:
RCS Log:Revision 7.7  2002/04/22 16:09:04  rcatwood
RCS Log:Added compression for bin files
RCS Log:
RCS Log:Revision 7.6  2002/02/14 13:15:02  rcatwood
RCS Log:Added write_block option instead of cpp definintion.
RCS Log:
RCS Log:Revision 7.5  2001/04/10 12:17:21  rcatwood
RCS Log: added listing of compilation flags to control header output (requres Makefile modification)
RCS Log:
RCS Log:Revision 7.4  2001/03/13 10:36:46  rcatwood
RCS Log:Ready to Merge with anchou version
RCS Log:Fixed not-casting problems,
RCS Log:seperate pore stats file.
RCS Log:
RCS Log:Revision 7.3  2001/02/22 13:00:24  rcatwood
RCS Log:Included pore reallocation and stop temp (as cpp macro)
RCS Log:fixed x-y bug in line intercept routine
RCS Log:
RCS Log:Revision 7.2  2001/02/16 20:30:49  rcatwood
RCS Log:Added some commenting for DAS and Limrad
RCS Log:Removed some JUNK
RCS Log:
RCS Log:Revision 7.1  2001/02/15 15:15:52  rcatwood
RCS Log:Improved STAT_ONLY mode. Added pore extent output.
RCS Log:
RCS Log:Revision 7.0  2000/11/07 15:55:38  rcatwood
RCS Log:Multi Cell Pores added
RCS Log:
RCS Log:Revision 6.3  2000/10/24 14:55:52  rcatwood
RCS Log:before changing pore
RCS Log:
RCS Log:Revision 6.2  2000/10/16 10:37:22  rcatwood
RCS Log:Changed grain nuc to include block_nuc method
RCS Log:
RCS Log:Revision 6.1  2000/10/09 16:57:04  rcatwood
RCS Log:Before changing nucleation
RCS Log:
RCS Log:Revision 6.0  2000/09/25 18:03:37  rcatwood
RCS Log:After PORE_00 and NLM
RCS Log:
RCS Log:Revision 2.0  2000/08/02 10:21:56  rcatwood
RCS Log:Version used for pore paper runs
RCS Log:
RCS Log:Revision 1.3  2000/06/27 11:41:19  rcatwood
RCS Log:Changed pore output.
RCS Log:
RCS Log:Revision 1.2  2000/06/06 18:43:04  rcatwood
RCS Log:Changed r start and growth of pores -- pore radius equilibrium
RCS Log:
RCS Log:Revision 1.1  2000/05/22 12:29:24  rcatwood
RCS Log:Fixed fs finish. Casolid to C from  W file. Global option
RCS Log:
RCS Log:Revision 5.6  2000/05/04 18:36:45  rcatwood
RCS Log:Fixed fs finish. Casolid to C from  W file. Global option
RCS Log:
RCS Log:Revision 5.5  2000/04/11 14:44:05  rcatwood
RCS Log:Seperated castats routines. Fixed sreenprint bug and error overruns
RCS Log:
RCS Log:Revision 5.5  2000/03/27 17:06:27  rcatwood
RCS Log:Particle dependant growth - neg. phi
RCS Log:
RCS Log:Revision 5.4  2000/03/27 11:21:22  rcatwood
RCS Log:Checkin prior to modifications for particle version
RCS Log:
RCS Log:Revision 5.4  2000/03/27 11:21:18  rcatwood
RCS Log:Particle dependant growth - neg. phi
RCS Log:
RCS Log:Revision 5.3  2000/03/24 19:33:30  rcatwood
RCS Log:Checkin prior to modifications for particle version
RCS Log:
RCS Log:Revision 5.3  2000/03/24 19:19:48  rcatwood
RCS Log:Particle dependant growth fixed
RCS Log:
RCS Log:Revision 5.2  2000/03/23 19:00:16  rcatwood
RCS Log:Checkin prior to modifications for particle version
RCS Log:
RCS Log:Revision 5.2  2000/03/23 18:57:36  rcatwood
RCS Log:Particle dependant growth added
RCS Log:
RCS Log:Revision 5.1  2000/03/02 16:11:10  rcatwood
RCS Log:Merged xxu and rca versions
RCS Log:
RCS Log:Revision 5.0.2.1  2000/03/01 15:54:30  rcatwood
RCS Log:merged VAR and Multiblock updates. Not tested
RCS Log:
RCS Log:Revision 5.0.1.1  2000/02/22 19:04:27  rcatwood
RCS Log:Not yet tested
RCS Log:
RCS Log:Revision 4.8  2000/01/27 12:18:48  rcatwood
RCS Log:Overgrowth addressed. Bindump of t, fs
RCS Log:
RCS Log:Revision 4.7  2000/01/13 15:32:29  rcatwood
RCS Log:Binary dump of grain and temperature,Quick temp. image.
RCS Log:
RCS Log:Revision 4.6  2000/01/10 14:57:00  rcatwood
RCS Log:Quick SIGTERM handler in ca_wrapper
RCS Log:
RCS Log:Revision 4.5  1999/12/23 18:12:24  rcatwood
RCS Log:Version used for Mcwasp runs
RCS Log:
RCS Log:Revision 4.4  1999/12/23 18:09:21  rcatwood
RCS Log:Solute arrays migrated to structure.
RCS Log:
RCS Log:Revision 4.3  1999/12/21 10:26:15  rcatwood
RCS Log:Solute arrays migrated to structure.
RCS Log:
RCS Log:Revision 4.2  1999/12/16 19:15:49  rcatwood
RCS Log:Alloy and gas diffusion working, pores working. Changed file name for conc. output A for alloy C for gas conc.
RCS Log:
RCS Log:Revision 4.1  1999/12/16 13:33:44  rcatwood
RCS Log:Finalised improved use of RCS in all files.
RCS Log:
RCS Log:Revision 4.0.2.1  1999/12/16 12:37:36  rcatwood
RCS Log:Improving rcs id for all files, this may require several checkins to test.
RCS Log:
*/



