/*$Id: ph_input_struct_reader.c 892 2006-03-10 15:24:59Z rcatwood $*/
/* AUTOGENERATED structure input routine */
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <string.h>
#include "../machine.h"
/*TO DO: MANUALLY ADD the header for the structure */
#include "phasediag.h"
#include "ph_input.h"
/*TO DO: MANUALLY ADD strings or other structures not implemented */
/*TO DO: MANUALLY REMOVE purely internal variables and flags (not to be read in) */
/* start of structure ph_input_struct */
void free_input(struct ph_input_struct *Struct_Ptr){
   int i;
   free(Struct_Ptr->filename);
   for (i=0;i<Struct_Ptr->nphases;i++){
      free(Struct_Ptr->phase[i]);
   }
   free(Struct_Ptr->phase);
   free(Struct_Ptr->region);
return;
}
void set_ph_input_defaults(struct ph_input_struct *Struct_Ptr){
   memset (Struct_Ptr,0,sizeof(struct ph_input_struct));
   Struct_Ptr->nregions = -1;

return;
}

void input_ph_input_struct_values(char * filename,struct ph_input_struct *Struct_Ptr){
   int i;
   static int phasectr=0,regctr=0,compctr=0;

   char *line;
   char *token;
   FILE *fp;
   char *sep;
   line = (char *)calloc(MAX_STRING_LEN,sizeof(char));
   sep = strdup(" ,;\t\n\r") ;
   set_ph_input_defaults(Struct_Ptr);

   Struct_Ptr->filename = (char *) calloc(MAX_STRING_LEN,sizeof(char));
   
   /*********************************************************/
   /* Open the control file                                 */
   /*********************************************************/
   if((fp = fopen(filename,"r")) == NULL) {
      fprintf(stderr,"ERROR: ph_input_struct reader: can't open input file [%s]\n",filename);
      return;
    }

   while (fgets(line, MAX_STRING_LEN, fp) != NULL) {
      /* ignore comment and blank lines */
      if(line[0]=='%' || line[0]=='#'||(token = strtok(line,sep))==NULL) {
	      continue;
/* Input section for char pointer: * filename */ 
      }else if (strcasecmp(token,"filename")==0){
         if ((token = strtok(NULL, sep)) != NULL){
            sprintf(Struct_Ptr->filename,token);
         }
      /*
      }else if (strcasecmp(token,"ncomp")==0){
         if ((token = strtok(NULL, sep)) != NULL){
            Struct_Ptr->ncomp = atoi(token);
         }
      */
      }else if (strcasecmp(token,"Tstart")==0){
         if ((token = strtok(NULL, sep)) != NULL){
            Struct_Ptr->Tstart = (double)atof(token);
         }
      }else if (strcasecmp(token,"Tend")==0){
         if ((token = strtok(NULL, sep)) != NULL){
            Struct_Ptr->Tend = (double)atof(token);
         }
      }else if (strcasecmp(token,"Tmin")==0){
         if ((token = strtok(NULL, sep)) != NULL){
            Struct_Ptr->Tmin = (double)atof(token);
         }
      }else if (strcasecmp(token,"Tmax")==0){
         if ((token = strtok(NULL, sep)) != NULL){
            Struct_Ptr->Tmax = (double)atof(token);
         }
      }else if (strcasecmp(token,"Tstep")==0){
         if ((token = strtok(NULL, sep)) != NULL){
            Struct_Ptr->Tstep = (double)atof(token);
         }
/* Input loop for array: Climits*/
      }else if (strcasecmp(token,"Climits")==0){
         for(i=0;i<6;i++){
            if ((token = strtok(NULL, sep)) != NULL){
               Struct_Ptr->Climits[i] = (double)atof(token);
            }
         }/* end of array input loop */
      }else if (strcasecmp(token,"ncomp")==0){
         if ((token = strtok(NULL, sep)) != NULL){
            Struct_Ptr->ncomp = atoi(token);
            Struct_Ptr->components = (char **) calloc(Struct_Ptr->ncomp,sizeof(char *));
         }

/* Input section for char pointer: *      components */ 
      }else if (strcasecmp(token,"comp")==0){
         if ( Struct_Ptr->ncomp <= 0 ){
             fprintf(stderr,"ERROR:ph_input_struct_reader: Number of components not defined!\n");
         } else if ((token = strtok(NULL, sep)) != NULL){
            
            if (compctr >= Struct_Ptr->ncomp){
             fprintf(stderr,"ERROR:ph_input_struct_reader: Too many components!\n");
            }else{
               Struct_Ptr->components[compctr] = (char *) calloc(MAX_STRING_LEN,sizeof(char));
               snprintf(Struct_Ptr->components[compctr],MAX_STRING_LEN,token);
               compctr++;
            }
         }

/* input the phase list */
      }else if (strcasecmp(token,"nphases")==0){
         if ((token = strtok(NULL, sep)) != NULL){
            Struct_Ptr->nphases = atoi(token);
            Struct_Ptr->phase = (char **) calloc(Struct_Ptr->nphases,sizeof(char *));
         }
/* Input section for char pointer: *      phase */ 
      }else if (strcasecmp(token,"phase")==0){
         if ( Struct_Ptr->nphases <= 0 ){
             fprintf(stderr,"ERROR:ph_input_struct_reader: Number of phases not defined!\n");
         } else if ((token = strtok(NULL, sep)) != NULL){
            
            if (phasectr >= Struct_Ptr->nphases){
             fprintf(stderr,"ERROR:ph_input_struct_reader: Too many phases!\n");
            }else{
               Struct_Ptr->phase[phasectr] = (char *) calloc(MAX_STRING_LEN,sizeof(char));
               snprintf(Struct_Ptr->phase[phasectr],MAX_STRING_LEN,token);
               phasectr++;
            }
         }
      }else if (strcasecmp(token,"nregions")==0){
         if ((token = strtok(NULL, sep)) != NULL){
            Struct_Ptr->nregions = atoi(token);
            Struct_Ptr->region = (Pd_num_t (*) [6])  calloc(Struct_Ptr->nregions,sizeof(Pd_num_t [6]));
         }
/* Input loop for array: Cmax*/
      }else if (strcasecmp(token,"region")==0){
         if ( Struct_Ptr->nregions <= 0 ){
         fprintf(stderr,"ERROR:ph_input_struct_reader: Number of phases not defined!\n");
         } else{
            for(i=0;i<6;i++){
               if ((token = strtok(NULL, sep)) != NULL){
                  (*(Struct_Ptr->region + regctr))[i] = (Pd_num_t)atoi(token);
               }
            }/* end of array input loop */
            regctr++;
         }

      }
   }
free(sep);
free(line);
fclose(fp);
}
/* End of structure PhInp */
