/*----------------------------------------------*/
/*						*/
/*      calculate max undercooling map         	*/
/*      crossing the whole time period         	*/
/*                         ly 11/2009	       	*/
/*						*/
/*						*/
/*----------------------------------------------*/

#include "machine.h"
#include "blocks.h"  
#include "props.h"

void sb_max_uc ( BB_struct * bp, int sbnum){

  SB_struct *sp;
  Ctrl_str *cp;
  int i, j ,k;
  int nx, ny, nz;
  int indexnum;
  CA_FLOAT ucmaxtemp, Tliq;
  CA_FLOAT *c_temp, *solute, *fs, *ucmax, *ucmax_t;

  cp = bp->ctrl;
  sp = bp->sb[sbnum];
  
  nx = bp->nc[0];
  ny = bp->nc[1];
  nz = bp->nc[2];
  indexnum = 0;
      
  solute = sp->c_eqv_alloy;
  fs = sp->c_fs;
  c_temp = sp->c_temp;
  ucmax = sp->ucmax;
  ucmax_t = sp->ucmax_t;

  if(bp->ctrl->diffuse_alloy == TRUE && bp->ctrl->decentred_octahedron == TRUE){
    for (k = 0; k < nz; k++){
      for (j = 0; j < ny; j++){
        for (i = 0; i < nx; i++){
	  if (fs[indexnum] == NOT_CASTING) {
	    ucmax[indexnum] = 0;
	  } else if(fs[indexnum] < 0.01) {
	      Tliq = cell_liq_calc (solute[indexnum], &(bp->mprops));
	      ucmaxtemp = Tliq - c_temp[indexnum];
	      if ( ucmax[indexnum] <= ucmaxtemp) {
	        ucmax[indexnum] = ucmaxtemp;
	        ucmax_t[indexnum] = bp->sim_time;
	      }
	  } 
          indexnum ++;
        }
      }
    } // i, j ,k
  } else if ( bp->ctrl->diffuse_alloy == FALSE){
      for (k = 0; k < nz; k++){
        for (j = 0; j < ny; j++){
          for (i = 0; i < nx; i++){
            if (fs[indexnum] == NOT_CASTING) {
              ucmax[indexnum] = 0;
            } else if(fs[indexnum] < 0.1) {
	        Tliq = bp->mprops.Tliq - c_temp[indexnum];
		ucmaxtemp = Tliq - c_temp[indexnum];
		if ( ucmax[indexnum] <= ucmaxtemp) {
	          ucmax[indexnum] = ucmaxtemp;
		  ucmax_t[indexnum] = bp->sim_time;
		}
	      }
	    indexnum ++;
	  }
        }
      } // i, j ,k
  }
}
