/*$Id: setup_mould_src_function.c 887 2006-03-01 18:21:01Z rcatwood $*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

/* include header files requred by subroutines */
#include "machine.h"
#include "read_ctrl.h"
#include "blocks.h"
#include "mould_sources.h"
void setup_mould_src_function (Ctrl_str * cp, BB_struct * bp, Solute_props * sp)
{

       /*******************************************/
  /* set up the mould source function */
       /*******************************************/
  fprintf (stderr, "SETUP_MOULD_SRC_FUNCTION: setting up the mould source function...\n");
  switch (sp->mould_src) {
  case (MouldSourceNONE):
    fprintf (stderr, "SETUP_MOULD_SRC_FUNCTION: Zero source function defined.\n");
    sp->mould_src_func = none_mould_src;
    break;
  case (MouldSourceCONSTANT):
    /* constant */
    fprintf (stderr, "SETUP_MOULD_SRC_FUNCTION: mould source function is CONSTANT\n");
    sp->mould_src_func = const_mould_src;
    break;
  case (MouldSourceDIFF):
    /* difference */
    fprintf (stderr, "SETUP_MOULD_SRC_FUNCTION: mould source function is DIFF\n");
    sp->mould_src_func = diff_mould_src;
    break;
  case (MouldSourcePLIN):
    /* piecewise linear */
    fprintf (stderr, "SETUP_MOULD_SRC_FUNCTION: mould source function is PLIN (piecewise linear)\n");
    sp->mould_src_func = plin_mould_src;
    break;
  case (MouldSourceFLUX):
    /* piecewise linear */
    fprintf (stderr, "SETUP_MOULD_SRC_FUNCTION: mould source function is FLUX \n");
    sp->mould_src_func = flux_mould_src;
    break;
  default:
    fprintf (stderr, "ERROR: SETUP_MOULD_SRC_FUNCTION: Invalid function defined, %i.\n", sp->mould_src);
    exit (0);
    break;
  }
  if (sp->mould_src_pert) {
    /* perturbed function */
    fprintf (stderr, "SETUP_MOULD_SRC_FUNCTION: mould source function is PERTURBED\n");
    sp->mould_src_func = perturb_mould_src;
  }
       /*******************************************/
  return;
}

/***************************************************/
/* rcs id routine to include rcs id in the program */
/* generated by make_rcs_sub.sh script             */
/***************************************************/
char const *setup_mould_src_function_c ()
{
  static char const rcsid[] = "$Id: setup_mould_src_function.c 887 2006-03-01 18:21:01Z rcatwood $";

  return (rcsid);
}
