/****************************************************************/
/*   Copyright (c) 1998 Dept. of Materials, ICSTM               */
/*   All Rights Reserved                                        */
/*   THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF ICSTM       */
/*   The copyright notice above does not evidence any           */
/*   actual or intended publication of such source code,        */
/*   and is an unpublished work by Dept. of Materials, ICSTM.   */
/*   This material contains CONFIDENTIAL INFORMATION that       */
/*   is the property of Imperial College. Any use,              */
/*   duplication or disclosure not specifically authorized      */
/*   by Imperial College is strictly prohibited.                */
/****************************************************************/
/* This code is part of the umats routines developed at in the  */
/* Materials Processing Group, Dept. of Materials, ICSTM.       */
/*      email p.d.lee or r.atwood @ic.ac.uk for details         */
/****************************************************************/

/****************************************************************/
/* solprops.h                                                   */
/* Header file defining concentrationsolution related structures*/
/****************************************************************/
/****************************************************************/
/* Written by Peter D. Lee & Robert C. Atwood, Imperial College */
/* june 28, 1999                                                 */
/*RCS Id:$Id: solprops.h 932 2006-08-30 12:39:33Z rcatwood $*/
/****************************************************************/

#ifndef SOLPROPS_H
#define SOLPROPS_H
#define SOLPROPREV "solprops.h $Revision: 932 $"


struct bigblock;

/****************************************************************/
/*  the solute S_struct structure, which holds                */
/*  information about the solute and pahse diagram              */
/*  for a whole subblock (extensive values eg average, total..) */
/****************************************************************/
typedef struct sb_solprops {
   CA_FLOAT Cinit;         /* the initial concentration [mol/m^3] */

   CA_FLOAT Cmax;          /* max concentration of whole sb     */
   CA_FLOAT CLmax;          /* max concentration of whole sb     */
   CA_FLOAT CLmin;          /* max concentration of whole sb     */

   CA_FLOAT Cavg;          /* Avg. concentration of whole sb     */
   CA_FLOAT Ctot;          /* tot. concentration of whole sb     */
   CA_FLOAT Cmin;          /* min concentration of whole sb     */
   CA_FLOAT addsol;        /* keep track of the amount of solute */
   CA_FLOAT t_addsol;      /* keep tracke of added solute */
} S_struct;

/* structure for the properties associated with one component */
/* ie. gas or alloy in the basic configuration */
typedef struct solprops {
   char my_name[32]; /* store the name of the solute */
   int my_type; /* 0=gas 1=alloy */
   int my_num;  /* index in the array for alloy */
   int NUM_PHS;
   CA_FLOAT Cinit;
   CA_FLOAT Dliq;
   CA_FLOAT Dsol[NPHAMAX];
    /* coefficients for determining arrhenius eqn for diffusion coeff. */
   CA_FLOAT QaLiq;
   CA_FLOAT DoLiq;
   CA_FLOAT QaSol[NPHAMAX];
   CA_FLOAT DoSol[NPHAMAX];

   SrcFn_T mould_src;           /* choose the type of mould function 0=none */
   CA_FLOAT mould_source_value;
   int mould_src_pert;          /* perturb the mould source? */

   CA_FLOAT part_coef[NPHAMAX]; /*Solute partition coefficient for each equilibrium*/
   CA_FLOAT cs_stoechio; 
   CA_FLOAT km;
   CA_FLOAT kminv;
   CA_FLOAT c_eut;
/*   CA_FLOAT T_liq;*/  /*?*/
/*   CA_FLOAT T_pure;*/ /*?*/
   CA_FLOAT T_eut;
   CA_FLOAT Fs_eut;
   CA_FLOAT m_solute[NPHAMAX]; /*solute slope for each equilibrium surface*/
   CA_FLOAT m_inv_solute;
   CA_FLOAT surf_tens_coef;

   CA_FLOAT coef_doutre; 

   CA_FLOAT (*mould_src_func)(struct bigblock *bp, struct solprops *sp, CA_FLOAT cell_temp, CA_FLOAT conc, int i, int j, int k);
}Solute_props;

#endif /* SOLPROPS_H */
/*
RCS Log:$Log$
RCS Log:Revision 11.2  2006/08/30 12:39:27  rcatwood
RCS Log:Added a constant name step.blz block restart file output
RCS Log:
RCS Log:Revision 11.1  2006/03/01 18:20:40  rcatwood
RCS Log:Merging polycomponent and gas with meltback
RCS Log:
RCS Log:Revision 10.2.2.8  2006/02/20 14:51:23  rcatwood
RCS Log:Correced evil log message
RCS Log:
RCS Log:Revision 10.2.2.7  2006/02/20 12:00:13  lthuinet
RCS Log: A lot of modifications : add an option to treat correctly diffusion in the case the secondary eutectic phase is stoechiometric AND add a pointer to distinguish the nature of the cell and the nature of the grain
RCS Log:
RCS Log:Revision 10.2.2.6  2006/02/01 14:16:25  lthuinet
RCS Log:#update change of the calculation of supersaturation for gas in multicomponent
RCS Log:
RCS Log:Revision 10.2.2.5  2006/01/20 16:28:22  lthuinet
RCS Log:*** empty log message ***
RCS Log:
RCS Log:Revision 10.2.2.4  2006/01/18 15:51:20  rcatwood
RCS Log:Removed some multi and merged wti ludovic
RCS Log:
RCS Log:Revision 10.2.2.3  2006/01/18 12:01:17  lthuinet
RCS Log:*** empty log message ***
RCS Log:
RCS Log:Revision 10.2.2.2  2006/01/11 16:31:31  rcatwood
RCS Log:Altered the use of solute information to conform with the new solute information structure table
RCS Log:
RCS Log:Revision 10.2.2.1  2006/01/10 13:58:24  rcatwood
RCS Log:Temporary branch for merging lthuinet poly-component and main branch
RCS Log:
RCS Log:Revision 10.2  2005/12/01 14:38:02  rcatwood
RCS Log:Merged xly_05 changes into the main trunk
RCS Log:Primarily involving melt-back
RCS Log:
RCS Log:Revision 10.1.2.2  2005/11/23 18:18:53  rcatwood
RCS Log:Result of merging mould_source and xly meltback+curvature 2d versions
RCS Log:
RCS Log:Revision 10.1  2005/11/03 11:56:47  rcatwood
RCS Log:New version number -- using mould_src as base
RCS Log:
RCS Log:Revision 8.1.12.2  2005/11/02 11:55:06  rcatwood
RCS Log:Fixing up the revision nubmer after loss of repository
RCS Log:
RCS Log:Revision 9.2.4.2  2004/03/09 11:30:54  rcatwood
RCS Log:Changed to read materials properties from separate files for alloy and gas
RCS Log:
RCS Log:Revision 9.2.4.1  2004/03/04 11:29:25  rcatwood
RCS Log:*** empty log message ***
RCS Log:
RCS Log:Revision 9.2  2003/10/27 20:01:12  rcatwood
RCS Log:Harmonized header file cpp protection
RCS Log:Fixed filename bug for restart
RCS Log:
RCS Log:Revision 9.1  2003/08/14 14:38:40  rcatwood
RCS Log:Working merge with decentered/porosity/procast, also including
RCS Log:Ali Chirazi's multicomponent (not tested in this version)
RCS Log:
RCS Log:Revision 8.1.6.2  2003/05/19 18:55:17  rcatwood
RCS Log:Addded option to allow horizontal or vertical directional growth
RCS Log:and flux boundary condition
RCS Log:
RCS Log:Revision 8.1.6.1  2003/01/22 16:53:47  rcatwood
RCS Log:Almost working read_fg version
RCS Log:
RCS Log:Revision 8.1  2002/10/17 17:01:03  rcatwood
RCS Log:New version number! for decentered/porosity merge! Alpha Version!
RCS Log:
RCS Log:Revision 7.0  2000/11/07 15:55:38  rcatwood
RCS Log:Multi Cell Pores added
RCS Log:
RCS Log:Revision 6.0  2000/09/25 18:03:37  rcatwood
RCS Log:After PORE_00 and NLM
RCS Log:
RCS Log:Revision 2.0  2000/08/02 10:21:56  rcatwood
RCS Log:Version used for pore paper runs
RCS Log:
RCS Log:Revision 1.1  2000/05/22 12:29:24  rcatwood
RCS Log:Fixed fs finish. Casolid to C from  W file. Global option
RCS Log:
RCS Log:Revision 5.1  2000/03/02 16:11:10  rcatwood
RCS Log:Merged xxu and rca versions
RCS Log:
RCS Log:Revision 5.0.2.1  2000/03/01 15:54:30  rcatwood
RCS Log:merged VAR and Multiblock updates. Not tested
RCS Log:
RCS Log:Revision 5.0.1.1  2000/02/22 19:04:27  rcatwood
RCS Log:Not yet tested
RCS Log:
RCS Log:Revision 4.3  2000/02/15 15:29:11  rcatwood
RCS Log:Version after McWasp submitted
RCS Log:
RCS Log:Revision 4.2  1999/12/23 18:12:24  rcatwood
RCS Log:Version used for Mcwasp runs
RCS Log:
RCS Log:Revision 4.1  1999/12/16 13:33:44  rcatwood
RCS Log:Finalised improved use of RCS in all files.
RCS Log:
RCS Log:Revision 4.0.2.1  1999/12/16 12:37:36  rcatwood
RCS Log:Improving rcs id for all files, this may require several checkins to test.
RCS Log:
*/
