/*RCS Id:$Id: write_header_ctrl.c 887 2006-03-01 18:21:01Z rcatwood $*/
/*Print all the control structure values into the header for output files */

#include <stdio.h>
#include "machine.h"
#ifdef TEST_MAIN
#include "read_ctrl_adsr.h"
#else
#include "blocks.h"
#include "read_ctrl.h"
#endif
void write_header_ctrl (FILE * ffp, BB_struct * bp)
{
  extern void write_bb_values (FILE * fp, BB_struct * bp);
  Ctrl_str *cp;

  cp = bp->ctrl;

  fprintf (ffp, "COMPILAITION FLAGS\n");
  fprintf (ffp, "%s\n", cp->cflags);
  /* FILES FOR INPUT              */
  fprintf (ffp, ",cp->fn_base,%s", cp->fn_base);
  if (cp->cap)
    fprintf (ffp, ",cp->fn_cap,%s", cp->fn_cap);
  fprintf (ffp, ",cp->fn_geo,%s", cp->fn_geo);
  fprintf (ffp, ",cp->fn_mat,%s", cp->fn_mat);
  if (cp->input)
    fprintf (ffp, ",cp->fn_inp,%s", cp->fn_inp);

  write_bb_values (ffp, bp);

#ifdef JUNK
  fprintf (ffp, "CONTROL STRUCTURE VALUES\n");

/*******************************************/
/* Control structure values                */
/*******************************************/
  fprintf (ffp, "cp->solo,%i", cp->solo);
  fprintf (ffp, ",cp->cap,%i", cp->cap);
  fprintf (ffp, ",cp->post,%i", cp->post);
  fprintf (ffp, ",cp->input,%i", cp->input);
  fprintf (ffp, ",cp->con_cast,%i", cp->con_cast);
  fprintf (ffp, "\n");
  fprintf (ffp, "cp->particle,%i", cp->particle);
  fprintf (ffp, ",cp->diffuse,%i", cp->diffuse);
  fprintf (ffp, ",cp->pore,%i", cp->pore);
  fprintf (ffp, ",cp->diffuse_alloy,%i", cp->diffuse_alloy);
  fprintf (ffp, ",cp->diffuse_alloy_multi,%i", cp->diffuse_alloy_multi);
  fprintf (ffp, ",cp->show_eut,%i", cp->show_eut);
  fprintf (ffp, "\n");
  fprintf (ffp, "cp->phase_diag_on,%i", cp->phase_diag_on);
  fprintf (ffp, ",cp->global_undercooling,%i", cp->global_undercooling);
  fprintf (ffp, "cp->phase_diag_on,%i", cp->phase_diag_on);
  fprintf (ffp, ",cp->diffuse_step,%i", cp->diffuse_step);
  /* sensitivity study factors */
#ifdef SENS
  fprintf (ffp, "\n");
  fprintf (ffp, "cp->sens_DIFF,%.5g", cp->sens_DIFF);
  fprintf (ffp, ",cp->sens_SOL,%.5g", cp->sens_SOL);
  fprintf (ffp, ",cp->sens_PRESS,%.5g", cp->sens_PRESS);
  fprintf (ffp, ",cp->sens_SURFTENS,%.5g", cp->sens_SURFTENS);
  fprintf (ffp, "\n");
#endif /*SENS*/
    fprintf (ffp, "\n");
  /* Control of CA neighbourhood  */
  fprintf (ffp, "cp->ca_method,%i", cp->ca_method);
  fprintf (ffp, ",cp->scheil,%i", cp->scheil);
  fprintf (ffp, ",cp->n_neigh,%i", cp->n_neigh);
  fprintf (ffp, ",cp->seed,%d", cp->seed);

  /* FILES FOR INPUT              */
  fprintf (ffp, ",cp->fn_base,%s", cp->fn_base);
  if (cp->cap)
    fprintf (ffp, ",cp->fn_cap,%s", cp->fn_cap);
  fprintf (ffp, ",cp->fn_geo,%s", cp->fn_geo);
  fprintf (ffp, ",cp->fn_mat,%s", cp->fn_mat);
  if (cp->input)
    fprintf (ffp, ",cp->fn_inp,%s", cp->fn_inp);
  /* VARIABLES RELATED TO OUTPUT  */
  fprintf (ffp, "\n");
  fprintf (ffp, "cp->nsbslice,%i", cp->nsbslice);
  fprintf (ffp, ",cp->nbbslice,%i", cp->nbbslice);
  fprintf (ffp, ",cp->pore_dump_sb,%i", cp->pore_dump_sb);

  fprintf (ffp, ",cp->slice_dmp_freq,%i", cp->slice_dmp_freq);
  fprintf (ffp, ",cp->tempslice,%i", cp->tempslice);
  fprintf (ffp, ",cp->floatdump,%i", cp->floatdump);
  fprintf (ffp, ",cp->excel,%i", cp->excel);

  fprintf (ffp, "\n");
  fprintf (ffp, "cp->scr_dmp_freq,%i", cp->scr_dmp_freq);
  fprintf (ffp, ",cp->nscrdumps,%i", cp->nscrdumps);
  fprintf (ffp, ",cp->rgbmode,%i", cp->rgbmode);
  fprintf (ffp, ",cp->rgbgrey,%i", cp->rgbgrey);
  fprintf (ffp, ",cp->conc_prof,%i,%i,%i", cp->conc_prof[0], cp->conc_prof[1], cp->conc_prof[2]);
  /* VARIABLES FOR CONCENTRATION OUTPUT */
  fprintf (ffp, "\n");
  fprintf (ffp, "cp->diff_rgbmode,%i", cp->diff_rgbmode);
  fprintf (ffp, ",cp->diff_log_disp,%i", cp->diff_log_disp);
  fprintf (ffp, ",cp->diff_ratio_disp,%i", cp->diff_ratio_disp);
  fprintf (ffp, ",cp->alloy_disp_max,%.5g", cp->alloy_disp_max);
  fprintf (ffp, ",cp->gas_disp_max,%.5g", cp->gas_disp_max);
  fprintf (ffp, ",cp->diff_disp_cap,%i", cp->diff_disp_cap);
  /* VARIABLES RELATED TO TESTING */
  fprintf (ffp, "\n");
  fprintf (ffp, "cp->fixed_Pore,%i", cp->fixed_Pore);
  fprintf (ffp, ",cp->nfPore,%i", cp->nfPore);
  fprintf (ffp, ",cp->fixed_nuc,%i", cp->fixed_nuc);
  fprintf (ffp, ",cp->nfnuc,%i", cp->nfnuc);
  fprintf (ffp, ",cp->coolrate,%i", cp->coolrate);
  fprintf (ffp, ",cp->fs_finish,%.5g", cp->fs_finish);
  fprintf (ffp, ",cp->delT,%.5g", cp->delT);
  fprintf (ffp, "\n");

/*******************************************/
/* end Control structure values            */
/*******************************************/
#endif /*JUNK*/
}

/* Little subroutine to get rcs id into the object code */
/* so you can use ident on the compiled program  */
/* also you can call this to print out or include the rcs id in a file */
char const *rcs_id_write_header_ctrl_c ()
{
  static char const rcsid[] = "$Id: write_header_ctrl.c 887 2006-03-01 18:21:01Z rcatwood $";

  return (rcsid);
}

/* end of rcs_id_subroutine */
/*
RCS Log:$Log$
RCS Log:Revision 11.1  2006/03/01 18:20:40  rcatwood
RCS Log:Merging polycomponent and gas with meltback
RCS Log:
RCS Log:Revision 10.3  2005/12/01 14:38:02  rcatwood
RCS Log:Merged xly_05 changes into the main trunk
RCS Log:Primarily involving melt-back
RCS Log:
RCS Log:Revision 10.1.2.2  2005/11/23 18:18:53  rcatwood
RCS Log:Result of merging mould_source and xly meltback+curvature 2d versions
RCS Log:
RCS Log:Revision 10.1  2005/11/03 11:56:48  rcatwood
RCS Log:New version number -- using mould_src as base
RCS Log:
RCS Log:Revision 8.1.14.2  2005/11/02 11:55:06  rcatwood
RCS Log:Fixing up the revision nubmer after loss of repository
RCS Log:
RCS Log:Revision 9.1  2003/08/14 14:38:41  rcatwood
RCS Log:Working merge with decentered/porosity/procast, also including
RCS Log:Ali Chirazi's multicomponent (not tested in this version)
RCS Log:
RCS Log:Revision 8.1.8.3  2003/08/14 14:18:05  rcatwood
RCS Log:Working ca_procast new version, on linux
RCS Log:Added surface nucleation
RCS Log:Added mould source term
RCS Log:Changed printout headers
RCS Log:Temperature output image
RCS Log:
RCS Log:Revision 8.1.8.2  2003/01/15 19:02:02  rcatwood
RCS Log:*** empty log message ***
RCS Log:
RCS Log:Revision 8.1.6.1  2002/11/06 17:27:48  rcatwood
RCS Log:NOT WORKING check-in of first stage merge with ca_procast
RCS Log:
RCS Log:Revision 8.1  2002/10/17 17:01:04  rcatwood
RCS Log:New version number! for decentered/porosity merge! Alpha Version!
RCS Log:
RCS Log:Revision 7.3  2002/04/22 16:09:04  rcatwood
RCS Log:Added compression for bin files
RCS Log:
RCS Log:Revision 7.2  2001/04/10 12:17:21  rcatwood
RCS Log: added listing of compilation flags to control header output (requres Makefile modification)
RCS Log:
*/
