/****************************************************************/
/*   Copyright (c) 1998 Dept. of Materials, ICSTM               */
/*   All Rights Reserved                                        */
/*   THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF ICSTM       */
/*   The copyright notice above does not evidence any           */
/*   actual or intended publication of such source code,        */
/*   and is an unpublished work by Dept. of Materials, ICSTM.   */
/*   This material contains CONFIDENTIAL INFORMATION that       */
/*   is the property of Imperial College. Any use,              */
/*   duplication or disclosure not specifically authorized      */
/*   by Imperial College is strictly prohibited.                */
/****************************************************************/
/* This code is part of the umats routines developed at in the  */
/* Materials Processing Group, Dept. of Materials, ICSTM.       */
/*      email p.d.lee or r.atwood @ic.ac.uk for details         */
/****************************************************************/
/*RCS Id:$Id: writeblocks.h 887 2006-03-01 18:21:01Z rcatwood $*/
#ifndef WRITEBLOCKS_H
#define WRITEBLOCKS_H

/* functions used from output_img.c */
#ifdef JUNK
extern int pore_write_bb_conc(BB_struct *bp,Value_struct *val);
#endif /*JUNK*/
extern int pore_write(BB_struct *bp);
extern int write_bb_bin(BB_struct *bp,int testflag);
extern int write_bb_conc(BB_struct *bp,Value_struct * val);
extern int write_slice(BB_struct *bp, int sbnum, int slice);
extern int write_slice_conc(BB_struct *bp,Value_struct * out_values,int sbnum, int slice);
extern int write_bb_slice(BB_struct *bp, int slice);
extern int write_slice_fs(BB_struct *bp, int sbnum, int slice);
extern int write_slice_diff(BB_struct *bp, int sbnum, int slice);
extern int write_slice_sat(BB_struct *bp, int sbnum, int slice);
extern int write_slice_curv (BB_struct * bp, int sbnum, int slice);
extern int write_bb_T_slice(BB_struct *bp, int slice);
extern void write_shortint_slice(BB_struct *bp, int sbnum, int slice);
extern int avs_pores(BB_struct *bp,int sbnum);
extern void write_sb_slice_temp(BB_struct *bp, int sbnum, int slice);
extern int      write_slice_undercool(BB_struct *bp, int sbnum, int slice) ;
/* from output_ex.c */
extern int write_bb_excel(int stat_flag, BB_struct *bp); 
extern int write_bb_excel_sum(int stat_flag, BB_struct *bp);
#endif /*WRITEBLOCKS_H*/
/*
RCS Log:$Log$
RCS Log:Revision 11.1  2006/03/01 18:20:40  rcatwood
RCS Log:Merging polycomponent and gas with meltback
RCS Log:
RCS Log:Revision 10.2.2.1  2006/02/01 14:36:48  rcatwood
RCS Log:solved all implicit function declarations
RCS Log:
RCS Log:Revision 10.2  2005/12/01 14:38:02  rcatwood
RCS Log:Merged xly_05 changes into the main trunk
RCS Log:Primarily involving melt-back
RCS Log:
RCS Log:Revision 10.1.2.2  2005/11/23 18:18:53  rcatwood
RCS Log:Result of merging mould_source and xly meltback+curvature 2d versions
RCS Log:
RCS Log:Revision 10.1  2005/11/03 11:56:48  rcatwood
RCS Log:New version number -- using mould_src as base
RCS Log:
RCS Log:Revision 8.1.12.2  2005/11/02 11:55:06  rcatwood
RCS Log:Fixing up the revision nubmer after loss of repository
RCS Log:
RCS Log:Revision 9.2  2003/11/18 13:22:41  rcatwood
RCS Log:Added routines to find and store the interface cells between the casting and the mould.
RCS Log:Added the surface cell storage structure to the subblock.
RCS Log:Improved mould source and nucleation  routines to use the surface cell structure
RCS Log:
RCS Log:Revision 9.1  2003/08/14 14:38:41  rcatwood
RCS Log:Working merge with decentered/porosity/procast, also including
RCS Log:Ali Chirazi's multicomponent (not tested in this version)
RCS Log:
RCS Log:Revision 8.1.6.2  2003/08/14 14:18:05  rcatwood
RCS Log:Working ca_procast new version, on linux
RCS Log:Added surface nucleation
RCS Log:Added mould source term
RCS Log:Changed printout headers
RCS Log:Temperature output image
RCS Log:
RCS Log:Revision 8.1.6.1  2003/02/27 23:04:40  rcatwood
RCS Log:Removed use of old temperature routines , all temperatures shoudl
RCS Log:be determined by checking the array c_temp in teh subblock, if the
RCS Log:subblock is open
RCS Log:
RCS Log:Revision 8.1  2002/10/17 17:01:04  rcatwood
RCS Log:New version number! for decentered/porosity merge! Alpha Version!
RCS Log:
RCS Log:Revision 7.3  2002/10/17 16:52:39  rcatwood
RCS Log:Merge from branch: combined Robert (porosity) and Wei (decentered octahedron) versions
RCS Log:
RCS Log:Revision 7.2.8.1  2002/09/18 12:36:16  rcatwood
RCS Log:Split step output function into a subroutine (called from ca_solid)
RCS Log:Removed some lint errors.
RCS Log:
RCS Log:Revision 7.2  2002/06/18 18:16:50  rcatwood
RCS Log:changed pore output: just pore P_ONLY file and .por list file
RCS Log:
RCS Log:Revision 7.1  2000/11/18 15:40:01  rcatwood
RCS Log:fixed outpput
RCS Log:
RCS Log:Revision 7.0  2000/11/07 15:55:38  rcatwood
RCS Log:Multi Cell Pores added
RCS Log:
RCS Log:Revision 6.0  2000/09/25 18:03:36  rcatwood
RCS Log:After PORE_00 and NLM
RCS Log:
RCS Log:Revision 2.0  2000/08/02 10:21:56  rcatwood
RCS Log:Version used for pore paper runs
RCS Log:
RCS Log:Revision 1.2  2000/07/11 16:33:44  rcatwood
RCS Log:Changed pore output.
RCS Log:
RCS Log:Revision 1.1  2000/05/22 12:29:24  rcatwood
RCS Log:Fixed fs finish. Casolid to C from  W file. Global option
RCS Log:
RCS Log:Revision 5.1  2000/03/02 16:11:10  rcatwood
RCS Log:Merged xxu and rca versions
RCS Log:
RCS Log:Revision 5.0.2.1  2000/03/01 15:54:30  rcatwood
RCS Log:merged VAR and Multiblock updates. Not tested
RCS Log:
RCS Log:Revision 5.0.1.2  2000/02/29 18:00:25  rcatwood
RCS Log:Bug fixed when growing into new block
RCS Log:
RCS Log:Revision 5.0.1.1  2000/02/22 19:04:27  rcatwood
RCS Log:Not yet tested
RCS Log:
RCS Log:Revision 4.5  2000/01/20 17:41:17  rcatwood
RCS Log:Pore bug fix. Bindump of fs, ss, diff coeff
RCS Log:
RCS Log:Revision 4.4  1999/12/23 18:12:24  rcatwood
RCS Log:Version used for Mcwasp runs
RCS Log:
RCS Log:Revision 4.3  1999/12/21 10:26:15  rcatwood
RCS Log:Solute arrays migrated to structure.
RCS Log:
RCS Log:Revision 4.2  1999/12/16 19:15:49  rcatwood
RCS Log:Alloy and gas diffusion working, pores working. Changed file name for conc. output A for alloy C for gas conc.
RCS Log:
RCS Log:Revision 4.1  1999/12/16 13:33:44  rcatwood
RCS Log:Finalised improved use of RCS in all files.
RCS Log:
RCS Log:Revision 4.0.2.1  1999/12/16 12:37:36  rcatwood
RCS Log:Improving rcs id for all files, this may require several checkins to test.
RCS Log:
*/

